/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.directoryProcessor;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import psidev.psi.mi.tab.directoryProcessor.InputDirectoryProcessorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBasedFilenameSelection
implements InputDirectoryProcessorStrategy {
    private boolean recursive = true;
    private Pattern filenameInclude;

    public PatternBasedFilenameSelection(boolean recursive, Pattern filenameIncludePattern) {
        if (filenameIncludePattern == null) {
            throw new IllegalArgumentException("The filename pattern must not be null.");
        }
        this.recursive = recursive;
        this.filenameInclude = filenameIncludePattern;
    }

    @Override
    public Collection<File> process(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("You must give a non null directory.");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("You must give a directory.");
        }
        if (!directory.canRead()) {
            throw new IllegalArgumentException("Read access must be granted before processing this directory.");
        }
        ArrayList<File> collectedFiles = new ArrayList<File>();
        Stack<File> stack = new Stack<File>();
        stack.push(directory);
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            File[] files = file.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (dir.isDirectory()) {
                        return true;
                    }
                    return name.endsWith(".xml");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                File file1 = files[i];
                if (file1.isDirectory()) {
                    if (!this.recursive) continue;
                    stack.push(file1);
                    continue;
                }
                Matcher matcher = this.filenameInclude.matcher(file1.getName());
                if (!matcher.matches()) continue;
                collectedFiles.add(file1);
            }
        }
        return collectedFiles;
    }
}

