/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.avsdf;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.LNodeDegreeSort;
import org.ivis.layout.avsdf.AVSDFCircle;
import org.ivis.layout.avsdf.AVSDFEdge;

public class AVSDFNode
extends LNode {
    private double angle;
    private int circleIndex = -1;
    private int totalCrossingOfEdges = -1;
    private boolean isCrossingNumberValid = false;

    public AVSDFNode(LGraphManager gm, Object vNode) {
        super(gm, vNode);
    }

    public AVSDFNode(LGraphManager gm, Point loc, Dimension size, Object vNode) {
        super(gm, loc, size, vNode);
    }

    public AVSDFCircle getCircle() {
        return (AVSDFCircle)this.getOwner();
    }

    public void setIndex(int circleIndex) {
        this.circleIndex = circleIndex;
        this.isCrossingNumberValid = false;
    }

    public int getIndex() {
        return this.circleIndex;
    }

    public AVSDFNode[] getNeigborsSortedByDegree() {
        Iterator iterator = this.getEdges().iterator();
        ArrayList<AVSDFNode> list = new ArrayList<AVSDFNode>();
        while (iterator.hasNext()) {
            AVSDFEdge edge = (AVSDFEdge)iterator.next();
            AVSDFNode node = edge.getOtherEnd(this);
            if (node.getIndex() != -1) continue;
            list.add(node);
        }
        Object[] temp = list.toArray();
        Object[] array = new AVSDFNode[temp.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (AVSDFNode)temp[i];
        }
        LNodeDegreeSort sort = new LNodeDegreeSort(array);
        if (array.length > 0) {
            sort.quicksort();
        }
        return array;
    }

    public int getDegree() {
        return this.getEdges().size();
    }

    public boolean isOrdered() {
        return this.circleIndex > -1;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public int getCircDistWithTheNode(AVSDFNode refNode) {
        int otherIndex = refNode.getIndex();
        if (otherIndex == -1 || this.getIndex() == -1) {
            return -1;
        }
        int diff = this.getIndex() - otherIndex;
        if (diff < 0) {
            diff += this.getCircle().getSize();
        }
        return diff;
    }

    public int getCrossingNumberWithNode(AVSDFNode otherNode) {
        Iterator iter1 = this.getEdges().iterator();
        int totalCrossing = 0;
        while (iter1.hasNext()) {
            Iterator iter2 = otherNode.getEdges().iterator();
            AVSDFEdge edge = (AVSDFEdge)iter1.next();
            while (iter2.hasNext()) {
                AVSDFEdge otherEdge = (AVSDFEdge)iter2.next();
                totalCrossing += edge.crossingWithEdge(otherEdge);
            }
        }
        return totalCrossing;
    }

    public int getTotalCrossingOfEdges() {
        if (!this.isCrossingNumberValid) {
            this.calculateTotalCrossing();
            this.isCrossingNumberValid = true;
        }
        return this.totalCrossingOfEdges;
    }

    public void calculateTotalCrossing() {
        Iterator iter = this.edges.iterator();
        int count = 0;
        ArrayList temp = new ArrayList();
        temp.addAll(this.getCircle().getEdges());
        temp.removeAll(this.edges);
        while (iter.hasNext()) {
            AVSDFEdge edge = (AVSDFEdge)iter.next();
            count += edge.calculateTotalCrossingWithList(temp);
        }
        this.totalCrossingOfEdges = count;
    }
}

