/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.FactoryTransformer;
import org.apache.commons.collections15.map.AbstractMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyMap<K, V>
extends AbstractMapDecorator<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 7990956402564206740L;
    protected final Transformer<K, V> transformer;

    public static <K, V> Map<K, V> decorate(Map<K, V> map, Factory<V> factory) {
        return new LazyMap<K, V>(map, factory);
    }

    public static <K, V> Map<K, V> decorate(Map<K, V> map, Transformer<K, V> transformer) {
        return new LazyMap<K, V>(map, transformer);
    }

    protected LazyMap(Map<K, V> map, Factory<V> factory) {
        super(map);
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.transformer = new FactoryTransformer<K, V>(factory);
    }

    protected LazyMap(Map<K, V> map, Transformer<K, V> transformer) {
        super(map);
        if (transformer == null) {
            throw new IllegalArgumentException("Transformer must not be null");
        }
        this.transformer = transformer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    @Override
    public V get(Object key) {
        if (!this.map.containsKey(key)) {
            V value = this.transformer.transform(key);
            this.map.put(key, value);
            return value;
        }
        return this.map.get(key);
    }
}

