/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

public final class Cardinality {
    private Cardinality() {
    }

    public static final boolean allowsMany(int n) {
        return (n & 0x8000) != 0;
    }

    public static final boolean allowsZero(int n) {
        return (n & 0x2000) != 0;
    }

    public static final int union(int n, int n2) {
        int n4 = n | n2;
        if (n4 == 40960) {
            n4 = 57344;
        }
        return n4;
    }

    public static final int sum(int n, int n2) {
        if (Cardinality.allowsMany(n) || Cardinality.allowsMany(n2)) {
            return n | n2;
        }
        if (!Cardinality.allowsZero(n) && !Cardinality.allowsZero(n2)) {
            return 49152;
        }
        return 57344;
    }

    public static final boolean subsumes(int n, int n2) {
        return (n | n2) == n;
    }

    public static final int add(int n, int n2) {
        if (n == 8192) {
            return n2;
        }
        if (n2 == 8192) {
            return n;
        }
        boolean bl = Cardinality.allowsZero(n) && Cardinality.allowsZero(n2);
        return 0xC000 | (bl ? 8192 : 0);
    }

    public static final int multiply(int n, int n2) {
        if (n == 8192 || n2 == 8192) {
            return 8192;
        }
        if (n2 == 16384) {
            return n;
        }
        if (n == 16384) {
            return n2;
        }
        if (n == 24576 && n2 == 24576) {
            return 24576;
        }
        if (n == 49152 && n2 == 49152) {
            return 49152;
        }
        return 57344;
    }

    public static String toString(int n) {
        switch (n) {
            case 24576: {
                return "zero or one";
            }
            case 16384: {
                return "exactly one";
            }
            case 57344: {
                return "zero or more";
            }
            case 49152: {
                return "one or more";
            }
            case 8192: {
                return "exactly zero";
            }
            case 32768: {
                return "more than one";
            }
        }
        return "code " + n;
    }

    public static String getOccurrenceIndicator(int n) {
        switch (n) {
            case 24576: {
                return "?";
            }
            case 16384: {
                return "";
            }
            case 57344: {
                return "*";
            }
            case 49152: {
                return "+";
            }
        }
        throw new AssertionError((Object)"unknown cardinality value");
    }
}

