/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingComparator;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class SortedResultSet
implements ResultSet {
    QueryIterator qIter;
    int rowNumber = 0;
    List resultVars = null;
    Model model;

    public SortedResultSet(ResultSet rs, List conditions) {
        this(rs, new BindingComparator(conditions));
    }

    private SortedResultSet(ResultSet rs, Comparator comparator) {
        this.model = rs.getResourceModel();
        TreeSet<Binding> sorted = new TreeSet<Binding>(comparator);
        while (rs.hasNext()) {
            Binding b = rs.nextBinding();
            sorted.add(b);
        }
        this.qIter = new QueryIterPlainWrapper(sorted.iterator());
        this.resultVars = rs.getResultVars();
    }

    public boolean hasNext() {
        return this.qIter.hasNext();
    }

    public Object next() {
        return this.nextBinding();
    }

    public Binding nextBinding() {
        ++this.rowNumber;
        return this.qIter.nextBinding();
    }

    public QuerySolution nextSolution() {
        return new ResultBinding(null, this.nextBinding());
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public boolean isOrdered() {
        return true;
    }

    public Model getResourceModel() {
        return this.model;
    }

    public void remove() {
        throw new UnsupportedOperationException(SortedResultSet.class.getName() + ".remove");
    }

    private Binding copyToBinding(QuerySolution qs) {
        BindingMap b = new BindingMap();
        Iterator iter = qs.varNames();
        while (iter.hasNext()) {
            String varName = (String)iter.next();
            RDFNode rn = qs.get(varName);
            b.add(Var.alloc(varName), rn.asNode());
        }
        return b;
    }
}

