/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.core.OptimizerBase;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.HeuristicBasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import com.hp.hpl.jena.sparql.util.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicPatternOptimizer
extends OptimizerBase {
    private BasicPattern pattern = null;
    private BasicPatternGraph basicPatternGraph = null;
    private HeuristicBasicPattern heuristic = null;
    private static Log log = LogFactory.getLog(BasicPatternOptimizer.class);

    public BasicPatternOptimizer(Context context, Graph graph, BasicPattern pattern, Config config) {
        super(context, graph);
        this.pattern = pattern;
        this.heuristic = config == null ? this.broker.getBasicPatternHeuristic() : this.broker.getBasicPatternHeuristic(config.getBasicPatternHeuristic());
    }

    public HeuristicBasicPattern getHeuristicBasicPattern() {
        return this.heuristic;
    }

    public BasicPattern optimize() {
        log.debug("Init ARQo");
        this.basicPatternGraph = new BasicPatternGraph(this.pattern, this.heuristic);
        return this.basicPatternGraph.optimize();
    }

    public BasicPatternGraph getBasicPatternGraph() {
        if (this.basicPatternGraph == null) {
            this.optimize();
        }
        return this.basicPatternGraph;
    }
}

