/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public class OpVars {
    public static Set patternVars(Op op) {
        HashSet acc = new HashSet();
        OpVars.patternVars(op, acc);
        return acc;
    }

    public static void patternVars(Op op, Set acc) {
        OpWalker.walk(op, new OpVarsPattern(acc));
    }

    public static Set allVars(Op op) {
        HashSet acc = new HashSet();
        OpVars.allVars(op, acc);
        return acc;
    }

    public static void allVars(Op op, Set acc) {
        OpWalker.walk(op, new OpVarsQuery(acc));
    }

    public static void vars(BasicPattern pattern, Collection acc) {
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            OpVars.addVarsFromTriple(acc, triple);
        }
    }

    private static void addVarsFromTriple(Collection acc, Triple t) {
        OpVars.addVar(acc, t.getSubject());
        OpVars.addVar(acc, t.getPredicate());
        OpVars.addVar(acc, t.getObject());
    }

    private static void addVarsFromQuad(Collection acc, Quad q) {
        OpVars.addVar(acc, q.getSubject());
        OpVars.addVar(acc, q.getPredicate());
        OpVars.addVar(acc, q.getObject());
        OpVars.addVar(acc, q.getGraph());
    }

    private static void addVar(Collection acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(n);
        }
    }

    private static class OpVarsQuery
    extends OpVarsPattern {
        OpVarsQuery(Set acc) {
            super(acc);
        }

        public void visit(OpFilter opFilter) {
            opFilter.getExprs().varsMentioned(this.acc);
        }

        public void visit(OpOrder opOrder) {
            Iterator iter = opOrder.getConditions().iterator();
            while (iter.hasNext()) {
                SortCondition sc = (SortCondition)iter.next();
                Set x = sc.getExpression().getVarsMentioned();
                this.acc.addAll(x);
            }
        }
    }

    private static class OpVarsPattern
    extends OpVisitorBase {
        protected Set acc;

        OpVarsPattern(Set acc) {
            this.acc = acc;
        }

        public void visit(OpBGP opBGP) {
            OpVars.vars(opBGP.getPattern(), this.acc);
        }

        public void visit(OpPath opPath) {
            OpVars.addVar(this.acc, opPath.getTriplePath().getSubject());
            OpVars.addVar(this.acc, opPath.getTriplePath().getObject());
        }

        public void visit(OpQuadPattern quadPattern) {
            OpVars.addVar(this.acc, quadPattern.getGraphNode());
            OpVars.vars(quadPattern.getBasicPattern(), this.acc);
        }

        public void visit(OpGraph opGraph) {
            OpVars.addVar(this.acc, opGraph.getNode());
        }

        public void visit(OpDatasetNames dsNames) {
            OpVars.addVar(this.acc, dsNames.getGraphNode());
        }

        public void visit(OpTable opTable) {
            Table t = opTable.getTable();
            this.acc.addAll(t.getVars());
        }

        public void visit(OpProject opProject) {
            this.acc.clear();
            this.acc.addAll(opProject.getVars());
        }

        public void visit(OpAssign opAssign) {
            this.acc.addAll(opAssign.getVarExprList().getVars());
        }
    }
}

