/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class BRWRule {
    protected TriplePattern head;
    protected TriplePattern body;

    public BRWRule(TriplePattern head, TriplePattern body) {
        this.head = head;
        this.body = body;
    }

    public static BRWRule makeRule(String rulespec) {
        StringTokenizer tokenizer = new StringTokenizer(rulespec);
        try {
            Node headS = BRWRule.parseNode(tokenizer.nextToken());
            Node headP = BRWRule.parseNode(tokenizer.nextToken());
            Node headO = BRWRule.parseNode(tokenizer.nextToken());
            TriplePattern head = new TriplePattern(headS, headP, headO);
            if (!tokenizer.nextToken().equals("<-")) {
                throw new NoSuchElementException();
            }
            Node bodyS = BRWRule.parseNode(tokenizer.nextToken());
            Node bodyP = BRWRule.parseNode(tokenizer.nextToken());
            Node bodyO = BRWRule.parseNode(tokenizer.nextToken());
            TriplePattern body = new TriplePattern(bodyS, bodyP, bodyO);
            return new BRWRule(head, body);
        }
        catch (NoSuchElementException e2) {
            throw new ReasonerException("Illegal BRWRule: " + rulespec);
        }
    }

    public ExtendedIterator execute(TriplePattern query2, InfGraph infGraph, Finder data, HashSet firedRules) {
        TriplePattern iBody = BRWRule.instantiate(this.body, query2);
        BRWRule iRule = new BRWRule(this.head, iBody);
        if (firedRules.contains(iRule)) {
            return NullIterator.instance;
        }
        firedRules.add(iRule);
        ExtendedIterator it = ((RDFSInfGraph)infGraph).findNested(iBody, data, firedRules);
        firedRules.remove(iRule);
        return new RewriteIterator((Iterator)it, iRule);
    }

    public boolean completeFor(TriplePattern query2) {
        return false;
    }

    protected static TriplePattern instantiate(TriplePattern pattern, TriplePattern query2) {
        return new TriplePattern(BRWRule.instantiate(pattern.getSubject(), query2), BRWRule.instantiate(pattern.getPredicate(), query2), BRWRule.instantiate(pattern.getObject(), query2));
    }

    protected static Node instantiate(Node elt, TriplePattern query2) {
        if (elt.isVariable()) {
            String var = elt.getName();
            if (var.equals("s")) {
                return query2.getSubject();
            }
            if (var.equals("p")) {
                return query2.getPredicate();
            }
            if (var.equals("o")) {
                return query2.getObject();
            }
        }
        return elt;
    }

    protected static Node instantiate(Node elt, Triple value) {
        if (elt.isVariable()) {
            String var = elt.getName();
            if (var.equals("s")) {
                return value.getSubject();
            }
            if (var.equals("p")) {
                return value.getPredicate();
            }
            if (var.equals("o")) {
                return value.getObject();
            }
        }
        return elt;
    }

    public static Node parseNode(String token) {
        if (token.startsWith("?")) {
            return Node.createVariable(token.substring(1));
        }
        if (token.equals("_")) {
            return Node.createVariable("*");
        }
        if (token.indexOf(58) != -1) {
            int split = token.indexOf(58);
            String nsPrefix = token.substring(0, split);
            String localname2 = token.substring(split + 1);
            if (nsPrefix.equalsIgnoreCase("rdf")) {
                return Node.createURI(RDF.getURI() + localname2);
            }
            if (nsPrefix.equalsIgnoreCase("rdfs")) {
                return Node.createURI(RDFS.getURI() + localname2);
            }
            return Node.createURI(token);
        }
        return Node.createURI(token);
    }

    public String toString() {
        return this.head.toString() + " <- " + this.body.toString();
    }

    public TriplePattern getBody() {
        return this.body;
    }

    public TriplePattern getHead() {
        return this.head;
    }

    public boolean equals(Object o) {
        return o instanceof BRWRule && this.head.equals(((BRWRule)o).head) && this.body.equals(((BRWRule)o).body);
    }

    public int hashCode() {
        return this.head.hashCode() >> 1 ^ this.body.hashCode();
    }

    static class RewriteIterator
    extends WrappedIterator {
        TriplePattern head;

        public RewriteIterator(Iterator underlying, BRWRule rule) {
            super(underlying);
            this.head = rule.head;
        }

        public Object next() {
            Triple value = (Triple)super.next();
            return new Triple(BRWRule.instantiate(this.head.getSubject(), value), BRWRule.instantiate(this.head.getPredicate(), value), BRWRule.instantiate(this.head.getObject(), value));
        }
    }
}

