/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Dyadic;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class Delta
extends Dyadic
implements Graph {
    private Graph base;

    public Delta(Graph base) {
        super(Factory.createGraphMem(), Factory.createGraphMem());
        this.base = base;
    }

    public Graph getAdditions() {
        return this.L;
    }

    public Graph getDeletions() {
        return this.R;
    }

    public void performAdd(Triple t) {
        this.L.add(t);
        this.R.delete(t);
    }

    public void performDelete(Triple t) {
        this.L.delete(t);
        this.R.add(t);
    }

    public ExtendedIterator graphBaseFind(TripleMatch tm) {
        return this.base.find(tm).filterDrop(Delta.ifIn(GraphUtil.findAll(this.R))).andThen(this.L.find(tm));
    }

    public void close() {
        super.close();
        this.base.close();
    }

    public int graphBaseSize() {
        return this.base.size() + this.L.size() - this.R.size();
    }
}

