/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.xmlindex;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import psidev.psi.mi.xml.PsimiXmlReaderRuntimeException;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;
import psidev.psi.mi.xml.xmlindex.PsimiXmlExtractor;
import psidev.psi.mi.xml.xmlindex.PsimiXmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractorIterator
implements Iterator<Interactor> {
    private File file;
    private Iterator<InputStreamRange> iterator;
    private PsimiXmlPullParser psimiXmlPullParser;

    public InteractorIterator(List<InputStreamRange> ranges, File file, PsimiXmlPullParser psimiXmlPullParser) {
        if (ranges == null) {
            throw new IllegalArgumentException("You must give a non null List<InputStreamRange>");
        }
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null XML File");
        }
        if (psimiXmlPullParser == null) {
            throw new IllegalArgumentException("You must give a non null psimiXmlPullParser");
        }
        this.file = file;
        this.iterator = ranges.iterator();
        this.psimiXmlPullParser = psimiXmlPullParser;
    }

    private Interactor getInteractorByRange(InputStreamRange range) {
        Interactor interactor;
        try {
            InputStream snippetStream = PsimiXmlExtractor.extractXmlSnippet(this.file, range);
            interactor = this.psimiXmlPullParser.parseInteractor(snippetStream);
        }
        catch (Exception e2) {
            throw new PsimiXmlReaderRuntimeException("An error occured while parsing interactor", e2);
        }
        return interactor;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Interactor next() {
        InputStreamRange range = this.iterator.next();
        return this.getInteractorByRange(range);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Interactor iterator is read only, you cannot remove elements.");
    }
}

