/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.tab2graphml;

import com.google.common.collect.Lists;
import java.util.List;
import psidev.psi.mi.tab.converter.tab2graphml.CrossReferenceComparator;
import psidev.psi.mi.tab.model.CrossReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierByDatabaseComparator
implements CrossReferenceComparator {
    private static final List<String> DEFAULT_DATABASES = Lists.newArrayList();
    private boolean matchedAny = false;
    private List<String> databases;

    public IdentifierByDatabaseComparator(List<String> databases) {
        if (databases == null) {
            throw new IllegalArgumentException("You must give a non null list of databases");
        }
        this.databases = databases;
    }

    public IdentifierByDatabaseComparator() {
        this(DEFAULT_DATABASES);
    }

    @Override
    public int compare(CrossReference cr1, CrossReference cr2) {
        int idx1 = this.databases.indexOf(cr1.getDatabase());
        int idx2 = this.databases.indexOf(cr2.getDatabase());
        if (idx1 != -1 || idx2 != -1) {
            this.matchedAny = true;
        }
        int compare = 0;
        compare = idx1 == -1 && idx2 == -1 ? 0 : (idx1 == -1 ? 1 : (idx2 == -1 ? -1 : idx1 - idx2));
        return compare;
    }

    @Override
    public boolean hasMatchedAny() {
        return this.matchedAny;
    }

    @Override
    public boolean matches(CrossReference cr) {
        return this.databases.indexOf(cr.getDatabase()) != -1;
    }

    static {
        DEFAULT_DATABASES.add("uniprotkb");
        DEFAULT_DATABASES.add("uniprot");
        DEFAULT_DATABASES.add("chebi");
        DEFAULT_DATABASES.add("genbank_protein_gi");
        DEFAULT_DATABASES.add("entrez gene/locuslink");
        DEFAULT_DATABASES.add("ensembl");
    }
}

