/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;
import org.biopax.paxtools.pattern.constraint.LinkedPE;

public class InterToPartER
extends ConstraintAdapter {
    private Direction direction;
    private static final LinkedPE linker = new LinkedPE(LinkedPE.Type.TO_SPECIFIC);
    private static final PathAccessor pe2ER = new PathAccessor("SimplePhysicalEntity/entityReference");

    public InterToPartER(int numOfTabooElements) {
        super(numOfTabooElements + 2);
    }

    public InterToPartER(Direction direction, int numOfTabooElements) {
        this(numOfTabooElements);
        this.direction = direction;
    }

    public InterToPartER() {
        this(0);
    }

    public InterToPartER(Direction direction) {
        this();
        this.direction = direction;
    }

    @Override
    public boolean canGenerate() {
        return true;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        Interaction inter = (Interaction)match.get(ind[0]);
        HashSet<Entity> taboo = new HashSet<Entity>();
        for (int i = 1; i < this.getVariableSize() - 1; ++i) {
            taboo.add((Entity)match.get(ind[i]));
        }
        if (this.direction == null) {
            return this.generate(inter, taboo);
        }
        return this.generate((Conversion)inter, this.direction, taboo);
    }

    protected Collection<BioPAXElement> generate(Interaction inter, Set<Entity> taboo) {
        HashSet<BioPAXElement> simples = new HashSet<BioPAXElement>();
        for (Entity part : inter.getParticipant()) {
            if (!(part instanceof PhysicalEntity) || taboo.contains(part)) continue;
            simples.addAll(linker.getLinkedElements((PhysicalEntity)part));
        }
        return pe2ER.getValueFromBeans((Collection<? extends BioPAXElement>)simples);
    }

    protected Collection<BioPAXElement> generate(Conversion conv, Direction direction, Set<Entity> taboo) {
        if (direction == null) {
            throw new IllegalArgumentException("Direction cannot be null");
        }
        if (direction != Direction.BOTHSIDERS && direction != Direction.ONESIDERS) {
            HashSet<BioPAXElement> simples = new HashSet<BioPAXElement>();
            for (Entity part : direction == Direction.ANY ? conv.getParticipant() : (direction == Direction.LEFT ? conv.getLeft() : conv.getRight())) {
                if (!(part instanceof PhysicalEntity) || taboo.contains(part)) continue;
                simples.addAll(linker.getLinkedElements((PhysicalEntity)part));
            }
            return pe2ER.getValueFromBeans((Collection<? extends BioPAXElement>)simples);
        }
        HashSet<BioPAXElement> leftSimples = new HashSet<BioPAXElement>();
        HashSet<BioPAXElement> rightSimples = new HashSet<BioPAXElement>();
        for (PhysicalEntity pe : conv.getLeft()) {
            if (taboo.contains(pe)) continue;
            leftSimples.addAll(linker.getLinkedElements(pe));
        }
        for (PhysicalEntity pe : conv.getRight()) {
            if (taboo.contains(pe)) continue;
            rightSimples.addAll(linker.getLinkedElements(pe));
        }
        Set leftERs = pe2ER.getValueFromBeans((Collection<? extends BioPAXElement>)leftSimples);
        Set rightERs = pe2ER.getValueFromBeans((Collection<? extends BioPAXElement>)rightSimples);
        if (direction == Direction.ONESIDERS) {
            HashSet temp = new HashSet(leftERs);
            leftERs.removeAll(rightERs);
            rightERs.removeAll(temp);
            leftERs.addAll(rightERs);
        } else {
            leftERs.retainAll(rightERs);
        }
        return leftERs;
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        ANY,
        ONESIDERS,
        BOTHSIDERS;

    }
}

