/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.GeneralComparison10;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.SimpleMappingExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.AnalyzeString;
import net.sf.saxon.instruct.ForEach;
import net.sf.saxon.instruct.ForEachGroup;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.While;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class ExpressionTool {
    private ExpressionTool() {
    }

    public static Expression make(String string, StaticContext staticContext, int n, int n2, int n4) throws XPathException {
        ExpressionParser expressionParser = new ExpressionParser();
        if (n2 == -1) {
            n2 = 0;
        }
        Expression expression = expressionParser.parse(string, n, n2, n4, staticContext);
        expression = expression.simplify(staticContext);
        ExpressionTool.makeParentReferences(expression);
        return expression;
    }

    public static void copyLocationInfo(Expression expression, Expression expression2) {
        if (expression instanceof ComputedExpression && expression2 instanceof ComputedExpression) {
            ((ComputedExpression)expression2).setLocationId(((ComputedExpression)expression).getLocationId());
        }
    }

    public static void makeParentReferences(Expression expression) {
    }

    public static SourceLocator getLocator(Expression expression) {
        if (expression instanceof ComputedExpression) {
            return (ComputedExpression)expression;
        }
        return null;
    }

    public static boolean isRepeatedSubexpression(Expression expression, Expression expression2, StaticContext staticContext) {
        if (expression instanceof PathExpression) {
            return expression2 == ((PathExpression)expression).getStepExpression();
        }
        if (expression instanceof FilterExpression) {
            TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
            return expression2 == ((FilterExpression)expression).getFilter() && !typeHierarchy.isSubType(expression2.getItemType(typeHierarchy), Type.NUMBER_TYPE);
        }
        if (expression instanceof ForExpression) {
            return expression2 == ((ForExpression)expression).getAction();
        }
        if (expression instanceof QuantifiedExpression) {
            return expression2 == ((QuantifiedExpression)expression).getAction();
        }
        if (expression instanceof SimpleMappingExpression) {
            return expression2 == ((SimpleMappingExpression)expression).getStepExpression();
        }
        if (expression instanceof SortExpression) {
            return ((SortExpression)expression).isSortKey(expression2);
        }
        if (expression instanceof AnalyzeString) {
            return expression2 == ((AnalyzeString)expression).getMatchingExpression() || expression2 == ((AnalyzeString)expression).getNonMatchingExpression();
        }
        if (expression instanceof ForEach) {
            return expression2 == ((ForEach)expression).getActionExpression();
        }
        if (expression instanceof ForEachGroup) {
            return expression2 == ((ForEachGroup)expression).getActionExpression();
        }
        if (expression instanceof While) {
            return expression2 == ((While)expression).getActionExpression();
        }
        if (expression instanceof GeneralComparison) {
            return expression2 == ((GeneralComparison)expression).getOperands()[1];
        }
        if (expression instanceof GeneralComparison10) {
            Expression[] expressionArray = ((GeneralComparison10)expression).getOperands();
            return expression2 == expressionArray[0] || expression2 == expressionArray[1];
        }
        return false;
    }

    public static Expression unsorted(Optimizer optimizer, Expression expression, boolean bl) throws XPathException {
        if (expression instanceof Value) {
            return expression;
        }
        PromotionOffer promotionOffer = new PromotionOffer(optimizer);
        promotionOffer.action = 13;
        promotionOffer.mustEliminateDuplicates = bl;
        Expression expression2 = expression.promote(promotionOffer);
        if (expression2 != expression) {
            if (expression2 instanceof ComputedExpression) {
                ((ComputedExpression)expression2).setParentExpression(expression.getParentExpression());
            }
            return expression2;
        }
        return expression;
    }

    public static Expression unsortedIfHomogeneous(Optimizer optimizer, Expression expression, boolean bl) throws XPathException {
        if (expression instanceof Value) {
            return expression;
        }
        if (expression.getItemType(optimizer.getConfiguration().getNamePool().getTypeHierarchy()) instanceof AnyItemType) {
            return expression;
        }
        PromotionOffer promotionOffer = new PromotionOffer(optimizer);
        promotionOffer.action = 13;
        promotionOffer.mustEliminateDuplicates = bl;
        return expression.promote(promotionOffer);
    }

    public static ValueRepresentation lazyEvaluate(Expression expression, XPathContext xPathContext, int n) throws XPathException {
        if (expression instanceof Value) {
            return (Value)expression;
        }
        if (expression instanceof VariableReference) {
            return ((VariableReference)expression).evaluateVariable(xPathContext);
        }
        if ((expression.getDependencies() & 0x6D) != 0) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        if (expression instanceof LazyExpression) {
            return Closure.make((LazyExpression)expression, xPathContext, n == 1 ? 10 : n);
        }
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        return Closure.make((ComputedExpression)expression, xPathContext, n);
    }

    public static Value eagerEvaluate(Expression expression, XPathContext xPathContext) throws XPathException {
        int n;
        if (expression instanceof Value && !(expression instanceof Closure)) {
            return (Value)expression;
        }
        if (expression instanceof VariableReference) {
            ValueRepresentation valueRepresentation = ((VariableReference)expression).evaluateVariable(xPathContext);
            if (valueRepresentation instanceof Closure) {
                return SequenceExtent.makeSequenceExtent(((Closure)valueRepresentation).iterate(xPathContext));
            }
            if (valueRepresentation instanceof Value) {
                return (Value)valueRepresentation;
            }
            if (valueRepresentation instanceof NodeInfo) {
                return new SingletonNode((NodeInfo)valueRepresentation);
            }
        }
        if (((n = expression.getImplementationMethod()) & 2) != 0) {
            SequenceIterator sequenceIterator = expression.iterate(xPathContext);
            if (sequenceIterator instanceof EmptyIterator) {
                return EmptySequence.getInstance();
            }
            if (sequenceIterator instanceof SingletonIterator) {
                Item item = ((SingletonIterator)sequenceIterator).getValue();
                return Value.asValue(item);
            }
            Value value = SequenceExtent.makeSequenceExtent(sequenceIterator);
            int n2 = value.getLength();
            if (n2 == 0) {
                return EmptySequence.getInstance();
            }
            if (n2 == 1) {
                return Value.asValue(value.itemAt(0));
            }
            return value;
        }
        if ((n & 1) != 0) {
            Item item = expression.evaluateItem(xPathContext);
            return Value.asValue(item);
        }
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin((InstructionInfoProvider)((Object)expression));
        SequenceOutputter sequenceOutputter = new SequenceOutputter();
        PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
        pipelineConfiguration.setHostLanguage(expression instanceof ComputedExpression ? ((ComputedExpression)expression).getHostLanguage() : controller.getExecutable().getHostLanguage());
        sequenceOutputter.setPipelineConfiguration(pipelineConfiguration);
        xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
        sequenceOutputter.open();
        expression.process(xPathContextMinor);
        sequenceOutputter.close();
        return Value.asValue(sequenceOutputter.getSequence());
    }

    public static boolean markTailFunctionCalls(Expression expression) {
        if (expression instanceof ComputedExpression) {
            return ((ComputedExpression)expression).markTailFunctionCalls();
        }
        return false;
    }

    public static String indent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        return string;
    }

    public static int allocateSlots(Expression expression, int n, SlotManager slotManager) {
        if (expression instanceof Assignation) {
            ((Assignation)expression).setSlotNumber(n);
            int n2 = ((Assignation)expression).getRequiredSlots();
            n += n2;
            if (slotManager != null) {
                slotManager.allocateSlotNumber(((Assignation)expression).getVariableFingerprint());
                if (n2 == 2) {
                    slotManager.allocateSlotNumber(((ForExpression)expression).getPositionVariableNameCode() & 0xFFFFF);
                }
            }
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            n = ExpressionTool.allocateSlots(expression2, n, slotManager);
        }
        return n;
    }

    public static boolean effectiveBooleanValue(SequenceIterator sequenceIterator) throws XPathException {
        Item item = sequenceIterator.next();
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a boolean");
            }
            return ((BooleanValue)item).getBooleanValue();
        }
        if (item instanceof StringValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a string");
            }
            return item.getStringValueCS().length() != 0;
        }
        if (item instanceof NumericValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            return !item.equals(DoubleValue.ZERO) && item.equals(item);
        }
        if (item instanceof ObjectValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            return ((ObjectValue)item).getObject() != null;
        }
        ExpressionTool.ebvError("sequence starting with an atomic value other than a boolean, number, string, or URI");
        return false;
    }

    public static void ebvError(String string) throws XPathException {
        DynamicError dynamicError = new DynamicError("Effective boolean value is not defined for a " + string);
        dynamicError.setErrorCode("FORG0006");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public static boolean dependsOnVariable(Expression expression, Binding[] bindingArray) {
        if (expression instanceof VariableReference) {
            for (int i = 0; i < bindingArray.length; ++i) {
                if (((VariableReference)expression).getBinding() != bindingArray[i]) continue;
                return true;
            }
            return false;
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            if (!ExpressionTool.dependsOnVariable(expression2, bindingArray)) continue;
            return true;
        }
        return false;
    }

    public static void gatherReferencedVariables(Expression expression, List list) {
        if (expression instanceof VariableReference) {
            Binding binding = ((VariableReference)expression).getBinding();
            if (!list.contains(binding)) {
                list.add(binding);
            }
        } else {
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                ExpressionTool.gatherReferencedVariables(expression2, list);
            }
        }
    }

    public static boolean callsFunction(Expression expression, int n) {
        if (expression instanceof FunctionCall && (((FunctionCall)expression).getFunctionNameCode() & 0xFFFFF) == n) {
            return true;
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            if (!ExpressionTool.callsFunction(expression2, n)) continue;
            return true;
        }
        return false;
    }

    public static void gatherCalledFunctions(Expression expression, List list) {
        if (expression instanceof UserFunctionCall) {
            UserFunction userFunction = ((UserFunctionCall)expression).getFunction();
            if (!list.contains(userFunction)) {
                list.add(userFunction);
            }
        } else {
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                ExpressionTool.gatherCalledFunctions(expression2, list);
            }
        }
    }

    public static Expression resolveCallsToCurrentFunction(Expression expression, Configuration configuration) throws XPathException {
        int n = configuration.getNamePool().getFingerprint("http://www.w3.org/2005/xpath-functions", "current");
        if (n == -1) {
            return expression;
        }
        if (ExpressionTool.callsFunction(expression, n)) {
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setNameCode(configuration.getNamePool().allocate("saxon", "http://saxon.sf.net/", "current" + expression.hashCode()));
            rangeVariableDeclaration.setVariableName("saxon:current");
            rangeVariableDeclaration.setRequiredType(SequenceType.SINGLE_ITEM);
            LetExpression letExpression = new LetExpression();
            letExpression.setSequence(new ContextItemExpression());
            letExpression.setVariableDeclaration(rangeVariableDeclaration);
            PromotionOffer promotionOffer = new PromotionOffer(configuration.getOptimizer());
            promotionOffer.action = 14;
            promotionOffer.containingExpression = letExpression;
            expression = expression.promote(promotionOffer);
            letExpression.setAction(expression);
            return letExpression;
        }
        return expression;
    }

    public static boolean isVariableReplaceableByDot(Expression expression, Binding[] bindingArray) {
        if (expression instanceof ComputedExpression) {
            if (expression instanceof FilterExpression) {
                Expression expression2 = ((FilterExpression)expression).getBaseExpression();
                Expression expression3 = ((FilterExpression)expression).getFilter();
                return ExpressionTool.isVariableReplaceableByDot(expression2, bindingArray) && !ExpressionTool.dependsOnVariable(expression3, bindingArray);
            }
            if (expression instanceof PathExpression) {
                Expression expression4 = ((PathExpression)expression).getFirstStep();
                Expression expression5 = ((PathExpression)expression).getRemainingSteps();
                return ExpressionTool.isVariableReplaceableByDot(expression4, bindingArray) && !ExpressionTool.dependsOnVariable(expression5, bindingArray);
            }
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                Expression expression6 = (Expression)iterator.next();
                if (ExpressionTool.isVariableReplaceableByDot(expression6, bindingArray)) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

