/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.OpVisitorByType;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op0;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class Transformer {
    static boolean noDupIfSame = true;

    public static Op transform(Transform transform, Op op) {
        return Transformer.transform(transform, op, null, null);
    }

    public static Op transform(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (op == null) {
            ALog.warn(Transformer.class, "Attempt to transform a null Op - ignored");
            return op;
        }
        TransformApply v = new TransformApply(transform);
        OpWalker.walk(op, v, beforeVisitor, afterVisitor);
        Op r = v.result();
        return r;
    }

    private Transformer() {
    }

    private static final class TransformApply
    extends OpVisitorByType {
        private Transform transform = null;
        private Stack stack = new Stack();

        private Op pop() {
            return (Op)this.stack.pop();
        }

        private void push(Op op) {
            this.stack.push(op);
        }

        public TransformApply(Transform transform) {
            this.transform = transform;
        }

        public Op result() {
            if (this.stack.size() != 1) {
                ALog.warn(this, "Stack is not aligned");
            }
            return this.pop();
        }

        protected void visit0(Op0 op) {
            this.push(op.apply(this.transform));
        }

        protected void visit1(Op1 op) {
            Op subOp = null;
            if (op.getSubOp() != null) {
                subOp = this.pop();
            }
            this.push(op.apply(this.transform, subOp));
        }

        protected void visit2(Op2 op) {
            Op left = null;
            Op right = null;
            if (op.getRight() != null) {
                right = this.pop();
            }
            if (op.getLeft() != null) {
                left = this.pop();
            }
            Op opX = op.apply(this.transform, left, right);
            this.push(opX);
        }

        protected void visitN(OpN op) {
            ArrayList<Op> x = new ArrayList<Op>(op.size());
            Iterator iter = op.iterator();
            while (iter.hasNext()) {
                Op sub = (Op)iter.next();
                Op r = this.pop();
                if (r == null) continue;
                x.add(0, r);
            }
            Op opX = op.apply(this.transform, x);
            this.push(opX);
        }

        protected void visitExt(OpExt op) {
            this.push(this.transform.transform(op));
        }
    }
}

