/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.mem.BunchMap;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.shared.BrokenException;

public class HashedBunchMap
extends HashCommon
implements BunchMap {
    protected TripleBunch[] values;

    public HashedBunchMap() {
        super(10);
        this.values = new TripleBunch[this.capacity];
    }

    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.capacity; ++i) {
            this.values[i] = null;
            this.keys[i] = null;
        }
    }

    public long size() {
        return this.size;
    }

    public TripleBunch get(Object key) {
        int slot = this.findSlot(key);
        return slot < 0 ? this.values[~slot] : null;
    }

    public void put(Object key, TripleBunch value) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.values[slot ^ 0xFFFFFFFF] = value;
        } else {
            this.keys[slot] = key;
            this.values[slot] = value;
            ++this.size;
            if (this.size == this.threshold) {
                this.grow();
            }
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        TripleBunch[] oldValues = this.values;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = new Object[this.capacity];
        this.values = new TripleBunch[this.capacity];
        for (int i = 0; i < oldCapacity; ++i) {
            Object key = oldContents[i];
            if (key == null) continue;
            int j = this.findSlot(key);
            if (j < 0) {
                throw new BrokenException("oh dear, already have a slot for " + key + ", viz " + ~j);
            }
            this.keys[j] = key;
            this.values[j] = oldValues[i];
        }
    }

    protected void removeAssociatedValues(int here) {
        this.values[here] = null;
    }

    protected void moveAssociatedValues(int here, int scan) {
        this.values[here] = this.values[scan];
    }
}

