## ----dependencies, warning=FALSE, message=FALSE----------------------------
library(mpra)

## --------------------------------------------------------------------------
E <- 4 # Number of elements
B <- 3 # Number of barcodes
s <- 4 # Samples per tissue
nt <- 2 # Number of tissues

set.seed(434)
rna <- matrix(rpois(E*B*s*nt, lambda = 30), nrow = E*B, ncol = s*nt)
dna <- matrix(rpois(E*B*s*nt, lambda = 30), nrow = E*B, ncol = s*nt)

rn <- as.character(outer(paste0("barcode_", seq_len(B), "_"), paste0("elem_", seq_len(E)), FUN = "paste0"))
cn <- c(paste0("liver_", seq_len(s)), paste0("kidney_", seq_len(s)))

rownames(rna) <- rn
rownames(dna) <- rn
colnames(rna) <- cn
colnames(dna) <- cn

rna
dna

## --------------------------------------------------------------------------
eid <- rep(paste0("elem_", seq_len(E)), each = B)
eid

## --------------------------------------------------------------------------
eseq <- replicate(E, paste(sample(c("A", "T", "C", "G"), 10, replace = TRUE), collapse = ""))
eseq <- rep(eseq, each = B)
eseq

## --------------------------------------------------------------------------
mpraset_example <- MPRASet(DNA = dna, RNA = rna, eid = eid, eseq = eseq, barcode = NULL)
mpraset_example

## --------------------------------------------------------------------------
E <- 4 # Number of elements
B <- 3 # Number of barcodes
s <- 4 # Total number of samples
nalleles <- 2 # Number of alleles

set.seed(434)
rna <- matrix(rpois(E*B*s*nalleles, lambda = 30), nrow = E*B, ncol = s*nalleles)
dna <- matrix(rpois(E*B*s*nalleles, lambda = 30), nrow = E*B, ncol = s*nalleles)

rn <- as.character(outer(paste0("barcode_", seq_len(B), "_"), paste0("elem_", seq_len(E)), FUN = "paste0"))
cn <- c(paste0("allele1_sample", seq_len(s)), paste0("allele2_sample", seq_len(s)))

rownames(rna) <- rn
rownames(dna) <- rn
colnames(rna) <- cn
colnames(dna) <- cn

rna
dna

## --------------------------------------------------------------------------
mpraset_example2 <- MPRASet(DNA = dna, RNA = rna, eid = eid, eseq = eseq, barcode = NULL)
mpraset_example2

## --------------------------------------------------------------------------
data(mpraSetExample)

## ---- fig=TRUE-------------------------------------------------------------
design <- data.frame(intcpt = 1, episomal = grepl("MT", colnames(mpraSetExample)))
mpralm_fit <- mpralm(object = mpraSetExample, design = design, aggregate = "mean", normalize = TRUE, model_type = "indep_groups", plot = TRUE)

## --------------------------------------------------------------------------
toptab <- topTable(mpralm_fit, coef = 2, number = Inf)
toptab6 <- head(toptab)

## ----printToptab10---------------------------------------------------------
rownames(toptab6)
rownames(toptab6) <- NULL
toptab6

## ----sessionInfo, results='asis', echo=FALSE-------------------------------
sessionInfo()

