## ----ideal histogram, echo = FALSE---------------------------------------
plot(x = 1, type = 'n', xlim = c(0, 256), ylim = c(0, 500),
     ylab = "Nuclei", xlab = "Fluorescence", main = "Ideal Histogram")
abline(h = 0)
lines(x = c(80, 80), y = c(0, 325))
lines(x = c(160, 160), y = c(0, 150))
tmpfun <- function(x) 100 * exp(-x/80)
curve(tmpfun, 80, 160, add = TRUE)
text(x = 80, y = 325, "G1 Peak", pos = 3)
text(x = 160, y = 150, "G2 Peak", pos = 3)
text(x = 120, y = 30, "S Phase", pos = 3)

## ----real histogram, echo = FALSE----------------------------------------
set.seed(1234)
plot(x = 1, type = 'n', xlim = c(0, 256), ylim = c(0, 500),
     ylab = "Nuclei", xlab = "Fluorescence", main = "Empirical Histogram")
abline(h = 0)

vals <- rep(0, 256)
vals <- jitter(3500 * dnorm(0:256, mean = 80, sd = 80 * 0.05), amount = 20)
vals <- vals + jitter(200 * exp ((0:-256)/60), amount = 5)
vals <- vals +
  jitter(2500 * dnorm(0:256, mean = 160, sd = 160 * 0.05), amount = 20)
vals[80:160] <- vals[80:160] + jitter(100 * exp((-80:-160)/80),
                                      amount = 5)
vals[vals < 0] <- 0
points(vals, type = 'l')

text(x = 80, y = 450, "G1 Peak", pos = 3)
text(x = 160, y = 200, "G2 Peak", pos = 3)
text(x = 120, y = 100, "S Phase", pos = 3)
text(x = 40, y = 170, "Debris", pos = 3)
text(x = 240, y = 40, "Aggregates", pos = 3)

## ----manual analysis, echo = FALSE---------------------------------------
set.seed(1234)
plot(x = 1, type = 'n', xlim = c(0, 256), ylim = c(0, 500),
     ylab = "Nuclei", xlab = "Fluorescence",
     main = "Manual Histogram Analysis")
abline(h = 0)

vals <- rep(0, 256)
vals <- jitter(3500 * dnorm(0:256, mean = 80, sd = 80 * 0.05), amount = 20)
vals <- vals + jitter(200 * exp ((0:-256)/60), amount = 5)
vals <- vals +
  jitter(2500 * dnorm(0:256, mean = 160, sd = 160 * 0.05), amount = 20)
vals[80:160] <- vals[80:160] + jitter(100 * exp((-80:-160)/80),
                                      amount = 5)
vals[vals < 0] <- 0
points(vals, type = 'l')
rect(70, 0, 95, 475, border = 2, lwd = 2)

## ----individual components, echo = FALSE---------------------------------
set.seed(1234)
plot(x = 1, type = 'n', xlim = c(0, 256), ylim = c(0, 500),
     ylab = "Nuclei", xlab = "Fluorescence",
     main = "Histogram Components")
abline(h = 0)

vals <- rep(0, 257)
sphase <- vals
G1 <- jitter(3500 * dnorm(0:256, mean = 80, sd = 80 * 0.05), amount = 20)
G1[G1<0] <- 0
vals <- G1
debris <- jitter(200 * exp ((0:-256)/60), amount = 5)
debris[debris<0] <- 0
vals <- vals + debris
G2 <- jitter(2500 * dnorm(0:256, mean = 160, sd = 160 * 0.05), amount = 20)
G2[G2<0] <- 0
vals <- vals + G2
sphase[80:160] <- jitter(100 * exp((-80:-160)/80), amount = 5)
sphase[sphase<0] <- 0
vals <- vals + sphase
vals[vals < 0] <- 0
points(vals, type = 'l')
G1[c(1:70, 90:256)] <- 0
points(debris, type = 'l', col = 3, lwd = 2)
points(G1, type = 'l', col = 4, lwd = 2)
sphase[c(1:70, 170:256)] <- 0
points(sphase, type = 'l', col = 2, lwd = 2)
text(x = 25, y = 50, col = 3, "Debris")
text(x = 95, y = 350, col = 4, "G1")
text(x = 120, y = 120, col = 2, "S-Phase")

## ----histogram modeling, echo = FALSE------------------------------------
set.seed(1234)
plot(x = 1, type = 'n', xlim = c(0, 256), ylim = c(0, 500),
     ylab = "Nuclei", xlab = "Fluorescence",
     main = "Histogram Modeling")
abline(h = 0)

vals <- rep(0, 257)
sphase <- vals
G1 <- jitter(3500 * dnorm(0:256, mean = 80, sd = 80 * 0.05), amount = 20)
G1[G1<0] <- 0
vals <- G1
debris <- jitter(200 * exp ((0:-256)/60), amount = 5)
debris[debris<0] <- 0
vals <- vals + debris
G2 <- jitter(2500 * dnorm(0:256, mean = 160, sd = 160 * 0.05), amount = 20)
G2[G2<0] <- 0
vals <- vals + G2
sphase[80:160] <- jitter(100 * exp((-80:-160)/80), amount = 5)
sphase[sphase<0] <- 0
vals <- vals + sphase
sphase[80:160] <- 100 * exp((-80:-160)/80)
vals[vals < 0] <- 0
points(vals, type = 'l')
points(200 * exp ((0:-256)/60), type = 'l', col = 3, lwd = 2)
points(sphase, type = 'l', col = 2, lwd = 2)
points(2500 * dnorm(0:256, mean = 160, sd = 160 * 0.05), type = 'l',
       lwd = 2, col = 5)
points(3500 * dnorm(0:256, mean = 80, sd = 80 * 0.05), type = 'l',
       col = 4, lwd = 2)
text(x = 25, y = 50, col = 3, "Debris")
text(x = 95, y = 350, col = 4, "G1")
text(x = 120, y = 120, col = 2, "S-Phase")
text(x = 180, y = 100, col = 5, "G2")

## ----histogram standard, echo = FALSE------------------------------------
set.seed(1234)
plot(x = 1, type = 'n', xlim = c(0, 256), ylim = c(0, 500),
     ylab = "Nuclei", xlab = "Fluorescence",
     main = "Histogram with Standard")
abline(h = 0)

vals <- rep(0, 257)
sphase <- vals
G1 <- jitter(3500 * dnorm(0:256, mean = 80, sd = 80 * 0.05), amount = 20)
G1[G1<0] <- 0
vals <- G1
debris <- jitter(200 * exp ((0:-256)/60), amount = 5)
debris[debris<0] <- 0
vals <- vals + debris
G2 <- jitter(2500 * dnorm(0:256, mean = 160, sd = 160 * 0.05), amount = 20)
G2[G2<0] <- 0
vals <- vals + G2
sphase[80:160] <- jitter(100 * exp((-80:-160)/80), amount = 5)
sphase[sphase<0] <- 0
standard <- jitter(1500 * dnorm(0:256, mean = 130, sd = 130 * 0.01),
                   amount = 10)
standard[standard<0] <- 0
vals <- vals + sphase
vals <- vals + standard
sphase[80:160] <- 100 * exp((-80:-160)/80)
vals[vals < 0] <- 0
points(vals, type = 'l')
text(x = 160, y = 450, "Standard")
text(x = 95, y = 400, "G1")

