tabItem(tabName = "elmeranalysis",
        fluidRow(
            column(8,  bsAlert("elmermessage"),
                   bsCollapse(id = "collapelmer", open = "Enhancer Linking by Methylation/Expression Relationship (ELMER) ",
                              bsCollapsePanel("Enhancer Linking by Methylation/Expression Relationship (ELMER) ",  includeHTML("elmer.html"), style = "default"))
            ),
            column(4,
                   box(title = "Analysis", width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = TRUE,collapsed = FALSE,
                       box(title = "Data", width = NULL,
                           solidHeader = TRUE, collapsible = FALSE,collapsed = TRUE,
                           shinyFilesButton('elmermaefile', 'Select MAE object', 'Please select MAE object',
                                            multiple = FALSE),
                           bsTooltip("elmermaefile", "A .rda file with a mae object created in the `Create mae object` menu above .",
                                     "left")
                       ),
                           box(title = "Groups selection", width = NULL,
                               solidHeader = TRUE, collapsible = FALSE,collapsed = TRUE,
                           selectizeInput('elmermaetype',
                                          'Column with groups',
                                          NULL,
                                          multiple = FALSE),
                           selectizeInput('elmermaesubtype',
                                          'Group 1',
                                          NULL,
                                          multiple = FALSE),
                           selectizeInput('elmermaesubtype2',
                                          'Group 2',
                                          NULL,
                                          multiple = FALSE)
                       ),
                       box(title = "Analysis parameters", width = NULL,
                           solidHeader = TRUE, collapsible = FALSE, collapsed = TRUE,
                           box(title = "Analysis mode", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                               selectizeInput('elmermode',
                                              'Mode',
                                              c("Unsupervised"="Unsupervised",
                                                "Supervised"="Supervised"),
                                              selected = "Unsupervised",
                                              multiple = FALSE)
                           ),
                           box(title = "Step 1 - Differently methylated probes", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                               selectizeInput('elmerdirection',
                                              'Direction',
                                              c("Probes hypermethylated in group 1 compared to group 2"="hyper",
                                                "Probes hypomethylated in group 1 compared to group 1"="hypo"),
                                              multiple = TRUE),
                               bsTooltip("elmerdirection", "ELMER will only select probes that are either hypermethylated probes or hypomethylated. If you select both, all steps will be executed twice",
                                         "left"),
                               numericInput("elmermetdiff", " DNA methylation difference cutoff",
                                            min = 0, max = 1, value = 0.3, step = 0.05),
                               bsTooltip("elmermetdiff", "Minimum mean level to consider probes as differently methylated",
                                         "left"),
                               numericInput("elmermetpercentage", "Minimun subgroup fraction",
                                            min = 0, max = 1, value = 0.2, step = 0.01),
                               bsTooltip("elmermetpercentage", "Minimun subgroup fraction (percentage) of samples to be used from each group for the comparison. Default: 20% of each group.",
                                         "left"),
                               numericInput("elmermetpvalue", "pvalue",
                                            min = 0, max = 1, value = 0.01, step = 0.01),
                               bsTooltip("elmermetpvalue", "Maximum pvalue to consider  differently methylated probe significant",
                                         "left")
                           ),

                           box(title = "Step 2 - Predict enhancer-gene linkages", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                               numericInput("elmergetpairNumGenes", " Nearby genes",
                                            min = 1, max = 100, value = 20, step = 1),
                               bsTooltip("elmergetpairNumGenes", "For each differently methylated probe how many nearby genes will be verified ? (default:20, 10 downstream and 10 upstream)",
                                         "left"),
                               numericInput("elmergetpairpercentage", "Minimun subgroup fraction",
                                            min = 0, max = 1, value = 0.4, step = 0.01),
                               bsTooltip("elmergetpairpercentage", "Minimun subgroup fraction of all samples used to compare methylated vs unmethylated group. To use 50% of samples in each group set it to 1.0, to use 20% set to 0.4 (default)",
                                         "left"),
                               numericInput("elmergetpairpermu", "Number of permutations",
                                            min = 0, max = 10000, value = 10000, step = 1000),
                               bsTooltip("elmergetpairpermu", "For each probe-gene pair tested, the raw p-value Pr was corrected for multiple hypothesis using a permutation approach. The greater the permutation time is, the longer it will take.",
                                         "left"),
                               numericInput("elmergetpairpvalue", "Raw P-value cut-off",
                                            min = 0, max = 1, value = 0.01, step = 0.01),
                               bsTooltip("elmergetpairpvalue", "Maximum raw P value  to consider pair significant",
                                         "left"),
                               numericInput("elmergetpairpevalue", "Empirical P value cut-off",
                                            min = 0, max = 1, value = 0.0001, step = 0.01),
                               bsTooltip("elmergetpairpevalue", "Maximum empirical P value (adjusted by the permutation approach) to consider pair significant",
                                         "left"),
                               numericInput("elmergetpairportion", "Portion",
                                            min = 0, max = 1, value = 0.3, step = 0.1),
                               bsTooltip("elmergetpairportion", "We usually call locus unmethylated when the methylation value < 0.3 and methylated when the methylation value > 0.3. Make sure we have at least 5% percentage of beta values lesser than 0.3",
                                         "left"),
                               checkboxInput("elmergetpairdiffExp", "Test whether putative target gene are differentially expressed ?", value = FALSE, width = NULL),
                               bsTooltip("elmergetpairdiffExp", "t test will be applied to  test whether putative target gene are differentially expressed between two groups",
                                         "left")
                           ),
                           box(title = "Step 3 - Get enriched motif", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                               numericInput("elmergetenrichedmotifMinIncidence", "Minimum incidence",
                                            min = 0, max = 100, value = 10, step = 1),
                               bsTooltip("elmergetenrichedmotifMinIncidence", "Minimum number of probes (from pair gene-probe found before) a motif has to have to be considered enriched.",
                                         "left"),
                               numericInput("elmergetenrichedmotifLoweOR", "Lower boundary cut-off",
                                            min = 0, max = 5, value = 1.1, step = 0.1),
                               numericInput("elmergetenrichedmotifFDR", "FDR cut-off",
                                            min = 0, max = 1, value = 0.05, step = 0.01)
                           ),
                           box(title = "Step 4 - Identify regulatory TFs", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                               numericInput("elmergetTFpercentage", "Minimun subgroup fraction",
                                            min = 0, max = 1, value = 0.4, step = 0.01),
                               bsTooltip("elmergetTFpercentage", "Minimun subgroup fraction of all samples used to compare methylated vs unmethylated group. To use 50% of samples in each group set it to 1.0, to use 20% set to 0.4 (default)",
                                         "left")
                           )
                       ),
                       box(title = "Other options", width = NULL,
                           solidHeader = TRUE, collapsible = FALSE, collapsed = TRUE,
                           sliderInput("elmercores", "Cores", step=1,
                                       min = 1, max = parallel::detectCores(), value = 1),
                           textInput("elmerresultssavefolder", "Name of the results folder:", value = "results_elmer", width = NULL, placeholder = NULL)
                       ),
                       actionButton("elmerAnalysisBt",
                                    "Run analysis",
                                    style = "background-color: #000080;
                                    color: #FFFFFF;
                                    margin-left: auto;
                                    margin-right: auto;
                                    width: 100%",
                                    icon = icon("flask"))
                   )
            )
        )
)
