/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.Sequence;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CountObject
implements Comparable<CountObject> {
    private Sequence key;
    private int count;

    public CountObject(Sequence sequence, Integer n) {
        this.key = sequence;
        this.count = n;
    }

    @Override
    public int compareTo(CountObject countObject) {
        if (this.count == countObject.count) {
            return this.key.compareTo(countObject.key);
        }
        return countObject.count - this.count;
    }

    public int compareToByKey(CountObject countObject) {
        int n = this.key.compareTo(countObject.key);
        return n;
    }

    public Sequence getKey() {
        return this.key;
    }

    public void setKey(Sequence sequence) {
        this.key = sequence;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer n) {
        this.count = n;
    }

    public String toString() {
        return "CountObject [key=" + this.key + ", count=" + this.count + "]";
    }

    public String toString2() {
        return this.key + " " + this.count;
    }

    public static void steamOutSequence(DataOutput dataOutput, CountObject countObject) throws IOException {
        Sequence sequence = countObject.getKey();
        dataOutput.writeLong(sequence.getValue());
        dataOutput.writeInt(sequence.getLength());
        dataOutput.writeInt(countObject.getCount());
    }

    public static void steamOutSequenceTxt(DataOutput dataOutput, CountObject countObject) throws IOException {
        Sequence sequence = countObject.getKey();
        dataOutput.write((sequence.getString() + "  " + countObject.getCount() + "\n").getBytes());
    }

    public static void steamOutSequenceClose(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(Long.MAX_VALUE);
    }

    public static CountObject steamInSequence(DataInput dataInput) throws IOException {
        Long l = dataInput.readLong();
        if (l == Long.MAX_VALUE) {
            return null;
        }
        Integer n = dataInput.readInt();
        Integer n2 = dataInput.readInt();
        CountObject countObject = new CountObject(new Sequence(l, n), n2);
        return countObject;
    }
}

