/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.ArraysMergerHeap;
import base.CountObject;
import base.DebugLog;
import base.SequenceComparator;
import base.Util;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ArraysMerger {
    private int SIZE = 1000000;
    private CountObject[] countObjects;
    private int index = 0;
    private int listIndex = -1;
    private File tempFolder;
    private String filePrefix;
    private int MAX_THREAD_NUM = 2;
    private ExecutorService service = null;
    private Semaphore semaphore = null;
    private static Comparator<CountObject> comparator = new SequenceComparator();

    public ArraysMerger(String string, String string2, int n) {
        int n2 = Util.getNumberOfCores();
        this.MAX_THREAD_NUM = Util.getMaxThreadNumber();
        this.service = Executors.newFixedThreadPool(this.MAX_THREAD_NUM);
        this.semaphore = new Semaphore(this.MAX_THREAD_NUM + 1);
        DebugLog.log("Available cores: " + n2);
        DebugLog.log("MAX_THREAD_NUM:  " + this.MAX_THREAD_NUM);
        try {
            this.tempFolder = new File(string);
            if (n > 0) {
                this.SIZE = n;
            }
            this.countObjects = new CountObject[this.SIZE];
            if (this.tempFolder.exists()) {
                this.tempFolder.delete();
            }
            this.tempFolder.mkdir();
            this.filePrefix = string2;
            DebugLog.log("Temp Folder:" + this.tempFolder);
            DebugLog.log("Temp File Size:" + this.SIZE);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
        }
        this.addSpace();
    }

    private void asyncExport() {
        final CountObject[] countObjectArray = this.countObjects;
        final int n = this.listIndex;
        final int n2 = this.index;
        try {
            DebugLog.log("Waiting to submit an export job ... ");
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            DebugLog.log(interruptedException);
        }
        this.service.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DebugLog.log("Started for exporting ...  Size:" + n2 + " Index:" + n);
                try {
                    ArraysMerger.this.export(countObjectArray, n, n2);
                }
                finally {
                    ArraysMerger.this.semaphore.release();
                }
                DebugLog.log("Finished exporting ... ");
            }
        });
    }

    private void export(CountObject[] countObjectArray, int n, int n2) {
        DebugLog.log("Sorting:");
        this.sort(countObjectArray, n2);
        DebugLog.log(" Outputing:");
        String string = ArraysMerger.getFileName(this.tempFolder.getAbsolutePath(), this.filePrefix, n);
        try {
            Long l = System.currentTimeMillis();
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string), 10000000));
            CountObject[] countObjectArray2 = countObjectArray;
            int n3 = 0;
            CountObject countObject = null;
            for (int i = 0; i < n2; ++i) {
                CountObject countObject2 = countObjectArray2[i];
                if (countObject != null) {
                    if (countObject.compareToByKey(countObject2) == 0) {
                        countObject.setCount(countObject.getCount() + countObject2.getCount());
                        continue;
                    }
                    CountObject.steamOutSequence(dataOutputStream, countObject);
                    countObject = countObject2;
                    ++n3;
                    continue;
                }
                countObject = countObject2;
            }
            if (countObject != null) {
                CountObject.steamOutSequence(dataOutputStream, countObject);
                ++n3;
            }
            CountObject.steamOutSequenceClose(dataOutputStream);
            DebugLog.log(" Done output file:" + string + " Rows:" + n3);
            dataOutputStream.flush();
            dataOutputStream.close();
            DebugLog.log("File[" + string + "] closed. Done in [" + (System.currentTimeMillis() - l) / 1000L + "] seconds");
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
    }

    private void addSpace() {
        if (this.listIndex != -1) {
            this.asyncExport();
        }
        this.countObjects = null;
        this.countObjects = new CountObject[this.SIZE];
        ++this.listIndex;
        this.index = 0;
    }

    public void add(CountObject countObject) {
        this.countObjects[this.index++] = countObject;
        if (this.index == this.SIZE) {
            this.addSpace();
        }
    }

    public void finish() {
        this.asyncExport();
        try {
            this.service.shutdown();
            this.service.awaitTermination(1000000L, TimeUnit.SECONDS);
            DebugLog.log("All output done");
        }
        catch (InterruptedException interruptedException) {
            DebugLog.log(interruptedException);
        }
    }

    private void sort(CountObject[] countObjectArray, int n) {
        long l = System.currentTimeMillis();
        Arrays.sort(countObjectArray, 0, n, comparator);
        long l2 = System.currentTimeMillis();
        DebugLog.log("Sorting done in [" + (double)(l2 - l) / 1000.0 + "] seconds.");
    }

    public Properties output(boolean bl, String string) {
        ArraysMergerHeap arraysMergerHeap = new ArraysMergerHeap(this.tempFolder.getAbsolutePath(), this.filePrefix, this.listIndex + 1);
        try {
            Properties properties = arraysMergerHeap.output(bl, string);
            this.cleanTempFiles();
            return properties;
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            return null;
        }
    }

    private void cleanTempFiles() {
        for (int i = 0; i <= this.listIndex; ++i) {
            String string = ArraysMerger.getFileName(this.tempFolder.getAbsolutePath(), this.filePrefix, i);
            DebugLog.log("Removing temp file:" + string);
            new File(string).delete();
        }
    }

    public static String getFileName(String string, String string2, int n) {
        return string + "/" + string2 + "-" + n + ".dat";
    }
}

