/*
 * Decompiled with CFR 0.152.
 */
package reder.application.graph;

import reder.application.MainFrame;
import reder.application.graph.NodeBank;

public class LegendBank
extends NodeBank {
    private float xposition;
    private float xsignal;
    private float xmove;
    private float xintersp;
    private float yposition;
    private float ysignal;
    private float ymove;
    private float yintersp;
    private float interspace;
    private String legtype;
    private String position;
    private String labx;
    private String legShape;
    private float labxdist;
    private int nmembers;
    private int membership;
    protected int legid;
    private boolean isVertical;
    private float totalszW;
    private float totalszH;
    private float distBorderX;
    private float distBorderY;
    private float largerH;
    private float largerW;
    private float fontDistX;
    private float fontDistY;
    private float correcDx;
    private float correcDy;
    private float titleSize;
    private float smallerH;
    private float smallerW;
    LegendBank legAccount;

    public LegendBank(String strNodeID, int intNodeID) {
        super(strNodeID, intNodeID);
        this.legid = intNodeID;
        this.legtype = "nodesize";
        this.totalszW = 20.0f;
        this.totalszH = 20.0f;
        this.largerH = 20.0f;
        this.largerW = 20.0f;
        this.smallerH = 20.0f;
        this.smallerW = 20.0f;
        this.nmembers = 1;
        this.membership = 0;
        this.isVertical = false;
        this.legShape = "SOLID";
        this.labxdist = 30.0f;
        this.labx = "labx";
        this.correcDx = 0.0f;
        this.correcDy = 0.0f;
        this.titleSize = 0.0f;
        this.xintersp = 0.0f;
        this.yintersp = 0.0f;
        this.interspace = 5.0f;
        this.distBorderX = 10.0f;
        this.distBorderY = 10.0f;
        this.fontDistX = 12.0f;
        this.fontDistY = 5.0f;
        this.bottomLeft();
    }

    public void resetId(int id) {
        this.legid = id;
    }

    public void setLegShape(String lt) {
        this.legShape = lt;
    }

    public String getLegShape() {
        return this.legShape;
    }

    public void setFontDist(float x, float y) {
        this.fontDistX = x;
        this.fontDistY = y;
    }

    public void setDistBorder(float x, float y) {
        this.distBorderX = x;
        this.distBorderY = y;
    }

    public void updateDistBorder(float titlesz) {
        this.titleSize = titlesz;
        if (this.isVertical) {
            if (titlesz > this.totalszH) {
                this.correcDy = (titlesz - this.totalszH) / 2.0f;
            }
        } else if (titlesz > this.totalszW) {
            this.correcDx = (titlesz - this.totalszW) / 2.0f;
        }
    }

    public void setLabx(String tl) {
        this.labx = tl;
    }

    public String getLabx() {
        return this.labx;
    }

    public void setLabxDist(float xd) {
        this.labxdist = xd;
    }

    public float getLabxDist() {
        return this.labxdist;
    }

    public void setInterSpace(float sp) {
        this.interspace = sp;
    }

    public float getInterSpace() {
        return this.interspace;
    }

    public float getFontDistX() {
        return this.fontDistX;
    }

    public float getFontDistY() {
        return this.fontDistY;
    }

    public float getDistBorderX() {
        return this.distBorderX;
    }

    public float getDistBorderY() {
        return this.distBorderY;
    }

    public float getXPosition() {
        return this.xposition;
    }

    public float getYPosition() {
        return this.yposition;
    }

    public void setPanelPosition(String str) {
        this.position = str;
    }

    public String getPanelPosition() {
        return this.position;
    }

    public void realocatePanelPosition(String str) {
        if (str.equals("topLeft")) {
            this.position = "topLeft";
            this.topLeft();
        } else if (str.equals("topRight")) {
            this.position = "topRight";
            this.topRight();
        } else if (str.equals("bottomLeft")) {
            this.position = "bottomLeft";
            this.bottomLeft();
        } else if (str.equals("bottomRight")) {
            this.position = "bottomRight";
            this.bottomRight();
        }
        if (!this.legtype.equals("nodecolor") && !this.legtype.equals("edgecolor")) {
            if (this.isVertical) {
                this.yintersp = this.interspace;
                this.xintersp = 0.0f;
            } else {
                this.yintersp = 0.0f;
                this.xintersp = this.interspace;
            }
        }
        this.setTextPos();
    }

    public String getPanelSideRL() {
        String side = this.position.equals("topLeft") || this.position.equals("bottomLeft") ? "left" : "right";
        return side;
    }

    public String getPanelSideTB() {
        String side = this.position.equals("topLeft") || this.position.equals("topRight") ? "top" : "bottom";
        return side;
    }

    public float getLegZoom() {
        float zoom = 1.0f;
        if (this.legtype.equals("nodesize") || this.legtype.equals("edgewidth")) {
            zoom = (float)MainFrame.getZoom();
        }
        return zoom;
    }

    public void realocateMembers() {
        this.realocatePanelPosition(this.position);
        float zoom = this.getLegZoom();
        this.legAccount = MainFrame.LegendList.get(this.legid);
        float watual = this.legAccount.getW() * zoom;
        float hatual = this.legAccount.getH() * zoom;
        float wanterior = 0.0f;
        float hanterior = 0.0f;
        float xanterior = 0.0f;
        float yanterior = 0.0f;
        float relativex = 0.0f;
        float relativey = 0.0f;
        if (this.membership == 0) {
            relativex = this.xsignal * watual / 2.0f;
            this.smallerW = this.legAccount.getW();
        } else {
            wanterior = MainFrame.LegendList.get(this.legid - 1).getW() * zoom;
            xanterior = this.xmove * MainFrame.LegendList.get(this.legid - 1).getX() - this.xmove * this.xposition;
            relativex = this.xsignal * this.xmove * wanterior / 2.0f + this.xsignal * watual / 2.0f;
        }
        if (this.membership == 0) {
            relativey = this.ysignal * hatual / 2.0f;
            this.smallerH = this.legAccount.getH();
        } else {
            hanterior = MainFrame.LegendList.get(this.legid - 1).getH() * zoom;
            yanterior = this.ymove * MainFrame.LegendList.get(this.legid - 1).getY() - this.ymove * this.yposition;
            relativey = this.ysignal * this.ymove * hanterior / 2.0f + this.ysignal * hatual / 2.0f;
        }
        this.legAccount.setX(this.xposition + (relativex += this.xintersp * this.xsignal * zoom) + xanterior);
        this.legAccount.setY(this.yposition + (relativey += this.yintersp * this.ysignal * zoom) + yanterior);
    }

    public float getTitleX() {
        float zn = this.getLegZoom();
        float xt = this.xposition + this.xintersp * this.xsignal * zn;
        if (this.isVertical) {
            xt = this.getPanelSideRL().equals("left") ? xt + this.smallerW / 2.0f * zn + this.largerW / 2.0f * zn + this.labxdist : xt + this.smallerW / 2.0f * zn - this.largerW / 2.0f * zn - this.labxdist;
        } else {
            float d;
            xt += this.totalszW * zn / 2.0f;
            if (this.getPanelSideRL().equals("right") && xt > (d = (float)(MainFrame.getSmallViewArea().getWidth() - (double)(this.titleSize / 2.0f)))) {
                xt = d;
            }
        }
        return xt;
    }

    public float getTitleY() {
        float zn = this.getLegZoom();
        float yt = this.yposition + this.yintersp * this.ysignal * zn;
        if (this.isVertical) {
            if (this.getPanelSideTB().equals("top")) {
                float d = this.titleSize / 2.0f;
                if ((yt += this.totalszH * zn / 2.0f) < d) {
                    yt = d;
                }
            } else {
                float d = (float)(MainFrame.getSmallViewArea().getHeight() - (double)(this.titleSize / 2.0f));
                if ((yt -= this.totalszH * zn / 2.0f) > d) {
                    yt = d;
                }
            }
        } else {
            yt = this.getPanelSideTB().equals("top") ? yt + this.largerH * zn + this.labxdist : yt - this.largerH * zn - this.labxdist;
        }
        return yt;
    }

    private void topLeft() {
        float zn = this.getLegZoom();
        float sz = 0.0f;
        if (this.isVertical) {
            sz = this.totalszW / 2.0f - MainFrame.LegendList.get(this.legid).getW() / 2.0f;
        }
        this.xposition = sz * zn + (this.distBorderX + this.correcDx);
        this.yposition = this.distBorderY + this.correcDy;
        this.xsignal = 1.0f;
        this.ysignal = 1.0f;
    }

    private void topRight() {
        float zn = this.getLegZoom();
        float sz = this.totalszW;
        if (this.isVertical) {
            sz = MainFrame.LegendList.get(this.legid).getW() / 2.0f + this.totalszW / 2.0f;
        }
        this.xposition = (float)MainFrame.drawpanel.getWidth() - sz * zn - (this.distBorderX + this.correcDx);
        this.yposition = this.distBorderY + this.correcDy;
        this.xsignal = 1.0f;
        this.ysignal = 1.0f;
    }

    private void bottomLeft() {
        float zn = this.getLegZoom();
        float sz = 0.0f;
        if (this.isVertical) {
            sz = this.totalszW / 2.0f - MainFrame.LegendList.get(this.legid).getW() / 2.0f;
        }
        this.xposition = sz * zn + (this.distBorderX + this.correcDx);
        this.yposition = (float)MainFrame.drawpanel.getHeight() - (this.distBorderY + this.correcDy);
        this.xsignal = 1.0f;
        this.ysignal = -1.0f;
    }

    private void bottomRight() {
        float zn = this.getLegZoom();
        float sz = this.totalszW;
        if (this.isVertical) {
            sz = MainFrame.LegendList.get(this.legid).getW() / 2.0f + this.totalszW / 2.0f;
        }
        this.xposition = (float)MainFrame.drawpanel.getWidth() - sz * zn - (this.distBorderX + this.correcDx);
        this.yposition = (float)MainFrame.drawpanel.getHeight() - (this.distBorderY + this.correcDy);
        this.xsignal = 1.0f;
        this.ysignal = -1.0f;
    }

    private void setTextPos() {
        this.legAccount = MainFrame.LegendList.get(this.legid);
        if (this.isVertical) {
            this.legAccount.setFontY(-this.fontDistY);
            if (this.getPanelSideRL().equals("left")) {
                this.legAccount.setFontX(-this.fontDistX);
            } else {
                this.legAccount.setFontX(this.fontDistX);
            }
        } else {
            this.legAccount.setFontY(-this.fontDistY);
            if (this.getPanelSideTB().equals("top")) {
                this.legAccount.setFontX(this.fontDistX);
            } else {
                this.legAccount.setFontX(-this.fontDistX);
            }
        }
    }

    public void setLegType(String str) {
        this.legtype = str;
    }

    public String getLegType() {
        return this.legtype;
    }

    public void totalMembers(int nm) {
        this.nmembers = nm;
    }

    public void setDim(float tszH, float tszW, float szH, float szW) {
        this.totalszH = tszH;
        this.totalszW = tszW;
        this.largerH = szH;
        this.largerW = szW;
    }

    public float getTotalH() {
        return this.totalszH;
    }

    public float getTotalW() {
        return this.totalszH;
    }

    public float getLargerH() {
        return this.largerH;
    }

    public float getLargerW() {
        return this.largerW;
    }

    public void setVertical(boolean b) {
        this.isVertical = b;
        if (this.isVertical) {
            this.xmove = 0.0f;
            this.ymove = 1.0f;
        } else {
            this.xmove = 1.0f;
            this.ymove = 0.0f;
        }
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public int getTotalMembers() {
        return this.nmembers;
    }

    public void setMembership(int nm) {
        this.membership = nm;
    }

    public int getMembership() {
        return this.membership;
    }
}

