/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedPreferences {
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private String defaultShellStatus = "nonvalidated";
    private int defaultServerPort = 9091;
    private boolean RView = true;
    private String userdir;

    RedPreferences() {
        String ini0 = "Rshell";
        String ini5 = "serverPort";
        this.prefs.get(ini0, this.defaultShellStatus);
        this.prefs.getInt(ini5, this.defaultServerPort);
        String ini6 = "RView";
        this.prefs.getBoolean(ini6, this.RView);
        String ini12 = "userdir";
        this.userdir = System.getProperty("user.dir");
        this.prefs.get(ini12, this.userdir);
    }

    public void resetPreferences() {
        this.prefs.putInt("serverPort", this.defaultServerPort);
    }

    public int getServerPort() {
        return this.prefs.getInt("serverPort", this.defaultServerPort);
    }

    public String getUserDir() {
        return this.prefs.get("userdir", this.userdir);
    }

    public final String getOsType() {
        String osType = System.getProperty("os.name");
        Pattern ptWin = Pattern.compile("win", 2);
        Pattern ptMac = Pattern.compile("mac", 2);
        Pattern ptLin = Pattern.compile("linux", 2);
        if (ptWin.matcher(osType).find()) {
            return "win";
        }
        if (ptMac.matcher(osType).find()) {
            return "mac";
        }
        if (ptLin.matcher(osType).find()) {
            return "linux";
        }
        return "unknown";
    }

    public String getLocalDir() {
        String s = new File("").getAbsolutePath().replace("\\", "/");
        URL url = this.getClass().getResource("/reder/application/resources/front.png");
        String syspath = url.getPath();
        try {
            syspath = URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(RedPreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
        Pattern pt = Pattern.compile("^(file:/)(.+)(!/reder/application/resources/front.png)");
        Matcher matcher = pt.matcher(syspath);
        if (matcher.find()) {
            String m = matcher.group(2);
            if (this.getOsType().equals("win")) {
                File f = new File(m);
                if (f.exists()) {
                    m = f.getParent().replace("\\", "/");
                    return m;
                }
                return s;
            }
            File f = new File("/" + m);
            if (f.exists()) {
                m = f.getParent().replace("\\", "/");
                return m;
            }
            return s;
        }
        return s;
    }

    public void setOptionRView(boolean opt) {
        this.prefs.putBoolean("RView", opt);
    }

    public void setStatusRshell(String status) {
        this.prefs.put("Rshell", status);
    }

    public void setServerPort(int port) {
        this.prefs.putInt("serverPort", port);
    }

    public void setServerPort(String port) {
        int p = 9091;
        try {
            p = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.prefs.putInt("serverPort", p);
    }

    public void setUserdir(int dir) {
        this.prefs.putInt("userdir", dir);
    }
}

