/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingworker.SwingWorker;
import reder.application.MainFrame;
import reder.application.Zoom;
import reder.application.graph.EdgeBank;
import reder.application.graph.LegendBank;
import reder.application.graph.NodeBank;

public class Methods {
    private NodeBank nodeAccount = null;
    private NodeBank nodeAccountFound = null;
    private EdgeBank edgeAccount = null;
    private boolean isToAssignTree = false;
    private tarefaFilterZoom taskFilterZoom = null;

    public void deSelectGraph() {
        this.deSelectNodes();
        this.deSelectEdges();
    }

    public void selectGraph() {
        this.selectAllNodes();
        this.selectAllEdges();
    }

    public void selectAllNodes() {
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            if (this.nodeAccount.isContainerHided()) continue;
            this.nodeAccount.setDestaque(true);
        }
    }

    public void taskHighlight() {
        tarefaHighlight newTask = new tarefaHighlight();
        newTask.execute();
    }

    public int selectNeighbours(String nodeA) {
        for (NodeBank a : MainFrame.NodeList) {
            if (!a.getNodeID().equals(nodeA)) continue;
            a.setDestaqueNeighbours(true);
            return 1;
        }
        return 0;
    }

    public void selectAllEdges() {
        for (int i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            if (!MainFrame.isToShowTree() && this.edgeAccount.isDefaultEdgeAssignmet() && MainFrame.NodeList.get(this.edgeAccount.getA()).isContainer()) continue;
            this.edgeAccount.setDestaque(true);
        }
    }

    public void deSelectNodes() {
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            this.nodeAccount.setDestaque(false);
            this.nodeAccount.setDestaqueTree(false);
        }
    }

    public void deSelectEdges() {
        for (int i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            this.edgeAccount.setDestaque(false);
        }
    }

    public void selectEdge(String nodeA, String nodeB) {
        for (int i = 0; i < MainFrame.EdgeList.size(); ++i) {
            boolean cc2;
            this.edgeAccount = MainFrame.EdgeList.get(i);
            int a = this.edgeAccount.getA();
            int b = this.edgeAccount.getB();
            String na = MainFrame.NodeList.get(a).getNodeID();
            String nb = MainFrame.NodeList.get(b).getNodeID();
            String aliasa = MainFrame.NodeList.get(a).getAliases();
            String aliasb = MainFrame.NodeList.get(b).getAliases();
            boolean c1 = na.equals(nodeA) && nb.equals(nodeB);
            boolean c2 = na.equals(nodeB) && nb.equals(nodeA);
            boolean cc1 = c1 || c2;
            c1 = aliasa.equals(nodeA) && aliasb.equals(nodeB);
            c2 = aliasa.equals(nodeB) && aliasb.equals(nodeA);
            boolean bl = cc2 = c1 || c2;
            if (!cc1 && !cc2) continue;
            this.edgeAccount.setDestaque(true);
            break;
        }
    }

    public int selectNode(String nodeA, String nt) {
        for (NodeBank a : MainFrame.NodeList) {
            if (nt != null) {
                if (!a.isNodeNested()) continue;
                int nrt = MainFrame.keyNodeArray.indexOf(a.getNestedAssignment());
                String roodId = MainFrame.NodeList.get(nrt).getNodeID();
                String roodAlias = MainFrame.NodeList.get(nrt).getAliases();
                if (!roodId.equals(nt) || !roodAlias.equals(nt)) continue;
            }
            if (!a.getNodeID().equals(nodeA) && !a.getAliases().equals(nodeA)) continue;
            a.setDestaque(true);
            return 1;
        }
        return 0;
    }

    public String aninhar(ArrayList<Integer> listaMarcados, Color containerColor, boolean setHide, boolean setTransparency, boolean setAnchor, boolean setAssigned) {
        boolean condition3;
        String rootPanel = "assignRoot_meaninglessCode1245ty890xyz";
        int[] marcadosLevel = new int[listaMarcados.size()];
        String[] marcadosRoot = new String[listaMarcados.size()];
        for (int i = 0; i < listaMarcados.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(listaMarcados.get(i));
            marcadosRoot[i] = this.nodeAccount.getNestedAssignment();
            marcadosLevel[i] = 0;
            boolean flagRoot = false;
            String rootPath = marcadosRoot[i];
            while (!flagRoot) {
                if (rootPath.equals(rootPanel)) {
                    flagRoot = true;
                    continue;
                }
                marcadosLevel[i] = marcadosLevel[i] + 1;
                rootPath = MainFrame.NodeList.get(MainFrame.keyNodeArray.indexOf(rootPath)).getNestedAssignment();
            }
        }
        String validRoot = "";
        int validRootLevel = 0;
        for (int i = 0; i < marcadosLevel.length; ++i) {
            validRootLevel = marcadosLevel[i];
            validRoot = marcadosRoot[i];
            for (int j = 0; j < marcadosLevel.length; ++j) {
                if (validRootLevel <= marcadosLevel[j]) continue;
                validRootLevel = marcadosLevel[j];
                validRoot = marcadosRoot[j];
            }
        }
        int nFilhosValidos = 0;
        int nFilhos = 0;
        ArrayList<String> listaAninhados = new ArrayList<String>();
        for (int i = 0; i < listaMarcados.size(); ++i) {
            if (marcadosLevel[i] == validRootLevel) {
                ++nFilhos;
            }
            if (!marcadosRoot[i].equals(validRoot)) continue;
            ++nFilhosValidos;
            listaAninhados.add(MainFrame.NodeList.get(listaMarcados.get(i)).getNodeID());
        }
        int nNetosValidos = 0;
        int nNetos = 0;
        if (nFilhosValidos >= 1) {
            for (int i = 0; i < listaMarcados.size(); ++i) {
                if (marcadosLevel[i] <= validRootLevel) continue;
                ++nNetos;
                String rootPath = marcadosRoot[i];
                for (int j = 0; j < marcadosLevel[i]; ++j) {
                    for (int k = 0; k < listaAninhados.size(); ++k) {
                        if (!rootPath.equals(listaAninhados.get(k))) continue;
                        ++nNetosValidos;
                        break;
                    }
                    rootPath = MainFrame.NodeList.get(MainFrame.keyNodeArray.indexOf(rootPath)).getNestedAssignment();
                }
            }
        }
        boolean condition1 = nFilhosValidos >= 1;
        boolean condition2 = nFilhosValidos == nFilhos;
        boolean bl = condition3 = nNetosValidos == nNetos;
        if (condition1 && condition2 && condition3) {
            MainFrame.lockMouse = true;
            int gn = 0;
            int tn = 0;
            for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
                this.nodeAccount = MainFrame.NodeList.get(i);
                if (!this.nodeAccount.isContainer()) continue;
                String testNumber = this.nodeAccount.getNodeID();
                testNumber = (String)testNumber.subSequence(1, testNumber.length());
                try {
                    tn = Integer.parseInt(testNumber);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (tn < gn) continue;
                gn = tn + 1;
            }
            String containerName = "N" + gn;
            while (true) {
                if (!MainFrame.keyNodeHash.containsKey(containerName)) {
                    boolean flag = false;
                    for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
                        this.nodeAccount = MainFrame.NodeList.get(i);
                        boolean b = this.nodeAccount.getNodeID().contains(".$" + containerName);
                        if (!b) continue;
                        flag = true;
                    }
                    if (!flag) break;
                }
                containerName = "N" + ++gn;
            }
            MainFrame.NodeList.add(new NodeBank(containerName, MainFrame.NodeList.size()));
            int newContainer = MainFrame.NodeList.size() - 1;
            MainFrame.keyNodeHash.put(containerName, new Integer(newContainer));
            MainFrame.keyNodeArray.add(containerName);
            NodeBank containerAccount = MainFrame.NodeList.get(newContainer);
            containerAccount.setContainer(true);
            if (!validRoot.equals(rootPanel)) {
                Integer root = (Integer)MainFrame.keyNodeHash.get(validRoot);
                MainFrame.EdgeList.add(0, new EdgeBank(root, newContainer, MainFrame.EdgeList.size()));
                this.edgeAccount = MainFrame.EdgeList.get(0);
                this.edgeAccount.setColor(containerColor);
                this.edgeAccount.setLine(2.0f, "DOTTED_SHORT");
            }
            for (int i = 0; i < listaMarcados.size(); ++i) {
                int marcado = listaMarcados.get(i);
                this.nodeAccount = MainFrame.NodeList.get(marcado);
                if (!this.nodeAccount.getNestedAssignment().equals(validRoot)) continue;
                if (this.nodeAccount.isNodeNested()) {
                    for (int j = 0; j < MainFrame.EdgeList.size(); ++j) {
                        this.edgeAccount = MainFrame.EdgeList.get(j);
                        int nA = this.edgeAccount.getA();
                        int nB = this.edgeAccount.getB();
                        if (!MainFrame.NodeList.get(nA).isContainer() || !MainFrame.NodeList.get(nB).getNodeID().equals(this.nodeAccount.getNodeID()) || !this.edgeAccount.isDefaultEdgeAssignmet()) continue;
                        MainFrame.EdgeList.remove(this.edgeAccount);
                    }
                }
                MainFrame.EdgeList.add(0, new EdgeBank(newContainer, marcado, MainFrame.EdgeList.size()));
                this.edgeAccount = MainFrame.EdgeList.get(0);
                this.edgeAccount.setColor(containerColor);
                this.edgeAccount.setLine(2.0f, "DOTTED_SHORT");
            }
            this.updateBanks();
            containerAccount.updateContainer();
            containerAccount.setFontSize(16);
            containerAccount.setFontX(-8.0f);
            containerAccount.setFontY(-8.0f);
            containerAccount.setNodeColor(containerColor);
            containerAccount.setNodeLineColor(containerColor);
            containerAccount.setNodeGradient(true);
            containerAccount.setNodeLineWidth(containerAccount.getNodeSize() / 20.0f);
            containerAccount.setContainerHided(setHide);
            containerAccount.setContainerTransparent(setTransparency);
            containerAccount.setNodeContainerAnchored(setAnchor);
            int flag = 0;
            this.deSelectNodes();
            for (int a = 0; a < listaMarcados.size() - flag; ++a) {
                MainFrame.NodeList.get(listaMarcados.get(a)).setDestaque(true);
            }
            this.globalChangeOrder("forward");
            this.deSelectNodes();
            listaMarcados.clear();
            if (this.isToAssignTree()) {
                this.assignTree(containerAccount);
            } else if (setAssigned) {
                this.assignTree(containerAccount);
            }
            if (containerAccount.getContainerComponents().size() <= 2) {
                this.removeMockNodes();
            }
            MainFrame.lockMouse = false;
            return containerAccount.getNodeID();
        }
        String aviso = "";
        if (!condition1 && (condition2 || condition3)) {
            aviso = "Your request is inconsistent with the hierarchy!";
        } else if (!condition2 || !condition3) {
            aviso = "Your request is inconsistent with the hierarchy!";
        }
        MainFrame.lockMouse = false;
        return aviso;
    }

    public void removeMockNodes() {
        this.deSelectNodes();
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            if (!this.nodeAccount.isMock()) continue;
            this.nodeAccount.setDestaque(true);
        }
        MainFrame.methods.globalActionDeleteNode();
    }

    public void assignTreePermanently() {
        this.isToAssignTree = true;
    }

    public boolean isToAssignTree() {
        return this.isToAssignTree;
    }

    private void assignTree(NodeBank container) {
        if (container.isContainer()) {
            container.assignTree();
            MainFrame.keyNodeArray.clear();
            MainFrame.keyNodeHash.clear();
            for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
                this.nodeAccount = MainFrame.NodeList.get(i);
                String name = this.nodeAccount.getNodeID();
                MainFrame.keyNodeArray.add(name);
                MainFrame.keyNodeHash.put(name, new Integer(i));
            }
            this.updateBanks();
        }
    }

    public void mergeContainerOutEdges(ArrayList<Integer> listaContainers) {
        MainFrame.lockMouse = true;
        for (int a = 0; a < listaContainers.size(); ++a) {
            this.deSelectNodes();
            this.deSelectEdges();
            int nest = listaContainers.get(a);
            this.nodeAccountFound = MainFrame.NodeList.get(nest);
            if (!this.nodeAccountFound.isContainer()) continue;
            this.nodeAccountFound.setDestaqueTree(true);
            ArrayList<Integer> components = this.nodeAccountFound.getContainerComponents();
            for (int i = 0; i < components.size(); ++i) {
                this.nodeAccount = MainFrame.NodeList.get(components.get(i));
                int oneComponent = (Integer)MainFrame.keyNodeHash.get(this.nodeAccount.getNodeID());
                ArrayList<Integer> parceiros = this.nodeAccount.getParceiros();
                for (int j = 0; j < parceiros.size(); ++j) {
                    boolean c2;
                    boolean c1;
                    EdgeBank ref;
                    int k;
                    EdgeBank merge2;
                    EdgeBank merge1;
                    int umParceiro = parceiros.get(j);
                    if (MainFrame.NodeList.get(umParceiro).getDestaqueTree()) continue;
                    boolean deposito = this.nodeAccountFound.addParceiro(umParceiro);
                    if (deposito) {
                        MainFrame.EdgeList.add(new EdgeBank(nest, umParceiro, MainFrame.EdgeList.size()));
                        merge1 = MainFrame.EdgeList.get(MainFrame.EdgeList.size() - 1);
                        merge2 = null;
                        for (k = 0; k < MainFrame.EdgeList.size(); ++k) {
                            ref = MainFrame.EdgeList.get(k);
                            c1 = ref.getA() == oneComponent && ref.getB() == umParceiro;
                            boolean bl = c2 = ref.getB() == oneComponent && ref.getA() == umParceiro;
                            if (!c1 && !c2) continue;
                            merge2 = ref;
                            break;
                        }
                        merge1.setLineWidth(merge2.getWidth());
                        merge1.setWeight(merge2.getWeight());
                        merge1.addUnit(merge2.getUnit() - 1);
                        merge1.setDefaultContainerEdge(false);
                        merge1.setColor(Color.LIGHT_GRAY);
                        merge2.setDestaque(true);
                        continue;
                    }
                    merge1 = null;
                    merge2 = null;
                    for (k = MainFrame.EdgeList.size() - 1; k >= 0; --k) {
                        ref = MainFrame.EdgeList.get(k);
                        c1 = ref.getA() == nest && ref.getB() == umParceiro;
                        boolean bl = c2 = ref.getB() == nest && ref.getA() == umParceiro;
                        if (c1 || c2) {
                            merge1 = ref;
                            if (merge2 != null) break;
                        }
                        c1 = ref.getA() == oneComponent && ref.getB() == umParceiro;
                        boolean bl2 = c2 = ref.getB() == oneComponent && ref.getA() == umParceiro;
                        if (!c1 && !c2) continue;
                        merge2 = ref;
                        if (merge1 != null) break;
                    }
                    merge1.setLineWidth(merge1.getWidth() + merge2.getWidth());
                    merge1.setWeight(merge1.getWeight() + merge2.getWeight());
                    merge1.addUnit(merge2.getUnit());
                    merge1.setDefaultContainerEdge(false);
                    merge2.setDestaque(true);
                }
            }
            this.deleteSelectedEdges();
        }
        MainFrame.lockMouse = false;
    }

    public void correctOutEdgeWidth(double cclimit) {
        int i;
        cclimit = Math.max(Math.min(cclimit, 1.0), 0.001);
        double rescale = 1.0;
        double scl = 1.0;
        for (i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            if (this.edgeAccount.isDefaultEdgeAssignmet()) continue;
            NodeBank na = MainFrame.NodeList.get(this.edgeAccount.getA());
            NodeBank nb = MainFrame.NodeList.get(this.edgeAccount.getB());
            double sznode = (double)((na.getW() + na.getH()) / 2.0f) * cclimit;
            sznode = Math.min(sznode, (double)((nb.getW() + nb.getH()) / 2.0f) * cclimit);
            double szedge = this.edgeAccount.getWidth();
            if (!(szedge > sznode) || !((scl = sznode / szedge) < rescale)) continue;
            rescale = scl;
        }
        if (rescale == 0.0 || rescale == 1.0) {
            return;
        }
        for (i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            this.edgeAccount.setEdgeSizeScale((float)rescale);
        }
    }

    public void correctOutEdgeWidth(Double lb, Double ub) {
        NodeBank nb;
        NodeBank na;
        double maxSize = 0.0;
        double minSize = 1000000.0;
        for (int j = 0; j < MainFrame.EdgeList.size(); ++j) {
            this.edgeAccount = MainFrame.EdgeList.get(j);
            if (this.edgeAccount.isDefaultEdgeAssignmet()) continue;
            na = MainFrame.NodeList.get(this.edgeAccount.getA());
            nb = MainFrame.NodeList.get(this.edgeAccount.getB());
            if (!na.isContainer() || !nb.isContainer()) continue;
            double szedge = this.edgeAccount.getWidth();
            if (maxSize < szedge) {
                maxSize = szedge;
            }
            if (!(minSize > szedge)) continue;
            minSize = szedge;
        }
        if (ub == null || lb == null) {
            lb = minSize;
            ub = maxSize;
        }
        if (maxSize == minSize) {
            return;
        }
        for (int i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            if (this.edgeAccount.isDefaultEdgeAssignmet()) continue;
            na = MainFrame.NodeList.get(this.edgeAccount.getA());
            nb = MainFrame.NodeList.get(this.edgeAccount.getB());
            if (!na.isContainer() || !nb.isContainer()) continue;
            double globalnorm = ((double)this.edgeAccount.getWidth() - minSize) / (maxSize - minSize);
            double width = lb + globalnorm * (ub - lb);
            this.edgeAccount.setLineWidth((float)width);
        }
    }

    public int reAssigments(String newparent, Vector<String> nodes, boolean upsdatecontent) {
        int countranfer = 0;
        if (newparent.equals(".$unroot")) {
            for (int i = 0; i < nodes.size(); ++i) {
                String nd = nodes.get(i);
                int nnode = MainFrame.keyNodeArray.indexOf(nd);
                if (nnode == -1) continue;
                this.nodeAccount = MainFrame.NodeList.get(nnode);
                if (!this.nodeAccount.isNodeNested()) continue;
                int nroot = MainFrame.keyNodeArray.indexOf(this.nodeAccount.getNestedAssignment());
                for (int j = 0; j < MainFrame.EdgeList.size(); ++j) {
                    this.edgeAccount = MainFrame.EdgeList.get(j);
                    if (!this.edgeAccount.getEdgeAssociationType().equals("edgeTree") || this.edgeAccount.getA() != nroot || this.edgeAccount.getB() != nnode) continue;
                    MainFrame.EdgeList.remove(this.edgeAccount);
                    --j;
                }
            }
            MainFrame.methods.updateBanks();
            return countranfer;
        }
        int idNewParent = MainFrame.keyNodeArray.indexOf(newparent);
        if (idNewParent == -1) {
            return countranfer;
        }
        NodeBank nodeAccountNewParent = MainFrame.NodeList.get(idNewParent);
        if (!nodeAccountNewParent.isContainer()) {
            return countranfer;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            String nod = nodes.get(i);
            int idNode = MainFrame.keyNodeArray.indexOf(nod);
            if (idNode == -1 || idNewParent == idNode) continue;
            NodeBank nodeAccountNode = MainFrame.NodeList.get(idNode);
            int idOldParent = nodeAccountNode.getNestedAssignmentIndx();
            if (nodeAccountNewParent.isPartner(idNode)) continue;
            boolean flagRoot = false;
            int rpath = idNewParent;
            while (!flagRoot && rpath >= 0) {
                if (rpath != idOldParent && nodeAccountNode.isPartner(rpath)) {
                    flagRoot = true;
                }
                rpath = MainFrame.NodeList.get(rpath).getNestedAssignmentIndx();
            }
            if (flagRoot) continue;
            if (nodeAccountNode.isNodeNested()) {
                int nc = this.tranferAssigment(idOldParent, idNewParent, idNode);
                countranfer += nc;
                continue;
            }
            int idEdge = MainFrame.EdgeList.size();
            MainFrame.EdgeList.add(new EdgeBank(idNewParent, idNode, idEdge));
            this.edgeAccount = MainFrame.EdgeList.get(MainFrame.EdgeList.size() - 1);
            this.edgeAccount.setLine(2.0f, "DOTTED_SHORT");
            this.edgeAccount.setColor(nodeAccountNewParent.getTrueNodeColor());
            ++countranfer;
        }
        this.updateBanks();
        if (upsdatecontent) {
            nodeAccountNewParent.updateContent();
        }
        this.globalChangeOrder("forwardNode", nodes);
        return countranfer;
    }

    private int tranferAssigment(int n1, int n2, int n3) {
        int cont = 0;
        for (int i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            int a = this.edgeAccount.getA();
            int b = this.edgeAccount.getB();
            if (a != n1 || b != n3) continue;
            this.edgeAccount.setA(n2);
            ++cont;
        }
        return cont;
    }

    public void updateNodeTransform(boolean setHide, boolean setTransparency, boolean setAnchor, boolean setAssigned) {
        int i;
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            if (!this.nodeAccount.isTransformed()) continue;
            this.nodeAccount.nodeTransform();
            this.nodeAccount.setContainerHided(setHide);
            this.nodeAccount.setContainerTransparent(setTransparency);
            this.nodeAccount.setNodeContainerAnchored(setAnchor);
            if (!setAssigned) continue;
            this.assignTree(this.nodeAccount);
        }
        for (i = 0; i < MainFrame.EdgeList.size(); ++i) {
            boolean c2;
            this.edgeAccount = MainFrame.EdgeList.get(i);
            NodeBank nodeAccountA = MainFrame.NodeList.get(this.edgeAccount.getA());
            NodeBank nodeAccountB = MainFrame.NodeList.get(this.edgeAccount.getB());
            boolean ca = nodeAccountA.isTransformed();
            boolean cb = nodeAccountB.isTransformed();
            boolean c1 = ca || cb;
            boolean bl = c2 = !nodeAccountB.getNestedAssignment().equals(nodeAccountA.getNodeID());
            if (c1 && c2) {
                this.edgeAccount.setDefaultContainerEdge(false);
            }
            if (nodeAccountA.isContainer() || !cb) continue;
            int a = this.edgeAccount.getA();
            int b = this.edgeAccount.getB();
            this.edgeAccount.setA(b);
            this.edgeAccount.setB(a);
            int d = this.edgeAccount.getArrowDirection();
            if (d == 1) {
                this.edgeAccount.setArrowDirection(2);
            }
            if (d == 2) {
                this.edgeAccount.setArrowDirection(1);
            }
            if (d == -1) {
                this.edgeAccount.setArrowDirection(-2);
            }
            if (d == -2) {
                this.edgeAccount.setArrowDirection(-1);
            }
            if (d == 4) {
                this.edgeAccount.setArrowDirection(-4);
            }
            if (d != -4) continue;
            this.edgeAccount.setArrowDirection(4);
        }
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            this.nodeAccount.setTransformed(false);
        }
        this.updateBanks();
    }

    public void updateBanks() {
        int i;
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            MainFrame.NodeList.get(i).resetParceiros();
            MainFrame.NodeList.get(i).resetContainerComponents();
            MainFrame.NodeList.get(i).resetNestedAssignment();
            MainFrame.NodeList.get(i).resetContainerEdgeMap();
            MainFrame.NodeList.get(i).resetInContainerSimpleEdges();
            MainFrame.NodeList.get(i).resetOutContainerSimpleEdges();
            MainFrame.NodeList.get(i).setDestaqueTree(false);
        }
        for (i = 0; i < MainFrame.EdgeList.size(); ++i) {
            int nr;
            boolean c5;
            this.edgeAccount = MainFrame.EdgeList.get(i);
            this.edgeAccount.updateDefaultEdgeAssigment();
            NodeBank nodeAccountA = MainFrame.NodeList.get(this.edgeAccount.getA());
            NodeBank nodeAccountB = MainFrame.NodeList.get(this.edgeAccount.getB());
            nodeAccountA.addParceiro(this.edgeAccount.getB());
            nodeAccountB.addParceiro(this.edgeAccount.getA());
            boolean c1 = nodeAccountA.isContainer();
            boolean c2 = nodeAccountB.isContainer();
            boolean c3 = this.edgeAccount.isDefaultEdgeAssignmet();
            if (c1 && c3) {
                nodeAccountA.addContainerComponent(this.edgeAccount.getB());
                nodeAccountB.setNodeNested(nodeAccountA.getNodeID());
            } else if (!c3) {
                if (c1 && c2) {
                    for (int a = MainFrame.NodeList.size() - 1; a >= 0; --a) {
                        if (MainFrame.NodeList.get(a) == nodeAccountA) {
                            nodeAccountB.addContainerEdgeUnique(i);
                        } else {
                            if (MainFrame.NodeList.get(a) != nodeAccountB) continue;
                            nodeAccountA.addContainerEdgeUnique(i);
                        }
                        break;
                    }
                } else if (c1) {
                    nodeAccountA.addContainerEdgeUnique(i);
                } else if (c2) {
                    nodeAccountB.addContainerEdgeUnique(i);
                }
            }
            boolean c4 = nodeAccountA.isNodeNested() || nodeAccountB.isNodeNested();
            boolean bl = c5 = !nodeAccountA.getNestedAssignment().equals(nodeAccountB.getNestedAssignment());
            if (c1 || c2 || !c3 || !c4) continue;
            if (c5) {
                if (nodeAccountA.isNodeNested()) {
                    nr = MainFrame.keyNodeArray.indexOf(nodeAccountA.getNestedAssignment());
                    MainFrame.NodeList.get(nr).addOutContainerSimpleEdge(i);
                }
                if (!nodeAccountB.isNodeNested()) continue;
                nr = MainFrame.keyNodeArray.indexOf(nodeAccountB.getNestedAssignment());
                MainFrame.NodeList.get(nr).addOutContainerSimpleEdge(i);
                continue;
            }
            if (!nodeAccountA.isNodeNested()) continue;
            nr = MainFrame.keyNodeArray.indexOf(nodeAccountA.getNestedAssignment());
            MainFrame.NodeList.get(nr).addInContainerSimpleEdge(i);
        }
        this.updateContainerTree();
    }

    public void updateContainerTree() {
        int i;
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            this.nodeAccount.setNestedPosition(0);
            this.nodeAccount.setNestedVelox(1.0);
            if (!this.nodeAccount.isNodeNested() && !this.nodeAccount.isContainer()) {
                this.nodeAccount.setRelativeSize(1.0);
            }
            if (!this.nodeAccount.isContainer()) continue;
            this.nodeAccount.updateTreeSize();
            this.nodeAccount.updateTreeLevels();
            this.nodeAccount.updateTreeComponents();
        }
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            this.nodeAccount.updateNodeLevel();
        }
    }

    public void globalChangeOrder(String moveType) {
        int i;
        int i2;
        ArrayList<NodeBank> clone;
        ArrayList passingKeysArray = new ArrayList();
        Hashtable passingKeyHash = new Hashtable();
        passingKeysArray.clear();
        passingKeyHash.clear();
        if (moveType.equals("backward")) {
            clone = new ArrayList(MainFrame.NodeList.size());
            for (i2 = 0; i2 < MainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = MainFrame.NodeList.get(i2);
                if (!this.nodeAccount.getDestaque()) continue;
                clone.add(this.nodeAccount);
            }
            for (i2 = 0; i2 < MainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = MainFrame.NodeList.get(i2);
                if (this.nodeAccount.getDestaque()) continue;
                clone.add(this.nodeAccount);
            }
            MainFrame.NodeList.clear();
            MainFrame.NodeList = (ArrayList)clone.clone();
            clone.clear();
        } else {
            clone = new ArrayList<NodeBank>();
            for (i2 = 0; i2 < MainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = MainFrame.NodeList.get(i2);
                if (!this.nodeAccount.getDestaque()) continue;
                clone.add(this.nodeAccount);
                MainFrame.NodeList.remove(this.nodeAccount);
                --i2;
            }
            for (i2 = 0; i2 < clone.size(); ++i2) {
                MainFrame.NodeList.add((NodeBank)clone.get(i2));
            }
            clone.clear();
        }
        passingKeysArray = (ArrayList)MainFrame.keyNodeArray.clone();
        passingKeyHash = (Hashtable)MainFrame.keyNodeHash.clone();
        MainFrame.keyNodeArray.clear();
        MainFrame.keyNodeHash.clear();
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            String name = this.nodeAccount.getNodeID();
            MainFrame.keyNodeArray.add(name);
            MainFrame.keyNodeHash.put(name, new Integer(i));
        }
        for (i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            String name = (String)passingKeysArray.get(this.edgeAccount.getA());
            Integer number = (Integer)MainFrame.keyNodeHash.get(name);
            if (number != null) {
                this.edgeAccount.setA(number);
            }
            if ((number = (Integer)MainFrame.keyNodeHash.get(name = (String)passingKeysArray.get(this.edgeAccount.getB()))) == null) continue;
            this.edgeAccount.setB(number);
        }
        passingKeysArray.clear();
        passingKeyHash.clear();
        this.updateBanks();
    }

    public void globalChangeOrder(String moveType, Vector<String> listaMarcados) {
        int i;
        int nid;
        String nd;
        int i2;
        ArrayList<NodeBank> clone;
        ArrayList passingKeysArray = new ArrayList();
        Hashtable passingKeyHash = new Hashtable();
        passingKeysArray.clear();
        passingKeyHash.clear();
        if (moveType.equals("backward")) {
            clone = new ArrayList<NodeBank>(listaMarcados.size());
            for (i2 = 0; i2 < listaMarcados.size(); ++i2) {
                nd = listaMarcados.get(i2);
                nid = MainFrame.keyNodeArray.indexOf(nd);
                this.nodeAccount = MainFrame.NodeList.get(nid);
                clone.add(this.nodeAccount);
            }
            for (i2 = 0; i2 < MainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = MainFrame.NodeList.get(i2);
                if (listaMarcados.contains(this.nodeAccount.getNodeID())) continue;
                clone.add(this.nodeAccount);
            }
            MainFrame.NodeList.clear();
            MainFrame.NodeList = (ArrayList)clone.clone();
            clone.clear();
        } else {
            clone = new ArrayList(listaMarcados.size());
            for (i2 = 0; i2 < MainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = MainFrame.NodeList.get(i2);
                if (listaMarcados.contains(this.nodeAccount.getNodeID())) continue;
                clone.add(this.nodeAccount);
            }
            for (i2 = 0; i2 < listaMarcados.size(); ++i2) {
                nd = listaMarcados.get(i2);
                nid = MainFrame.keyNodeArray.indexOf(nd);
                this.nodeAccount = MainFrame.NodeList.get(nid);
                clone.add(this.nodeAccount);
            }
            MainFrame.NodeList.clear();
            MainFrame.NodeList = (ArrayList)clone.clone();
            clone.clear();
        }
        passingKeysArray = (ArrayList)MainFrame.keyNodeArray.clone();
        passingKeyHash = (Hashtable)MainFrame.keyNodeHash.clone();
        MainFrame.keyNodeArray.clear();
        MainFrame.keyNodeHash.clear();
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            String name = this.nodeAccount.getNodeID();
            MainFrame.keyNodeArray.add(name);
            MainFrame.keyNodeHash.put(name, new Integer(i));
        }
        for (i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            String name = (String)passingKeysArray.get(this.edgeAccount.getA());
            Integer number = (Integer)MainFrame.keyNodeHash.get(name);
            if (number != null) {
                this.edgeAccount.setA(number);
            }
            if ((number = (Integer)MainFrame.keyNodeHash.get(name = (String)passingKeysArray.get(this.edgeAccount.getB()))) == null) continue;
            this.edgeAccount.setB(number);
        }
        passingKeysArray.clear();
        passingKeyHash.clear();
        this.updateBanks();
    }

    public void combinar(ArrayList<Integer> listaMarcados, Color groupColor) {
        int gn = 0;
        String groupName = "G" + gn;
        while (MainFrame.keyNodeHash.containsKey(groupName)) {
            groupName = "G" + ++gn;
        }
        MainFrame.NodeList.add(new NodeBank(groupName, MainFrame.NodeList.size()));
        int newGrupo = MainFrame.NodeList.size() - 1;
        MainFrame.keyNodeHash.put(groupName, new Integer(newGrupo));
        MainFrame.keyNodeArray.add(groupName);
        NodeBank grupoAccount = MainFrame.NodeList.get(newGrupo);
        grupoAccount.setAsGroup(true);
        float areaGrupo = 0.0f;
        float xg = 0.0f;
        float yg = 0.0f;
        MainFrame.lockMouse = true;
        for (int i = 0; i < listaMarcados.size(); ++i) {
            int marcado = listaMarcados.get(i);
            this.nodeAccount = MainFrame.NodeList.get(marcado);
            if (this.nodeAccount.isGroup()) {
                grupoAccount.setGroupComponents(this.nodeAccount.getGroupComponets());
                grupoAccount.setGroupCompNumber(this.nodeAccount.getGroupCompNumber());
            } else {
                grupoAccount.setGroupComponents(this.nodeAccount.getNodeID());
            }
            xg += this.nodeAccount.getX();
            yg += this.nodeAccount.getY();
            for (int j = 0; j < this.nodeAccount.getParceiros().size(); ++j) {
                boolean c2;
                boolean c1;
                EdgeBank ref;
                int k;
                EdgeBank merge2;
                EdgeBank merge1;
                int parceiro = this.nodeAccount.getParceiros().get(j);
                boolean deposito = grupoAccount.addParceiro(parceiro);
                if (deposito) {
                    MainFrame.EdgeList.add(new EdgeBank(newGrupo, parceiro, MainFrame.EdgeList.size()));
                    merge1 = MainFrame.EdgeList.get(MainFrame.EdgeList.size() - 1);
                    merge2 = null;
                    for (k = 0; k < MainFrame.EdgeList.size(); ++k) {
                        ref = MainFrame.EdgeList.get(k);
                        c1 = ref.getA() == marcado && ref.getB() == parceiro;
                        boolean bl = c2 = ref.getB() == marcado && ref.getA() == parceiro;
                        if (!c1 && !c2) continue;
                        merge2 = ref;
                        break;
                    }
                    merge1.setLineWidth(merge2.getWidth());
                    continue;
                }
                merge1 = null;
                merge2 = null;
                for (k = MainFrame.EdgeList.size() - 1; k >= 0; --k) {
                    ref = MainFrame.EdgeList.get(k);
                    c1 = ref.getA() == newGrupo && ref.getB() == parceiro;
                    boolean bl = c2 = ref.getB() == newGrupo && ref.getA() == parceiro;
                    if (c1 || c2) {
                        merge1 = ref;
                        if (merge2 != null) break;
                    }
                    c1 = ref.getA() == marcado && ref.getB() == parceiro;
                    boolean bl2 = c2 = ref.getB() == marcado && ref.getA() == parceiro;
                    if (!c1 && !c2) continue;
                    merge2 = ref;
                    if (merge1 != null) break;
                }
                merge1.setLineWidth(merge1.getWidth() + merge2.getWidth());
            }
            areaGrupo = (float)((double)areaGrupo + Math.pow(this.nodeAccount.getNodeSize(), 2.0));
        }
        grupoAccount.setAliases(groupName + "[" + grupoAccount.getGroupComponets() + "]");
        grupoAccount.setNode(xg / (float)listaMarcados.size(), yg / (float)listaMarcados.size());
        grupoAccount.setGroupSize(areaGrupo);
        grupoAccount.setNodeColor(groupColor);
        grupoAccount.setNodeLineColor(groupColor);
        this.globalActionDeleteNode();
        listaMarcados.clear();
        MainFrame.lockMouse = false;
    }

    public void globalActionDeleteNode() {
        String name;
        int i;
        ArrayList<String> nodosRetirados = new ArrayList<String>();
        ArrayList passingKeysArray = new ArrayList();
        Hashtable passingKeyHash = new Hashtable();
        nodosRetirados.clear();
        passingKeysArray.clear();
        passingKeyHash.clear();
        MainFrame.lockMouse = true;
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            if (!this.nodeAccount.getDestaque()) continue;
            this.nodeAccount.setDestaque(true);
            nodosRetirados.add(this.nodeAccount.getNodeID());
            MainFrame.NodeList.remove(this.nodeAccount);
            --i;
        }
        passingKeysArray = (ArrayList)MainFrame.keyNodeArray.clone();
        passingKeyHash = (Hashtable)MainFrame.keyNodeHash.clone();
        MainFrame.keyNodeArray.clear();
        MainFrame.keyNodeHash.clear();
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            name = this.nodeAccount.getNodeID();
            MainFrame.keyNodeArray.add(name);
            MainFrame.keyNodeHash.put(name, new Integer(i));
        }
        for (i = 0; i < nodosRetirados.size(); ++i) {
            Integer numero = (Integer)passingKeyHash.get(nodosRetirados.get(i));
            for (int j = 0; j < MainFrame.EdgeList.size(); ++j) {
                this.edgeAccount = MainFrame.EdgeList.get(j);
                int a = this.edgeAccount.getA();
                int b = this.edgeAccount.getB();
                if (numero != a && numero != b) continue;
                MainFrame.EdgeList.remove(this.edgeAccount);
                --j;
            }
        }
        for (i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            name = (String)passingKeysArray.get(this.edgeAccount.getA());
            Integer number = (Integer)MainFrame.keyNodeHash.get(name);
            if (number != null) {
                this.edgeAccount.setA(number);
            }
            if ((number = (Integer)MainFrame.keyNodeHash.get(name = (String)passingKeysArray.get(this.edgeAccount.getB()))) == null) continue;
            this.edgeAccount.setB(number);
        }
        passingKeysArray.clear();
        passingKeyHash.clear();
        nodosRetirados.clear();
        this.updateBanks();
        MainFrame.lockMouse = false;
    }

    public void addEdgesAndNodes(String nodeA, String nodeB, boolean defaultNestedCondition) {
        int flagSteps = 0;
        if (nodeA.equals("") || nodeB.equals("")) {
            String node = "";
            if (!nodeA.equals("")) {
                node = nodeA;
            }
            if (!nodeB.equals("")) {
                node = nodeB;
            }
            if (!MainFrame.keyNodeHash.containsKey(node) && !node.equals("")) {
                MainFrame.NodeList.add(new NodeBank(node, MainFrame.NodeList.size()));
                int addNode = MainFrame.NodeList.size() - 1;
                MainFrame.keyNodeHash.put(node, new Integer(addNode));
                MainFrame.keyNodeArray.add(node);
                this.nodeAccount = MainFrame.NodeList.get(addNode);
                this.nodeAccount.setNodeColor(Color.WHITE);
            }
        } else if (!nodeA.equals("") && !nodeB.equals("")) {
            int addNode;
            boolean flagA = false;
            boolean flagB = false;
            int numeroA = 0;
            int numeroB = 0;
            if (!MainFrame.keyNodeHash.containsKey(nodeA)) {
                MainFrame.NodeList.add(new NodeBank(nodeA, MainFrame.NodeList.size()));
                addNode = MainFrame.NodeList.size() - 1;
                MainFrame.keyNodeHash.put(nodeA, new Integer(addNode));
                MainFrame.keyNodeArray.add(nodeA);
                this.nodeAccount = MainFrame.NodeList.get(addNode);
                this.nodeAccount.setNodeColor(Color.WHITE);
                flagA = true;
                numeroA = addNode;
            } else {
                numeroA = (Integer)MainFrame.keyNodeHash.get(nodeA);
            }
            if (!MainFrame.keyNodeHash.containsKey(nodeB)) {
                MainFrame.NodeList.add(new NodeBank(nodeB, MainFrame.NodeList.size()));
                addNode = MainFrame.NodeList.size() - 1;
                MainFrame.keyNodeHash.put(nodeB, new Integer(addNode));
                MainFrame.keyNodeArray.add(nodeB);
                this.nodeAccount = MainFrame.NodeList.get(addNode);
                this.nodeAccount.setNodeColor(Color.WHITE);
                flagB = true;
                numeroB = addNode;
            } else {
                numeroB = (Integer)MainFrame.keyNodeHash.get(nodeB);
            }
            if (numeroA != numeroB) {
                if (flagA || flagB) {
                    flagSteps = 1;
                } else {
                    int n = MainFrame.EdgeList.size();
                    boolean flagFound = false;
                    for (int i = 0; i < n && !flagFound; ++i) {
                        this.edgeAccount = MainFrame.EdgeList.get(i);
                        if ((this.edgeAccount.getA() != numeroA || this.edgeAccount.getB() != numeroB) && (this.edgeAccount.getA() != numeroB || this.edgeAccount.getB() != numeroA)) continue;
                        flagFound = true;
                    }
                    if (!flagFound) {
                        flagSteps = 1;
                    }
                }
            }
            if (flagSteps == 1) {
                NodeBank nodeAccountA = MainFrame.NodeList.get(numeroA);
                NodeBank nodeAccountB = MainFrame.NodeList.get(numeroB);
                boolean c1 = nodeAccountA.isContainer();
                boolean c2 = nodeAccountB.isContainer();
                if (c1 && defaultNestedCondition) {
                    if (nodeAccountB.isNodeNested()) {
                        int numeroRoot = MainFrame.keyNodeArray.indexOf(nodeAccountB.getNestedAssignment());
                        for (int j = 0; j < MainFrame.EdgeList.size(); ++j) {
                            this.edgeAccount = MainFrame.EdgeList.get(j);
                            int a = this.edgeAccount.getA();
                            int b = this.edgeAccount.getB();
                            if ((numeroB != a || numeroRoot != b) && (numeroRoot != a || numeroB != b)) continue;
                            MainFrame.EdgeList.remove(this.edgeAccount);
                            break;
                        }
                    }
                    MainFrame.EdgeList.add(0, new EdgeBank(numeroA, numeroB, MainFrame.EdgeList.size()));
                    this.edgeAccount = MainFrame.EdgeList.get(0);
                    this.edgeAccount.setLine(2.0f, "DOTTED_SHORT");
                    this.edgeAccount.setColor(nodeAccountA.getTrueNodeColor());
                    flagSteps = 2;
                } else if (!c1 && !c2) {
                    MainFrame.EdgeList.add(new EdgeBank(numeroA, numeroB, MainFrame.EdgeList.size()));
                    flagSteps = 2;
                } else {
                    MainFrame.EdgeList.add(new EdgeBank(numeroA, numeroB, MainFrame.EdgeList.size()));
                    MainFrame.EdgeList.get(MainFrame.EdgeList.size() - 1).setDefaultContainerEdge(false);
                    flagSteps = 2;
                }
            }
        }
        if (flagSteps == 2) {
            this.updateBanks();
        }
    }

    public void deleteSelectedEdges() {
        MainFrame.lockMouse = true;
        for (int i = 0; i < MainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = MainFrame.EdgeList.get(i);
            if (!this.edgeAccount.getDestaque()) continue;
            NodeBank nodeAccoutA = MainFrame.NodeList.get(this.edgeAccount.getA());
            NodeBank nodeAccoutB = MainFrame.NodeList.get(this.edgeAccount.getB());
            boolean c1 = nodeAccoutA.isContainer();
            boolean c2 = nodeAccoutA.isNodeNested();
            boolean c3 = !nodeAccoutA.getNestedAssignment().equals(nodeAccoutB.getNestedAssignment());
            boolean c4 = this.edgeAccount.isDefaultEdgeAssignmet();
            if (c1 && c2 && c3 && c4) {
                int number = MainFrame.keyNodeArray.indexOf(nodeAccoutA.getNestedAssignment());
                this.edgeAccount.setA(number);
                this.edgeAccount.setColor(MainFrame.NodeList.get(number).getTrueNodeColor());
                continue;
            }
            MainFrame.EdgeList.remove(this.edgeAccount);
            --i;
        }
        this.updateBanks();
        MainFrame.lockMouse = false;
    }

    public boolean isRelaxActive() {
        return MainFrame.isRelaxActive;
    }

    public void stopDynamics() {
        MainFrame.activateRelaxCall = false;
        MainFrame.isRelaxActive = false;
    }

    public void startDynamics() {
        MainFrame.activateRelaxCall = true;
    }

    public void resetCooling() {
        MainFrame.temperature = 1.0;
    }

    public void setPanelSettingsOn(boolean ps) {
        MainFrame.startPanelSettings = ps;
    }

    public void setRelaxArgs(double att1, double att2, double att3, double att4, double att5, double att6, double att7, double att8) {
        MainFrame.setRelaxArgs(att1, att2, att3, att4, att5, att6, att7, att8);
    }

    public void addSpotNode(float x, float y, float spotEffect, float spotPerimeter, int spotDirection) {
        String spot = "$PT";
        int n = 0;
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            if (!this.nodeAccount.isSpot()) continue;
            ++n;
        }
        spot = spot + n + "$";
        this.addEdgesAndNodes(spot, "", true);
        this.nodeAccount = MainFrame.NodeList.get(MainFrame.NodeList.size() - 1);
        this.nodeAccount.setNode(x, y);
        this.nodeAccount.setFontSize(0);
        this.nodeAccount.setAsSpot();
        this.nodeAccount.setContainer(true);
        this.nodeAccount.setNodeContainerAnchored(true);
        this.nodeAccount.setNodeSize(5.0f);
        this.nodeAccount.setNodeLineType("DOTTED");
        this.nodeAccount.setNodeLineWidth(3.0f);
        this.nodeAccount.setNodeColor(Color.YELLOW);
        this.nodeAccount.setNodeLineColor(Color.RED);
        this.nodeAccount.setContainerTransparent(true);
        this.nodeAccount.setSpotEffect(spotEffect);
        this.nodeAccount.setSpotRange(spotPerimeter);
        this.nodeAccount.setSpotDirection(spotDirection);
    }

    public void setSpotsHided(boolean hide) {
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            if (!this.nodeAccount.isSpot()) continue;
            this.nodeAccount.setContainerHided(hide);
        }
    }

    public void zeraZoom() {
        double focoX = MainFrame.drawpanel.getWidth() / 2;
        double focoY = MainFrame.drawpanel.getHeight() / 2;
        int size = MainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.resetZoom(pontos, MainFrame.getZoom(), focoX, focoY);
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = MainFrame.NodeList.get(i);
            this.nodeAccount.setNodeToSave(x, y);
        }
    }

    public Point2D[] redoZoomScaleFromR(Point2D[] pontos) {
        double flip = 0.0;
        double fator = 0.0;
        if (MainFrame.getZoom() < 1.0) {
            flip = 1.0;
            fator = 1.0 - MainFrame.getZoom();
        } else if (MainFrame.getZoom() > 1.0) {
            flip = -1.0;
            fator = MainFrame.getZoom() - 1.0;
        }
        if (flip == 0.0) {
            return pontos;
        }
        double focoX = MainFrame.drawpanel.getWidth() / 2;
        double focoY = MainFrame.drawpanel.getHeight() / 2;
        Zoom zm = new Zoom();
        pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        return pontos;
    }

    public void setZoom(double newZoom) {
        if ((newZoom /= 100.0) <= 0.0) {
            newZoom = 0.01;
        }
        double oldZoom = MainFrame.getZoom();
        double flip = 0.0;
        if (newZoom < oldZoom) {
            flip = 1.0;
        } else if (newZoom > oldZoom) {
            flip = -1.0;
        }
        if (flip == 0.0) {
            return;
        }
        double fator = flip * (-newZoom + oldZoom) / oldZoom;
        MainFrame.setZoom(newZoom);
        double focoX = MainFrame.drawpanel.getWidth() / 2;
        double focoY = MainFrame.drawpanel.getHeight() / 2;
        int size = MainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = MainFrame.NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
        MainFrame.drawpanel.setZoom((float)newZoom);
    }

    public Point2D[] setCenterFromR(Point2D[] pontos, double gX, double gY) {
        double focoX = (double)MainFrame.drawpanel.getWidth() * (gX /= 100.0);
        double focoY = (double)MainFrame.drawpanel.getHeight() * (gY /= 100.0);
        Zoom zm = new Zoom();
        pontos = zm.setCenter(pontos, focoX, focoY);
        return pontos;
    }

    public void correctNodeAttScale(boolean isDefaultScale) {
        boolean c1;
        double topAttValue = -1000000.0;
        double botAttValue = 1000000.0;
        for (int j = 0; j < MainFrame.NodeList.size(); ++j) {
            this.nodeAccount = MainFrame.NodeList.get(j);
            double value = this.nodeAccount.getNodeWeight();
            if (topAttValue < value) {
                topAttValue = value;
            }
            if (!(botAttValue > value)) continue;
            botAttValue = value;
        }
        if (isDefaultScale) {
            boolean c2;
            c1 = topAttValue != botAttValue;
            boolean bl = c2 = botAttValue >= 0.0 && topAttValue <= 1.0;
            if (c1 && c2) {
                botAttValue = 0.0;
                topAttValue = 1.0;
            }
            double dist = Math.abs(topAttValue - botAttValue);
            for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
                this.nodeAccount = MainFrame.NodeList.get(i);
                double att = this.nodeAccount.getNodeWeight();
                if (c1) {
                    att = (att - botAttValue) / dist;
                    this.nodeAccount.setNormWeight(att);
                    continue;
                }
                if (c2) {
                    this.nodeAccount.setNormWeight(att);
                    continue;
                }
                this.nodeAccount.setNormWeight(0.0);
            }
        } else {
            boolean c2;
            c1 = topAttValue != botAttValue;
            boolean bl = c2 = botAttValue >= -1.0 && topAttValue <= 1.0;
            if (c1 && c2) {
                botAttValue = -1.0;
                topAttValue = 1.0;
            }
            double dist = Math.abs(topAttValue - botAttValue);
            for (int j = 0; j < MainFrame.NodeList.size(); ++j) {
                this.nodeAccount = MainFrame.NodeList.get(j);
                double att = this.nodeAccount.getNodeWeight();
                if (c1) {
                    att = (att - botAttValue) / (dist / 2.0) - 1.0;
                    att = (att + 1.0) / 2.0;
                    this.nodeAccount.setNormWeight(att);
                    continue;
                }
                if (c2) {
                    att = (att + 1.0) / 2.0;
                    this.nodeAccount.setNormWeight(att);
                    continue;
                }
                this.nodeAccount.setNormWeight(0.0);
            }
        }
    }

    public void correctEdgeAttScale(boolean isDefaultScale) {
        boolean c1;
        double topAttValue = -1000000.0;
        double botAttValue = 1000000.0;
        for (int j = 0; j < MainFrame.EdgeList.size(); ++j) {
            this.edgeAccount = MainFrame.EdgeList.get(j);
            double value = this.edgeAccount.getMeanWeight();
            if (topAttValue < value) {
                topAttValue = value;
            }
            if (!(botAttValue > value)) continue;
            botAttValue = value;
        }
        if (isDefaultScale) {
            boolean c2;
            c1 = topAttValue != botAttValue;
            boolean bl = c2 = botAttValue >= 0.0 && topAttValue <= 1.0;
            if (c1 && c2) {
                botAttValue = 0.0;
                topAttValue = 1.0;
            }
            double dist = Math.abs(topAttValue - botAttValue);
            for (int i = 0; i < MainFrame.EdgeList.size(); ++i) {
                this.edgeAccount = MainFrame.EdgeList.get(i);
                double att = this.edgeAccount.getMeanWeight();
                if (c1) {
                    att = (att - botAttValue) / dist;
                    this.edgeAccount.setNormWeight(att);
                    continue;
                }
                if (c2) {
                    this.edgeAccount.setNormWeight(att);
                    continue;
                }
                this.edgeAccount.setNormWeight(0.0);
            }
        } else {
            boolean c2;
            c1 = topAttValue != botAttValue;
            boolean bl = c2 = botAttValue >= -1.0 && topAttValue <= 1.0;
            if (c1 && c2) {
                botAttValue = -1.0;
                topAttValue = 1.0;
            }
            double dist = Math.abs(topAttValue - botAttValue);
            for (int j = 0; j < MainFrame.EdgeList.size(); ++j) {
                this.edgeAccount = MainFrame.EdgeList.get(j);
                double att = this.edgeAccount.getMeanWeight();
                if (c1) {
                    att = (att - botAttValue) / (dist / 2.0) - 1.0;
                    att = (att + 1.0) / 2.0;
                    this.edgeAccount.setNormWeight(att);
                    continue;
                }
                if (c2) {
                    att = (att + 1.0) / 2.0;
                    this.edgeAccount.setNormWeight(att);
                    continue;
                }
                this.edgeAccount.setNormWeight(0.0);
            }
        }
    }

    public void fitToWindow() {
        int sz = MainFrame.NodeList.size();
        if (sz == 0) {
            return;
        }
        double focoX = MainFrame.drawpanel.getWidth() / 2;
        double focoY = MainFrame.drawpanel.getHeight() / 2;
        this.actionSetCenter(focoX, focoY);
        float maxx = 0.0f;
        float maxy = 0.0f;
        int n1 = 0;
        int n3 = 0;
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            float nx = this.nodeAccount.getX();
            float ny = this.nodeAccount.getY();
            if (nx > maxx) {
                maxx = nx;
                n1 = i;
            }
            if (!(ny > maxy)) continue;
            maxy = ny;
            n3 = i;
        }
        double w = (double)MainFrame.drawpanel.getWidth() * 0.9;
        double h = (double)MainFrame.drawpanel.getHeight() * 0.9;
        maxx = MainFrame.NodeList.get(n1).getX();
        double a = (w - (double)maxx) / Math.abs(focoX - (double)maxx);
        maxy = MainFrame.NodeList.get(n3).getY();
        double b = (h - (double)maxy) / Math.abs(focoY - (double)maxy);
        double fator = Math.min(a, b);
        this.actionFit(-1.0, focoX, focoY, fator);
    }

    private void actionSetCenter(double focoX, double focoY) {
        int size = MainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.setCenter(pontos, focoX, focoY);
        for (int i = 0; i < pontos.length; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = MainFrame.NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
    }

    private void actionFit(double flip, double focoX, double focoY, double fator) {
        double zoomInOut = MainFrame.getZoom() - flip * (MainFrame.getZoom() * fator);
        int size = MainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        if (flip != 0.0) {
            pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        } else {
            pontos = zm.resetZoom(pontos, zoomInOut, focoX, focoY);
            zoomInOut = 1.0;
        }
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = MainFrame.NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
        MainFrame.setZoom(zoomInOut);
        MainFrame.drawpanel.setZoom((float)zoomInOut);
        MainFrame.updateGraph();
    }

    public String duplicateNetwork(boolean isToCopyEdges, boolean isDefaultCopy) {
        int b;
        EdgeBank originalAccount;
        int a;
        int i;
        MainFrame.lockMouse = true;
        MainFrame.originalMarcados = new ArrayList();
        MainFrame.newMarcados = new ArrayList();
        MainFrame.originalMarcados.clear();
        MainFrame.newMarcados.clear();
        ArrayList<String> testaMarcados = new ArrayList<String>();
        testaMarcados.clear();
        int lowestTreeLevel = 10000000;
        int destaques = 0;
        NodeBank sintaxTest = null;
        for (int i2 = 0; i2 < MainFrame.NodeList.size(); ++i2) {
            this.nodeAccount = MainFrame.NodeList.get(i2);
            if (!this.nodeAccount.getDestaque()) continue;
            if (lowestTreeLevel > this.nodeAccount.getNodeLevel()) {
                lowestTreeLevel = this.nodeAccount.getNodeLevel();
                destaques = 1;
                sintaxTest = this.nodeAccount;
                continue;
            }
            if (this.nodeAccount.getNodeLevel() != lowestTreeLevel) continue;
            ++destaques;
        }
        if (destaques == 0) {
            this.selectAllNodes();
            lowestTreeLevel = 0;
        } else if (destaques == 1 && !sintaxTest.isContainer()) {
            MainFrame.lockMouse = false;
            return "null";
        }
        int refcon = -1;
        for (i = 0; i < MainFrame.NodeList.size(); ++i) {
            NodeBank oldAccount = MainFrame.NodeList.get(i);
            if (!oldAccount.getDestaque() || oldAccount.getNodeLevel() > lowestTreeLevel) continue;
            if (oldAccount.isContainer()) {
                refcon = oldAccount.duplicateContainer(oldAccount.getNestedAssignment(), isDefaultCopy);
                continue;
            }
            String cleanName = this.cleanNome(oldAccount.getNodeID());
            int teste = testaMarcados.indexOf(cleanName);
            if (teste >= 0) continue;
            testaMarcados.add(cleanName);
            int cc = (Integer)MainFrame.keyNodeHash.get(oldAccount.getNodeID());
            MainFrame.originalMarcados.add(cc);
            String copynode = this.getNomeProvisorio(oldAccount.getNodeID());
            MainFrame.NodeList.add(new NodeBank(copynode, MainFrame.NodeList.size()));
            MainFrame.keyNodeHash.put(copynode, new Integer(MainFrame.NodeList.size() - 1));
            MainFrame.keyNodeArray.add(copynode);
            MainFrame.newMarcados.add(MainFrame.NodeList.size() - 1);
            NodeBank nodeCopyAccount = MainFrame.NodeList.get(MainFrame.NodeList.size() - 1);
            this.transferNodeAttribs(oldAccount, nodeCopyAccount, oldAccount.getNestedAssignment());
        }
        if (MainFrame.newMarcados.size() == 1 && (a = MainFrame.newMarcados.get(0).intValue()) >= 0 && a <= MainFrame.NodeList.size()) {
            this.deSelectNodes();
            MainFrame.NodeList.get(a).setDestaque(true);
            this.globalActionDeleteNode();
            MainFrame.lockMouse = false;
            return "null";
        }
        for (i = 0; i < MainFrame.EdgeList.size(); ++i) {
            originalAccount = MainFrame.EdgeList.get(i);
            if (!isToCopyEdges && isDefaultCopy && !originalAccount.getEdgeAssociationType().equals("edgeTree")) continue;
            int a2 = originalAccount.getA();
            b = originalAccount.getB();
            int testa = MainFrame.originalMarcados.indexOf(a2);
            int testb = MainFrame.originalMarcados.indexOf(b);
            if (testa == -1 || testb == -1) continue;
            testa = MainFrame.newMarcados.get(testa);
            testb = MainFrame.newMarcados.get(testb);
            MainFrame.EdgeList.add(new EdgeBank(testa, testb, MainFrame.EdgeList.size()));
            EdgeBank copyAccount = MainFrame.EdgeList.get(MainFrame.EdgeList.size() - 1);
            this.transferEdgeAttribs(originalAccount, copyAccount);
        }
        this.updateBanks();
        if (!isToCopyEdges && !isDefaultCopy) {
            this.deSelectEdges();
            for (i = 0; i < MainFrame.EdgeList.size(); ++i) {
                int rb;
                int ra;
                originalAccount = MainFrame.EdgeList.get(i);
                if (originalAccount.getEdgeAssociationType().equals("edgeTree")) continue;
                int a3 = originalAccount.getA();
                b = originalAccount.getB();
                if (MainFrame.NodeList.get(a3).isCopy() || MainFrame.NodeList.get(b).isCopy() || (ra = MainFrame.NodeList.get(a3).getNestedAssignmentIndx()) >= 0 && MainFrame.NodeList.get(ra).isCopy() || (rb = MainFrame.NodeList.get(b).getNestedAssignmentIndx()) >= 0 && MainFrame.NodeList.get(rb).isCopy()) continue;
                int testa = MainFrame.newMarcados.indexOf(a3);
                int testb = MainFrame.newMarcados.indexOf(b);
                if (testa != -1 || testb != -1) continue;
                originalAccount.setDestaque(true);
            }
            this.deleteSelectedEdges();
        }
        if (MainFrame.newMarcados.size() > 1) {
            NodeBank newContainer;
            String res = this.aninhar(MainFrame.newMarcados, new Color(204, 204, 255), false, false, false, true);
            if (res.startsWith("N")) {
                refcon = (Integer)MainFrame.keyNodeHash.get(res);
                newContainer = MainFrame.NodeList.get(refcon);
                newContainer.setNodeContainerAnchored(true);
                newContainer.setAsCopy();
                float newX = newContainer.getX() + newContainer.getW() * (float)MainFrame.getZoom() * (float)newContainer.getRelativeSize();
                if (isDefaultCopy) {
                    newContainer.moveTree(newX, newContainer.getY());
                } else {
                    float oldX = newContainer.getX();
                    this.moveOriginalNetwork(newX - oldX);
                }
                this.deSelectNodes();
                this.deSelectEdges();
                MainFrame.lockMouse = false;
                return res;
            }
            if (refcon >= 0) {
                newContainer = MainFrame.NodeList.get(refcon);
                newContainer.setNodeContainerAnchored(true);
                newContainer.setAsCopy();
                float newX = newContainer.getX() + newContainer.getW() * (float)MainFrame.getZoom() * (float)newContainer.getRelativeSize();
                if (isDefaultCopy) {
                    newContainer.moveTree(newX, newContainer.getY());
                } else {
                    float oldX = newContainer.getX();
                    this.moveOriginalNetwork(oldX - newX);
                }
                this.deSelectNodes();
                this.deSelectEdges();
                MainFrame.lockMouse = false;
                return newContainer.getNodeID();
            }
            MainFrame.lockMouse = false;
            return "null";
        }
        MainFrame.lockMouse = false;
        return "null";
    }

    private void moveOriginalNetwork(float dx) {
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            if (this.nodeAccount.isCopy() || this.nodeAccount.isNodeNested()) continue;
            if (this.nodeAccount.isContainer()) {
                this.nodeAccount.moveTree(this.nodeAccount.getX() + dx, this.nodeAccount.getY());
                continue;
            }
            this.nodeAccount.setX(this.nodeAccount.getX() + dx);
        }
    }

    public void transferNodeAttribs(NodeBank originalAccount, NodeBank copyAccount, String nestAssigment) {
        if (!originalAccount.isContainer()) {
            copyAccount.setAliases(originalAccount.getAliases());
        }
        copyAccount.setFont(originalAccount.getFont());
        copyAccount.setFontColor(originalAccount.getNodeFontColor());
        copyAccount.setFontSize(originalAccount.getFontSize());
        copyAccount.setFontX(originalAccount.getFontX());
        copyAccount.setFontY(originalAccount.getFontY());
        if (originalAccount.isContainer()) {
            copyAccount.setContainer(true);
            copyAccount.setNodeContainerAnchored(originalAccount.isNodeContainerAnchored());
            copyAccount.setContainerHided(originalAccount.isContainerHided());
            copyAccount.setContainerTransparent(originalAccount.isContainerTransparent());
        }
        copyAccount.setNodeNested(nestAssigment);
        if (originalAccount.isGroup()) {
            copyAccount.setAsGroup(true);
            copyAccount.setGroupCompNumber(originalAccount.getGroupCompNumber());
            copyAccount.setGroupComponents(originalAccount.getGroupComponets());
            copyAccount.setAsGroup(originalAccount.isGroup());
        }
        copyAccount.setNodeBend(originalAccount.getNodeBend());
        copyAccount.setNodeColor(originalAccount.getTrueNodeColor());
        copyAccount.setNodeGradient(originalAccount.isNodeGradient());
        copyAccount.setNodeLineColor(originalAccount.getNodeLineColor());
        copyAccount.setNodeLineWidth(originalAccount.getNodeLineWidth());
        copyAccount.setNodeShape(originalAccount.getNodeShape());
        copyAccount.setNodeLineType(originalAccount.getNodeLineType());
        copyAccount.setNodeSize(originalAccount.getNodeSize());
        copyAccount.setWeight(originalAccount.getNodeWeight());
        copyAccount.setNode(originalAccount.getX(), originalAccount.getY());
        copyAccount.setAsCopy();
    }

    public String getNomeProvisorio(String node) {
        Pattern pt = Pattern.compile("(.*)\\.\\$N[\\d]+");
        Matcher mt = pt.matcher(node);
        node = mt.matches() ? mt.group(1) + ".$N001" : node + ".$N001";
        return node;
    }

    public void transferEdgeAttribs(EdgeBank originalAccount, EdgeBank copyAccount) {
        copyAccount.setArrowDirection(originalAccount.getArrowDirection());
        copyAccount.setColor(originalAccount.getEdgeColor());
        copyAccount.setEdgeWeight(originalAccount.getMeanWeight());
        copyAccount.setLine(originalAccount.getType());
        copyAccount.setLine(originalAccount.getWidth());
        copyAccount.setNormWeight(originalAccount.getNormWeight());
        copyAccount.setOutEdge(originalAccount.isOutEdge());
        copyAccount.setDefaultContainerEdge(originalAccount.isDefaultEdgeAssignmet());
    }

    private String cleanNome(String node) {
        Pattern pt = Pattern.compile("(.*)\\.\\$N[\\d]+");
        Matcher mt = pt.matcher(node);
        if (mt.matches()) {
            node = mt.group(1);
        }
        return node;
    }

    public void setBackground(Color newColor) {
        if (newColor != null) {
            MainFrame.backgroundColor = newColor;
            MainFrame.drawpanel.setBackground(newColor);
        }
    }

    public void exitred() {
        exitred taskexit = new exitred();
        taskexit.execute();
    }

    public int addLegendSize(Vector<Float> sizevec, Vector<String> labvec, Color col, float interspace, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype, float edgelen) {
        int nnodes = sizevec.size();
        this.clearLegend(legtype);
        float totalszH = 0.0f;
        float totalszW = 0.0f;
        float a = 0.0f;
        float b = 0.0f;
        for (int i = 0; i < nnodes; ++i) {
            if (a < sizevec.get(i).floatValue()) {
                a = sizevec.get(i).floatValue();
            }
            b = b + sizevec.get(i).floatValue() + interspace;
        }
        totalszH = a;
        totalszW = b;
        if (isVertical) {
            totalszH = b;
            totalszW = a;
        }
        float largerH = Math.min(a, b);
        float largerW = Math.min(a, b);
        for (int i = 0; i < nnodes; ++i) {
            int legID = MainFrame.LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            MainFrame.LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = MainFrame.LegendList.get(legID);
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeColor(col);
            legendAccount.setNodeLineColor(col);
            legendAccount.setLegType(legtype);
            if (legtype.equals("edgewidth")) {
                if (isVertical) {
                    legendAccount.setNode(0.0f, 0.0f, sizevec.get(i).floatValue(), edgelen);
                    totalszW = edgelen;
                    largerW = edgelen;
                } else {
                    legendAccount.setNode(0.0f, 0.0f, edgelen, sizevec.get(i).floatValue());
                    totalszH = edgelen;
                    largerH = edgelen;
                }
            } else {
                legendAccount.setNode(0.0f, 0.0f, sizevec.get(i).floatValue(), sizevec.get(i).floatValue());
            }
            legendAccount.totalMembers(nnodes);
            legendAccount.setDim(totalszH, totalszW, largerH, largerW);
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setInterSpace(interspace);
            legendAccount.setNodeLineWidth(0.5f);
            legendAccount.setFontDist(12.0f, 2.0f);
        }
        this.realocateLegendOnLoad();
        return 1;
    }

    public int addLegendColor(Vector<Color> colvec, Vector<String> labvec, float size, float bend, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype) {
        int nnodes = colvec.size();
        if (isVertical) {
            bend = 100.0f - bend;
        }
        this.clearLegend(legtype);
        float totalszH = 0.0f;
        float totalszW = 0.0f;
        float largerH = size * (0.5f + bend / 100.0f);
        float largerW = size * (1.0f + (0.5f - bend / 100.0f));
        if (isVertical) {
            totalszH = largerH * (float)nnodes;
            totalszW = largerW;
        } else {
            totalszH = largerH;
            totalszW = largerW * (float)nnodes;
        }
        for (int i = 0; i < nnodes; ++i) {
            int legID = MainFrame.LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            MainFrame.LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = MainFrame.LegendList.get(legID);
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeSize(size / 20.0f);
            legendAccount.setNodeColor(colvec.get(i));
            legendAccount.setNodeLineColor(colvec.get(i));
            legendAccount.setLegType(legtype);
            legendAccount.totalMembers(nnodes);
            legendAccount.setDim(totalszH, totalszW, largerH, largerW);
            legendAccount.setMembership(i);
            legendAccount.setLegShape("RECTANGLE");
            legendAccount.setNodeBend(bend);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setNodeLineWidth(0.5f);
            legendAccount.setFontDist(14.0f, 6.0f);
        }
        this.realocateLegendOnLoad();
        return 1;
    }

    public int addLegendShape(Vector<String> shapevec, Vector<String> labvec, Color col, float size, float interspace, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype) {
        int nnodes = shapevec.size();
        this.clearLegend(legtype);
        float totalszH = 0.0f;
        float totalszW = 0.0f;
        float a = 0.0f;
        float b = 0.0f;
        a = size;
        for (int i = 0; i < nnodes; ++i) {
            b = b + size + interspace;
        }
        totalszH = a;
        totalszW = b;
        if (isVertical) {
            totalszH = b;
            totalszW = a;
        }
        float largerH = Math.min(a, b);
        float largerW = Math.min(a, b);
        for (int i = 0; i < nnodes; ++i) {
            int legID = MainFrame.LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            MainFrame.LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = MainFrame.LegendList.get(legID);
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeColor(col);
            legendAccount.setNodeLineColor(col);
            legendAccount.setLegType(legtype);
            if (legtype.equals("edgeshape")) {
                float len = 50.0f;
                if (isVertical) {
                    legendAccount.setNode(0.0f, 0.0f, size, len);
                    totalszW = len;
                    largerW = len;
                } else {
                    legendAccount.setNode(0.0f, 0.0f, len, size);
                    totalszH = len;
                    largerH = len;
                }
            } else {
                legendAccount.setNode(0.0f, 0.0f, size, size);
            }
            legendAccount.setLegShape(shapevec.get(i));
            legendAccount.totalMembers(nnodes);
            legendAccount.setDim(totalszH, totalszW, largerH, largerW);
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setInterSpace(interspace);
            legendAccount.setNodeLineWidth(0.5f);
            float fx = 14.0f;
            if (legtype.equals("nodeshape")) {
                fx = 20.0f;
            }
            legendAccount.setFontDist(fx, 6.0f);
        }
        this.realocateLegendOnLoad();
        return 1;
    }

    public void realocateLegendOnLoad() {
        for (int i = 0; i < MainFrame.LegendList.size(); ++i) {
            LegendBank legendAccount = MainFrame.LegendList.get(i);
            legendAccount.realocateMembers();
            float ftsz = legendAccount.getFont().getSize();
            Font ft = new Font(legendAccount.getFont().getFontName(), legendAccount.getFont().getStyle(), (int)ftsz);
            ft = new Font(ft.getFontName(), 1, ft.getSize() + 2);
            FontMetrics fm = MainFrame.drawpanel.getFontMetrics(ft);
            Rectangle2D st = fm.getStringBounds(legendAccount.getLabx(), MainFrame.drawpanel.getGraphics());
            legendAccount.updateDistBorder((float)st.getWidth());
            legendAccount.realocateMembers();
        }
    }

    public void clearLegend(String type) {
        LegendBank legAccount;
        int i;
        for (i = 0; i < MainFrame.LegendList.size(); ++i) {
            legAccount = MainFrame.LegendList.get(i);
            String tp = legAccount.getLegType();
            if (!tp.equals(type)) continue;
            MainFrame.LegendList.remove(i);
            --i;
        }
        for (i = 0; i < MainFrame.LegendList.size(); ++i) {
            legAccount = MainFrame.LegendList.get(i);
            legAccount.resetId(i);
        }
    }

    public int zoomNodeFilter(String nodeA, String nt) {
        for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            if (nt != null) {
                if (!this.nodeAccount.isNodeNested()) continue;
                int nrt = MainFrame.keyNodeArray.indexOf(this.nodeAccount.getNestedAssignment());
                String roodId = MainFrame.NodeList.get(nrt).getNodeID();
                String roodAlias = MainFrame.NodeList.get(nrt).getAliases();
                if (!roodId.equals(nt) || !roodAlias.equals(nt)) continue;
            }
            boolean matchID = nodeA.equals(this.nodeAccount.getNodeID());
            boolean matchAlias = nodeA.equals(this.nodeAccount.getAliases());
            if (!matchID && !matchAlias) continue;
            this.stopDynamics();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.taskFilterlZoom(i);
            break;
        }
        return 0;
    }

    public void taskFilterlZoom(int nodefound) {
        if (this.taskFilterZoom != null && !this.taskFilterZoom.isCancelled()) {
            this.taskFilterZoom.cancel(true);
        }
        this.nodeAccountFound = MainFrame.NodeList.get(nodefound);
        if (this.nodeAccountFound.isContainer() && this.nodeAccountFound.getRelativeSize() != 1.0) {
            this.zoomContainer(0.0, 0.0, this.nodeAccountFound);
        }
        this.taskFilterZoom = new tarefaFilterZoom();
        this.taskFilterZoom.execute();
        while (!this.taskFilterZoom.isDone()) {
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setFilterZoom(double flip, double focoX, double focoY, double vlox) {
        if (flip == 0.0) {
            return;
        }
        double fator = vlox;
        double zoomInOut = MainFrame.getZoom() - flip * (MainFrame.getZoom() * fator);
        MainFrame.setZoom(zoomInOut);
        int size = MainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = MainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = MainFrame.NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
        MainFrame.drawpanel.setZoom((float)zoomInOut);
    }

    private void zoomContainer(double flip, double fator, NodeBank containerAccount) {
        if (containerAccount == null) {
            return;
        }
        if (!containerAccount.isContainer()) {
            return;
        }
        double focoX = containerAccount.getX();
        double focoY = containerAccount.getY();
        double rsz = containerAccount.getRelativeSize();
        if (rsz < 0.25 && flip == 1.0) {
            return;
        }
        rsz -= flip * (rsz * fator);
        ArrayList<Integer> cc = containerAccount.getTreeComponents();
        Point2D[] pontos = new Point2D[cc.size()];
        for (int i = 0; i < cc.size(); ++i) {
            this.nodeAccount = MainFrame.NodeList.get(cc.get(i));
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        if (flip != 0.0) {
            pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        } else {
            pontos = zm.resetZoom(pontos, rsz, focoX, focoY);
            rsz = 1.0;
        }
        for (int i = 0; i < cc.size(); ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = MainFrame.NodeList.get(cc.get(i));
            this.nodeAccount.setNode(x, y);
        }
        containerAccount.setRelativeSize(rsz);
    }

    class tarefaFilterZoom
    extends SwingWorker<Void, Void> {
        tarefaFilterZoom() {
        }

        @Override
        public Void doInBackground() throws InterruptedException {
            double nodsz = (double)Methods.this.nodeAccountFound.getW() * MainFrame.getZoom() * Methods.this.nodeAccountFound.getRelativeSize();
            float targetpx = (float)MainFrame.drawpanel.getWidth() / 2.0f;
            float targetpy = (float)MainFrame.drawpanel.getHeight() / 2.0f;
            float targetsz = (targetpx + targetpy) / 30.0f;
            if (Methods.this.nodeAccountFound.isContainer()) {
                targetsz *= 7.0f;
            }
            float dx = targetpx - Methods.this.nodeAccountFound.getX();
            float dy = targetpy - Methods.this.nodeAccountFound.getY();
            double dz = (double)targetsz - nodsz;
            float speeds = (float)((double)(Math.abs(dx) + Math.abs(dy)) + Math.abs(dz));
            float evolx = Math.abs(dx) / speeds * speeds * 0.1f;
            float evoly = Math.abs(dy) / speeds * speeds * 0.1f;
            double evolz = Math.abs(dz) / (double)speeds * (double)speeds * 0.1;
            float flip = 1.0f;
            boolean andaz = false;
            boolean andax = false;
            boolean anday = false;
            boolean anda = !andax || !anday || !andaz;
            double ksteps = 0.0;
            while (anda && ksteps < 500.0) {
                ksteps += 1.0;
                if (!andaz) {
                    flip = dz <= 0.0 ? 1.0f : (dz > 0.0 ? -1.0f : 0.0f);
                    evolz = Math.min(0.05, evolz);
                    Methods.this.setFilterZoom(flip, Methods.this.nodeAccountFound.getX(), Methods.this.nodeAccountFound.getY(), evolz);
                }
                if (Math.abs(dz = (double)targetsz - (nodsz = (double)Methods.this.nodeAccountFound.getW() * MainFrame.getZoom() * Methods.this.nodeAccountFound.getRelativeSize())) <= (double)(targetsz / 20.0f)) {
                    andaz = true;
                }
                for (int i = 0; i < MainFrame.NodeList.size(); ++i) {
                    Methods.this.nodeAccount = MainFrame.NodeList.get(i);
                    if (!andax) {
                        flip = dx < 0.0f ? -1.0f : (dx > 0.0f ? 1.0f : 0.0f);
                        Methods.this.nodeAccount.setX(Methods.this.nodeAccount.getX() + evolx * flip);
                    }
                    if (anday) continue;
                    flip = dy < 0.0f ? -1.0f : (dy > 0.0f ? 1.0f : 0.0f);
                    Methods.this.nodeAccount.setY(Methods.this.nodeAccount.getY() + evoly * flip);
                }
                dx = targetpx - Methods.this.nodeAccountFound.getX();
                if (Math.abs(dx) <= 20.0f) {
                    andax = true;
                }
                if (Math.abs(dy = targetpy - Methods.this.nodeAccountFound.getY()) <= 20.0f) {
                    anday = true;
                }
                MainFrame.drawpanel.repaint();
                Thread.sleep(30L);
                speeds = (float)((double)(Math.abs(dx) + Math.abs(dy)) + Math.abs(dz));
                evolx = Math.abs(dx) / speeds * speeds * 0.1f;
                evoly = Math.abs(dy) / speeds * speeds * 0.1f;
                evolz = Math.abs(dz) / (double)speeds;
                boolean bl = anda = !andax || !anday || !andaz;
                if (Methods.this.nodeAccountFound != null) continue;
                anda = false;
            }
            return null;
        }

        @Override
        public void done() {
            if (Methods.this.nodeAccountFound != null) {
                Methods.this.nodeAccountFound.setDestaque(true);
                Methods.this.globalChangeOrder("forward");
                if (Methods.this.nodeAccountFound.isContainer()) {
                    MainFrame.drawpanel.repaint();
                } else {
                    Methods.this.taskHighlight();
                }
            }
            if (Methods.this.taskFilterZoom != null && !Methods.this.taskFilterZoom.isCancelled()) {
                Methods.this.taskFilterZoom.cancel(true);
            }
        }
    }

    class exitred
    extends SwingWorker<Void, Void> {
        exitred() {
        }

        @Override
        public Void doInBackground() throws InterruptedException {
            Thread.sleep(30L);
            return null;
        }

        @Override
        public void done() {
            System.exit(0);
        }
    }

    class tarefaHighlight
    extends SwingWorker<Void, Void> {
        tarefaHighlight() {
        }

        @Override
        public Void doInBackground() throws IOException {
            double sz;
            int i;
            ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
            listaMarcados.clear();
            double zn = MainFrame.getZoom();
            for (i = 0; i < MainFrame.NodeList.size(); ++i) {
                Methods.this.nodeAccount = MainFrame.NodeList.get(i);
                if (!Methods.this.nodeAccount.getDestaque()) continue;
                listaMarcados.add(i);
            }
            for (i = 0; i < 10; ++i) {
                for (int j = 0; j < listaMarcados.size(); ++j) {
                    Methods.this.nodeAccount = MainFrame.NodeList.get((Integer)listaMarcados.get(j));
                    sz = (double)Methods.this.nodeAccount.getNodeSize() * zn;
                    Methods.this.nodeAccount.setHighlightSize(Methods.this.nodeAccount.getHighlightSize() + (double)i / 100.0 / sz);
                }
                MainFrame.drawpanel.repaint();
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException j) {
                    // empty catch block
                }
            }
            for (i = 0; i < 10; ++i) {
                for (int j = 0; j < listaMarcados.size(); ++j) {
                    Methods.this.nodeAccount = MainFrame.NodeList.get((Integer)listaMarcados.get(j));
                    sz = (double)Methods.this.nodeAccount.getNodeSize() * zn;
                    Methods.this.nodeAccount.setHighlightSize(Methods.this.nodeAccount.getHighlightSize() - (double)i / 100.0 / sz);
                    if (i != 9) continue;
                    Methods.this.nodeAccount.setHighlightSize(1.0);
                }
                MainFrame.drawpanel.repaint();
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

