/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.AbstractAlignmentMerger;
import net.sf.picard.sam.CigarClippingIterator;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SortingCollection;

public class SamAlignmentMerger
extends AbstractAlignmentMerger {
    private final Log log = Log.getInstance(SamAlignmentMerger.class);
    private final File alignedSamFile;
    private final boolean pairedRun;
    private final int maxGaps;
    private SAMFileReader reader;
    private boolean forceSort = false;

    public SamAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, SAMProgramRecord programRecord, boolean clipAdapters, boolean bisulfiteSequence, boolean pairedRun, boolean jumpingLibrary, boolean alignedReadsOnly, File alignedSamFile, int maxGaps, List<String> attributesToRetain) {
        super(unmappedBamFile, targetBamFile, referenceFasta, clipAdapters, bisulfiteSequence, jumpingLibrary, alignedReadsOnly, programRecord, attributesToRetain);
        IoUtil.assertFileIsReadable(alignedSamFile);
        this.alignedSamFile = alignedSamFile;
        this.pairedRun = pairedRun;
        this.maxGaps = maxGaps;
        this.reader = new SAMFileReader(this.alignedSamFile);
        this.reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        if (programRecord == null && this.reader.getFileHeader().getProgramRecords().size() == 1) {
            this.setProgramRecord(this.reader.getFileHeader().getProgramRecords().get(0));
        }
        this.log.info("Processing SAM file: " + alignedSamFile.getAbsolutePath());
    }

    public SamAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, SAMProgramRecord programRecord, boolean clipAdapters, boolean bisulfiteSequence, boolean pairedRun, boolean jumpingLibrary, boolean alignedReadsOnly, File alignedSamFile, int maxGaps) {
        this(unmappedBamFile, targetBamFile, referenceFasta, programRecord, clipAdapters, bisulfiteSequence, pairedRun, jumpingLibrary, alignedReadsOnly, alignedSamFile, maxGaps, null);
    }

    @Override
    public void mergeAlignment() {
        try {
            super.mergeAlignment();
        }
        catch (Exception e) {
            this.forceSort = true;
            this.setRefSeqFileWalker();
            super.mergeAlignment();
        }
    }

    @Override
    protected CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords() {
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.queryname);
        header.setSequenceDictionary(this.getSequenceDictionary());
        if (this.getProgramRecord() != null) {
            header.addProgramRecord(this.getProgramRecord());
        }
        if (!this.forceSort) {
            return new SortedAlignmentIterator(this.reader.iterator());
        }
        this.reader = new SAMFileReader(this.alignedSamFile);
        SortingCollection<SAMRecord> alignmentSorter = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(header), new SAMRecordQueryNameComparator(), 500000);
        HashMap<String, SAMRecord> readNameToReadPending = new HashMap<String, SAMRecord>();
        int count = 0;
        CigarClippingIterator it = new CigarClippingIterator(this.reader.iterator());
        while (it.hasNext()) {
            SAMRecord sam = (SAMRecord)it.next();
            sam.setReadName(this.cleanReadName(sam.getReadName()));
            if (this.pairedRun) {
                SAMRecord mate = (SAMRecord)readNameToReadPending.remove(sam.getReadName());
                if (mate != null) {
                    if (!sam.getReadUnmappedFlag() || !mate.getReadUnmappedFlag()) {
                        this.fixMates(sam, mate);
                        alignmentSorter.add(sam);
                        alignmentSorter.add(mate);
                        count += 2;
                    }
                } else {
                    readNameToReadPending.put(sam.getReadName(), sam);
                }
            } else if (!sam.getReadUnmappedFlag()) {
                alignmentSorter.add(sam);
                ++count;
            }
            if (count <= 0 || count % 1000000 != 0) continue;
            this.log.info("Read " + count + " records from alignment SAM/BAM.");
        }
        this.log.info("Finished reading " + count + " total records from alignment SAM/BAM.");
        if (readNameToReadPending.size() > 0) {
            throw new PicardException("Unmatched reads left in pending map.");
        }
        this.reader.close();
        return alignmentSorter.iterator();
    }

    private void fixMates(SAMRecord first, SAMRecord second) {
        if (!first.getReadUnmappedFlag() || !second.getReadUnmappedFlag()) {
            boolean proper = SamPairUtil.isProperPair(first, second, this.isJumpingLibrary());
            first.setProperPairFlag(proper);
            second.setProperPairFlag(proper);
            SamPairUtil.setMateInfo(first, second, this.getHeader());
        }
    }

    @Override
    protected boolean ignoreAlignment(SAMRecord sam) {
        int gaps = 0;
        for (CigarElement el : sam.getCigar().getCigarElements()) {
            if (el.getOperator() != CigarOperator.I && el.getOperator() != CigarOperator.D && el.getOperator() != CigarOperator.N) continue;
            ++gaps;
        }
        return gaps > this.maxGaps;
    }

    public boolean getForceSort() {
        return this.forceSort;
    }

    private class SortedAlignmentIterator
    implements CloseableIterator<SAMRecord> {
        CloseableIterator<SAMRecord> wrappedIterator;
        private SAMRecord next = null;

        public SortedAlignmentIterator(SAMRecordIterator it) {
            this.wrappedIterator = new CigarClippingIterator(it);
            it.assertSorted(SAMFileHeader.SortOrder.queryname);
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext() || this.next != null;
        }

        @Override
        public SAMRecord next() {
            if (!SamAlignmentMerger.this.pairedRun) {
                return (SAMRecord)this.wrappedIterator.next();
            }
            if (this.next == null) {
                SAMRecord firstOfPair = (SAMRecord)this.wrappedIterator.next();
                this.next = (SAMRecord)this.wrappedIterator.next();
                SamAlignmentMerger.this.fixMates(firstOfPair, this.next);
                firstOfPair.setReadName(SamAlignmentMerger.this.cleanReadName(firstOfPair.getReadName()));
                return firstOfPair;
            }
            SAMRecord secondOfPair = this.next;
            secondOfPair.setReadName(SamAlignmentMerger.this.cleanReadName(secondOfPair.getReadName()));
            this.next = null;
            return secondOfPair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }
}

