## ---- eval=TRUE------------------------------------------------------------
library(RTN)
data(stni, package="RTN")

## ---- eval=TRUE------------------------------------------------------------
summary <- tni.get(stni, what = "summary")

## ---- eval=TRUE------------------------------------------------------------
library(RTNsurvival)
data(survival.data)

## ---- eval=TRUE------------------------------------------------------------
rtns <- tnsPreprocess(stni, survival.data, keycovar = c("Grade","Age"), time = 1, event = 2)

## ---- eval=TRUE------------------------------------------------------------
rtns <- tnsGSEA2(rtns, verbose = FALSE)

## ---- eval=TRUE------------------------------------------------------------
tnsCox(rtns, sortregs = TRUE)

## ---- eval=TRUE------------------------------------------------------------
tnsKM(rtns, regs="FOXM1", attribs = list(c("ER+","ER-"),c("PR+","PR-"),c("G1","G2","G3"),"HT"), 
endpoint=180)

## ---- eval=TRUE------------------------------------------------------------
tnsPlotGSEA2(rtns, "MB-5115", regs = "FOXM1", verbose = FALSE)

## ---- eval = FALSE---------------------------------------------------------
#  library(pheatmap)
#  enrichmentScores <- tnsGet(rtns, "EScores")
#  survival.data <- tnsGet(rtns, "survivalData")
#  annotationBars <- survival.data[,c("ER+", "ER-")]
#  pheatmap(t(enrichmentScores$dif),
#          annotation_col = annotationBars,
#          main = "Differential Enrichment Scores (dES) for tumour samples",
#          show_colnames = FALSE,
#          annotation_legend = FALSE)

## --------------------------------------------------------------------------
library(RTNduals)
smbr <- tni2mbrPreprocess(stni, stni, verbose = FALSE)
smbr <- mbrAssociation(smbr, prob = 0.75, verbose = FALSE)
smbr <- mbrDuals(smbr, verbose = FALSE)
mbrGet(smbr, "dualsInformation")

## ---- eval = FALSE---------------------------------------------------------
#  duals <- mbrGet(smbr, what="dualRegulons")
#  dualSurvivalPanel(smbr, rtns, dual = duals[1], attribs = c("ER+", "ER-", "PR+", "PR-"))

## ----label='Session information', eval=TRUE, echo=FALSE--------------------
sessionInfo()

