/*
 * Decompiled with CFR 0.152.
 */
package sample.session.client;

import david.xsd.AnnotationRecord;
import david.xsd.ArrayOfString;
import david.xsd.ListRecord;
import david.xsd.MainSummaryRecord;
import david.xsd.SummaryRecord;
import david.xsd.TableRecord;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.TreeSet;
import org.apache.axis2.AxisFault;
import sample.session.client.stub.DAVIDWebServiceStub;
import sample.session.service.xsd.SimpleChartRecord;
import sample.session.service.xsd.SimpleGeneClusterRecord;
import sample.session.service.xsd.SimpleTermClusterRecord;

public class DAVIDParser {
    public static final String SEP = "\t";
    public static final String EOL = "\n";

    private static void testParse() {
        try {
            DAVIDWebServiceStub stub = new DAVIDWebServiceStub("http://david.abcc.ncifcrf.gov/webservice/services/DAVIDWebService.DAVIDWebServiceHttpSoap12Endpoint/");
            stub._getServiceClient().getOptions().setManageSession(true);
            System.out.println();
            String userAuthentication = stub.authenticate("cristobalfresno@ucc.edu.ar");
            System.out.println("User authentication: " + userAuthentication);
            System.out.println();
            if (userAuthentication.equals("true")) {
                String conversionTypes = stub.getConversionTypes();
                System.out.println("Conversion Types:\n" + conversionTypes + EOL);
                String annotationCategoryNames = stub.getAllAnnotationCategoryNames();
                System.out.println("Annotation Category Names:\n" + annotationCategoryNames + EOL);
                String inputIds = new String("1112_g_at,1331_s_at,1355_g_at,1372_at,1391_s_at,1403_s_at,1419_g_at,1575_at,1645_at,1786_at,1855_at,1890_at,1901_s_at,1910_s_at,1937_at,1974_s_at,1983_at,2090_i_at,31506_s_at,31512_at,31525_s_at,31576_at,31621_s_at,31687_f_at,31715_at,31793_at,31987_at,32010_at,32073_at,32084_at,32148_at,32163_f_at,32250_at,32279_at,32407_f_at,32413_at,32418_at,32439_at,32469_at,32680_at,32717_at,33027_at,33077_at,33080_s_at,33246_at,33284_at,33293_at,33371_s_at,33516_at,33530_at,33684_at,33685_at,33922_at,33963_at,33979_at,34012_at,34233_i_at,34249_at,34436_at,34453_at,34467_g_at,34529_at,34539_at,34546_at,34577_at,34606_s_at,34618_at,34623_at,34629_at,34636_at,34702_f_at,34703_f_at,34720_at,34902_at,34972_s_at,35038_at,35069_at,35090_g_at,35091_at,35121_at,35169_at,35213_at,35367_at,35373_at,35439_at,35566_f_at,35595_at,35648_at,35896_at,35903_at,35915_at,35956_s_at,35996_at,36234_at,36317_at,36328_at,36378_at,36421_at,36436_at,36479_at,36696_at,36703_at,36713_at,36766_at,37061_at,37096_at,37097_at,37105_at,37166_at,37172_at,37408_at,37454_at,37711_at,37814_g_at,37898_r_at,37905_r_at,37953_s_at,37954_at,37968_at,37983_at,38103_at,38128_at,38201_at,38229_at,38236_at,38482_at,38508_s_at,38604_at,38646_s_at,38674_at,38691_s_at,38816_at,38926_at,38945_at,38948_at,39094_at,39187_at,39198_s_at,39469_s_at,39511_at,39698_at,39908_at,40058_s_at,40089_at,40186_at,40271_at,40294_at,40317_at,40350_at,40553_at,40735_at,40790_at,40959_at,41113_at,41280_r_at,41489_at,41703_r_at,606_at,679_at,822_s_at,919_at,936_s_at,966_at,967_g_at");
                String idType = new String("AFFYMETRIX_3PRIME_IVT_ID");
                String listName = new String("make_up");
                int listType = 0;
                String category_names = new String("KEGG_PATHWAY,GOTERM_BP_ALL,GOTERM_CC_ALL,GOTERM_MF_ALL");
                String validCategoryString = stub.setCategories(category_names);
                System.out.println("Valid Categories" + validCategoryString + EOL);
                try {
                    double addListOutput = stub.addList(inputIds, idType, listName, listType);
                    System.out.println("AddListOutput " + addListOutput + EOL);
                    double thrd = 0.1;
                    int ct = 2;
                    System.out.println("Trying to get Chart Report...");
                    SimpleChartRecord[] simpleChartRecords = stub.getChartReport(thrd, ct);
                    System.out.println("Processing...");
                    DAVIDParser.writeChartReport(new String("chartReport.txt"), simpleChartRecords);
                    System.out.println("chartReport.txt generated.");
                    System.out.println("Trying to get Table Report...");
                    TableRecord[] tableRecords = stub.getTableReport();
                    System.out.println("Processing...");
                    DAVIDParser.writeTableReport("tableReport.txt", tableRecords);
                    System.out.println("tableReport.txt generated.");
                    System.out.println("Trying to get Gene Cluster Report...");
                    int overlap = 3;
                    int initialSeed = 2;
                    int finalSeed = 2;
                    double linkage = 0.5;
                    int kappa = 35;
                    System.out.println("\tSet overlap=" + overlap + " initialSeed=" + initialSeed + " finalSeed=" + finalSeed + " linkage=" + linkage + " kappa=" + kappa);
                    System.out.println();
                    SimpleGeneClusterRecord[] simpleGeneClusterRecords = stub.getGeneClusterReport(overlap, initialSeed, finalSeed, linkage, kappa);
                    System.out.println("Processing...");
                    DAVIDParser.writeGeneClusterReport("geneClusterReport.txt", simpleGeneClusterRecords);
                    System.out.println("geneClusterReport.txt generated.");
                    System.out.println("Trying to get Term Cluster Report.....");
                    System.out.println("\tSet overlap=" + overlap + " initialSeed=" + initialSeed + " finalSeed=" + finalSeed + " linkage=" + linkage + " kappa=" + kappa);
                    SimpleTermClusterRecord[] simpleTermClusterRecords = stub.getTermClusterReport(overlap, initialSeed, finalSeed, linkage, kappa);
                    System.out.println("Processing...");
                    DAVIDParser.writeTermClusterReport("termClusterReport.txt", simpleTermClusterRecords);
                    System.out.println("termClusterReport.txt generated.");
                    System.out.println("Trying to get List Report.....");
                    ListRecord[] listRecords = stub.getListReport();
                    System.out.println("Processing...");
                    DAVIDParser.writeListReport("listReport.txt", listRecords, idType);
                    System.out.println("listReport.txt generated.");
                    System.out.println("Trying to get Summary Report.....");
                    MainSummaryRecord[] mainSummaryRecords = stub.getSummaryReport();
                    System.out.println("Processing...");
                    DAVIDParser.writeSummaryReport("summaryReport.txt", mainSummaryRecords);
                    System.out.println("summaryReport.txt generated.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    System.out.println("Unknown exception:" + e.toString());
                }
            }
        }
        catch (AxisFault axisFault) {
            axisFault.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static void dumpToFile(String fileName, StringBuffer sb) {
        PrintWriter outfile = null;
        try {
            try {
                outfile = new PrintWriter(new FileOutputStream(fileName));
                outfile.print(sb);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException("Write error on " + fileName + " file", ex);
            }
        }
        finally {
            try {
                if (outfile != null) {
                    outfile.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException("Closing error on " + fileName + " file", ex);
            }
        }
    }

    public static void writeChartReport(String fileName, SimpleChartRecord[] simpleChartRecords) {
        StringBuffer sb = new StringBuffer();
        sb.append("Category").append(SEP).append("Term").append(SEP);
        sb.append("Count").append(SEP).append("%").append(SEP).append("PValue").append(SEP);
        sb.append("Genes").append(SEP).append("List Total").append(SEP).append("Pop Hits").append(SEP);
        sb.append("Pop Total").append(SEP).append("Fold Enrichment").append(SEP);
        sb.append("Bonferroni").append(SEP).append("Benjamini").append(SEP).append("FDR").append(EOL);
        if (simpleChartRecords != null) {
            int j = 0;
            while (j < simpleChartRecords.length) {
                sb.append(simpleChartRecords[j].getCategoryName()).append(SEP);
                sb.append(simpleChartRecords[j].getTermName()).append(SEP);
                sb.append(simpleChartRecords[j].getListHits()).append(SEP);
                sb.append(simpleChartRecords[j].getPercent()).append(SEP);
                sb.append(simpleChartRecords[j].getEase()).append(SEP);
                sb.append(simpleChartRecords[j].getGeneIds()).append(SEP);
                sb.append(simpleChartRecords[j].getListTotals()).append(SEP);
                sb.append(simpleChartRecords[j].getPopHits()).append(SEP);
                sb.append(simpleChartRecords[j].getPopTotals()).append(SEP);
                sb.append(simpleChartRecords[j].getFoldEnrichment()).append(SEP);
                sb.append(simpleChartRecords[j].getBonferroni()).append(SEP);
                sb.append(simpleChartRecords[j].getBenjamini()).append(SEP);
                sb.append(simpleChartRecords[j].getAfdr()).append(EOL);
                ++j;
            }
        }
        DAVIDParser.dumpToFile(fileName, sb);
    }

    public static void writeTableReport(String fileName, TableRecord[] tableRecords) {
        StringBuffer sb = new StringBuffer();
        sb.append("ID").append(SEP).append("Gene Name").append(SEP).append("Species");
        String[] category_strings = new String[]{"BBID", "GOTERM_CC_FAT", "BIOCARTA", "GOTERM_MF_FAT", "SMART", "COG_ONTOLOGY", "SP_PIR_KEYWORDS", "KEGG_PATHWAY", "INTERPRO", "UP_SEQ_FEATURE", "OMIM_DISEASE", "GOTERM_BP_FAT", "PIR_SUPERFAMILY"};
        TreeSet<String> categorySet = new TreeSet<String>();
        if (tableRecords != null) {
            int id = 0;
            while (id < tableRecords.length) {
                AnnotationRecord[] records = tableRecords[id].getAnnotationRecords();
                int category = 0;
                while (category < records.length) {
                    categorySet.add(records[category].getCategory());
                    ++category;
                }
                ++id;
            }
            category_strings = categorySet.toArray(new String[0]);
        }
        int i = 0;
        while (i < category_strings.length) {
            sb.append(SEP).append(category_strings[i]);
            ++i;
        }
        sb.append(EOL);
        if (tableRecords != null) {
            int j = 0;
            while (j < tableRecords.length) {
                ArrayOfString[] values = tableRecords[j].getValues();
                int k = 0;
                while (k < values.length) {
                    String[] valuesString = values[k].getArray();
                    if (k == 0) {
                        sb.append(valuesString[0]);
                    } else {
                        sb.append(", " + valuesString[0]);
                    }
                    ++k;
                }
                sb.append(SEP).append(tableRecords[j].getName());
                sb.append(SEP).append(tableRecords[j].getSpecies());
                AnnotationRecord[] annotationRecords = tableRecords[j].getAnnotationRecords();
                Hashtable<String, String> annotation_hash = new Hashtable<String, String>();
                int k2 = 0;
                while (k2 < annotationRecords.length) {
                    String annotationRecordCategory = annotationRecords[k2].getCategory();
                    String terms_string = "";
                    String[] annotationRecordTerms = annotationRecords[k2].getTerms();
                    int i2 = 0;
                    while (i2 < annotationRecordTerms.length) {
                        String[] tokens = null;
                        tokens = annotationRecordTerms[i2].split("\\$");
                        String termString = tokens == null ? annotationRecordTerms[i2] : tokens[tokens.length - 1];
                        terms_string = String.valueOf(terms_string) + termString + ",";
                        ++i2;
                    }
                    annotation_hash.put(annotationRecordCategory, terms_string);
                    ++k2;
                }
                k2 = 0;
                while (k2 < category_strings.length) {
                    String terms_string = (String)annotation_hash.get(category_strings[k2]);
                    sb.append(SEP);
                    if (terms_string != null) {
                        sb.append(terms_string);
                    }
                    ++k2;
                }
                sb.append(EOL);
                ++j;
            }
        }
        DAVIDParser.dumpToFile(fileName, sb);
    }

    public static void writeGeneClusterReport(String fileName, SimpleGeneClusterRecord[] simpleGeneClusterRecords) {
        StringBuffer sb = new StringBuffer();
        if (simpleGeneClusterRecords != null) {
            int k = 0;
            while (k < simpleGeneClusterRecords.length) {
                sb.append(simpleGeneClusterRecords[k].getName()).append(SEP).append("Enrichment Score: ").append(simpleGeneClusterRecords[k].getScore());
                sb.append(EOL).append("ID").append(SEP).append("Gene Name").append(EOL);
                ListRecord[] recordList = simpleGeneClusterRecords[k].getListRecords();
                int j = 0;
                while (j < recordList.length) {
                    String[] values = recordList[j].getValues();
                    sb.append(values[0]).append(SEP);
                    sb.append(recordList[j].getName()).append(EOL);
                    ++j;
                }
                sb.append(EOL);
                ++k;
            }
        }
        DAVIDParser.dumpToFile(fileName, sb);
    }

    public static void writeTermClusterReport(String fileName, SimpleTermClusterRecord[] simpleTermClusterRecords) {
        StringBuffer sb = new StringBuffer();
        if (simpleTermClusterRecords != null) {
            int k = 0;
            while (k < simpleTermClusterRecords.length) {
                sb.append("Annotation Cluster ").append(k + 1).append(SEP).append("Enrichment Score: ").append(simpleTermClusterRecords[k].getScore());
                SimpleChartRecord[] simpleChartRecords = simpleTermClusterRecords[k].getSimpleChartRecords();
                sb.append(EOL).append("Category").append(SEP).append("Term").append(SEP).append("Count").append(SEP);
                sb.append("%").append(SEP).append("PValue").append(SEP).append("Genes").append(SEP).append("List Total");
                sb.append(SEP).append("Pop Hits").append(SEP).append("Pop Total").append(SEP).append("Fold Enrichment");
                sb.append(SEP).append("Bonferroni").append(SEP).append("Benjamini").append(SEP).append("FDR").append(EOL);
                int j = 0;
                while (j < simpleChartRecords.length) {
                    sb.append(simpleChartRecords[j].getCategoryName()).append(SEP);
                    sb.append(simpleChartRecords[j].getTermName()).append(SEP);
                    sb.append(simpleChartRecords[j].getListHits()).append(SEP);
                    sb.append(simpleChartRecords[j].getPercent()).append(SEP);
                    sb.append(simpleChartRecords[j].getEase()).append(SEP);
                    sb.append(simpleChartRecords[j].getGeneIds()).append(SEP);
                    sb.append(simpleChartRecords[j].getListTotals()).append(SEP);
                    sb.append(simpleChartRecords[j].getPopHits()).append(SEP);
                    sb.append(simpleChartRecords[j].getPopTotals()).append(SEP);
                    sb.append(simpleChartRecords[j].getFoldEnrichment()).append(SEP);
                    sb.append(simpleChartRecords[j].getBonferroni()).append(SEP);
                    sb.append(simpleChartRecords[j].getBenjamini()).append(SEP);
                    sb.append(simpleChartRecords[j].getAfdr()).append(EOL);
                    ++j;
                }
                sb.append(EOL);
                ++k;
            }
        }
        DAVIDParser.dumpToFile(fileName, sb);
    }

    public static void writeListReport(String fileName, ListRecord[] listRecords, String idType) {
        StringBuffer sb = new StringBuffer();
        sb.append(idType).append(SEP).append("Name").append(SEP).append("Species").append(EOL);
        if (listRecords != null) {
            int i = 0;
            while (i < listRecords.length) {
                sb.append(listRecords[i].getValues()[0]);
                int j = 1;
                while (j < listRecords[i].getValues().length) {
                    sb.append("," + listRecords[i].getValues()[j]);
                    ++j;
                }
                sb.append(SEP).append(listRecords[i].getName()).append(SEP).append(listRecords[i].getSpecies()).append(EOL);
                ++i;
            }
        }
        DAVIDParser.dumpToFile(fileName, sb);
    }

    public static void writeSummaryReport(String fileName, MainSummaryRecord[] mainSummaryRecords) {
        StringBuffer sb = new StringBuffer();
        sb.append("Main Category").append(SEP).append("ID").append(SEP).append("Name").append(SEP);
        sb.append("%").append(SEP).append("Count").append(EOL);
        if (mainSummaryRecords != null) {
            int i = 0;
            while (i < mainSummaryRecords.length) {
                SummaryRecord[] summaryRecords = mainSummaryRecords[i].getSummaryRecords();
                int j = 0;
                while (j < summaryRecords.length) {
                    sb.append(mainSummaryRecords[i].getMainCategory()).append(SEP);
                    sb.append(summaryRecords[j].getCategoryId()).append(SEP).append(summaryRecords[j].getCategory()).append(SEP);
                    sb.append(summaryRecords[j].getPercent()).append(SEP).append(summaryRecords[j].getCount()).append(EOL);
                    ++j;
                }
                ++i;
            }
        }
        DAVIDParser.dumpToFile(fileName, sb);
    }

    public static void main(String[] args) throws Exception {
        DAVIDParser.testParse();
    }
}

