/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;

public class IntensityHistogram
extends JPanel {
    private ChartPanel chartPanel;

    public IntensityHistogram(ArrayList<IonMatch> annotations, MSnSpectrum currentSpectrum, double intensityLevel) {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 2));
        ArrayList<Double> nonAnnotatedPeakIntensities = currentSpectrum.getPeaksAboveIntensityThreshold(currentSpectrum.getIntensityLimit(intensityLevel));
        ArrayList<Double> annotatedPeakIntensities = new ArrayList<Double>();
        for (IonMatch ionMatch : annotations) {
            annotatedPeakIntensities.add(ionMatch.peak.intensity);
            nonAnnotatedPeakIntensities.remove(ionMatch.peak.intensity);
        }
        int bins = 30;
        double[] nonAnnotatedIntensities = new double[nonAnnotatedPeakIntensities.size()];
        double[] annotatedIntensities = new double[annotatedPeakIntensities.size()];
        if (nonAnnotatedIntensities.length > 0) {
            int i;
            for (i = 0; i < nonAnnotatedPeakIntensities.size(); ++i) {
                nonAnnotatedIntensities[i] = nonAnnotatedPeakIntensities.get(i);
            }
            for (i = 0; i < annotatedPeakIntensities.size(); ++i) {
                annotatedIntensities[i] = (Double)annotatedPeakIntensities.get(i);
            }
            HistogramDataset dataset = new HistogramDataset();
            dataset.setType(HistogramType.RELATIVE_FREQUENCY);
            dataset.addSeries((Comparable)((Object)"Not Annotated"), nonAnnotatedIntensities, bins, 0.0, currentSpectrum.getMaxIntensity());
            dataset.addSeries((Comparable)((Object)"Annotated"), annotatedIntensities, bins, 0.0, currentSpectrum.getMaxIntensity());
            JFreeChart chart = ChartFactory.createHistogram(null, null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            this.chartPanel = new ChartPanel(chart);
            this.chartPanel.setBorder(null);
            chart.setBorderVisible(false);
            XYPlot plot = chart.getXYPlot();
            XYBarRenderer renderer = new XYBarRenderer();
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
            renderer.setShadowVisible(false);
            renderer.setSeriesPaint(0, (Paint)new Color(210, 210, 210, 150));
            renderer.setSeriesPaint(1, (Paint)new Color(110, 196, 97));
            plot.setRenderer((XYItemRenderer)renderer);
            plot.getRangeAxis().setRange(0.0, plot.getRangeAxis().getUpperBound());
            plot.setOutlineVisible(false);
            plot.setBackgroundPaint((Paint)Color.WHITE);
            this.chartPanel.setBackground(Color.WHITE);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            this.add((Component)this.chartPanel);
        }
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }
}

