/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db.components;

import com.compomics.util.db.DBMetaData;
import org.apache.log4j.Logger;

public class PersistableCode {
    Logger logger = Logger.getLogger(PersistableCode.class);
    private String iCode = null;

    public PersistableCode(DBMetaData aMeta) {
        int pkColType;
        int i;
        String table = aMeta.getTableName();
        String[] names = aMeta.getColumnNames();
        String[] types = aMeta.getConvertedColumnTypes();
        StringBuffer query = new StringBuffer("INSERT INTO " + table + " (");
        for (i = 0; i < names.length; ++i) {
            String name = names[i];
            if (i > 0) {
                query.append(", ");
            }
            query.append(name);
        }
        query.append(") values(");
        for (i = 0; i < names.length; ++i) {
            if (i > 0) {
                query.append(", ");
            }
            if (names[i].equalsIgnoreCase("username")) {
                query.append("CURRENT_USER");
                continue;
            }
            if (names[i].equalsIgnoreCase("creationdate") || names[i].equalsIgnoreCase("modificationdate")) {
                query.append("CURRENT_TIMESTAMP");
                continue;
            }
            query.append("?");
        }
        query.append(")");
        StringBuffer lsb = new StringBuffer("\t/**\n\t * This method allows the caller to insert the data represented by this\n\t * object in a persistent store.\n");
        lsb.append("\t *\n\t * @param   aConn Connection to the persitent store.\n\t */\n");
        lsb.append("\tpublic int persist(Connection aConn) throws SQLException {\n");
        lsb.append("\t\tPreparedStatement lStat = aConn.prepareStatement(\"" + query.toString() + "\");\n");
        int paramCount = 0;
        for (int i2 = 0; i2 < names.length; ++i2) {
            String lCol = names[i2];
            String type = types[i2];
            String name = "i" + lCol.substring(0, 1).toUpperCase() + lCol.substring(1).toLowerCase();
            if (lCol.equalsIgnoreCase("username") || lCol.equalsIgnoreCase("creationdate") || lCol.equalsIgnoreCase("modificationdate")) continue;
            ++paramCount;
            if (Character.isUpperCase(type.charAt(0)) || type.indexOf(".") >= 0) {
                lsb.append("\t\tif(" + name + " == null) {\n");
                lsb.append("\t\t\tlStat.setNull(" + paramCount + ", " + aMeta.getCodedColumnType(lCol) + ");\n");
                lsb.append("\t\t} else {\n\t");
                lsb.append("\t\tlStat.setObject(" + paramCount + ", " + name + ");\n");
                lsb.append("\t\t}\n");
                continue;
            }
            if (type.equals("byte[]")) {
                lsb.append("\t\tif(" + name + " == null) {\n");
                lsb.append("\t\t\tlStat.setNull(" + paramCount + ", " + aMeta.getCodedColumnType(lCol) + ");\n");
                lsb.append("\t\t} else {\n");
                lsb.append("\t\t\tByteArrayInputStream bais" + i2 + " = new ByteArrayInputStream(" + name + ");\n");
                lsb.append("\t\t\tlStat.setBinaryStream(" + paramCount + ", bais" + i2 + ", " + name + ".length);\n");
                lsb.append("\t\t}\n");
                continue;
            }
            if (type.equals("int")) {
                lsb.append("\t\tif(" + name + " == Integer.MIN_VALUE) {\n");
                lsb.append("\t\t\tlStat.setNull(" + paramCount + ", " + aMeta.getCodedColumnType(lCol) + ");\n");
                lsb.append("\t\t} else {\n");
                lsb.append("\t\t\tlStat.setInt(" + paramCount + ", " + name + ");\n");
                lsb.append("\t\t}\n");
                continue;
            }
            if (type.equals("long")) {
                lsb.append("\t\tif(" + name + " == Long.MIN_VALUE) {\n");
                lsb.append("\t\t\tlStat.setNull(" + paramCount + ", " + aMeta.getCodedColumnType(lCol) + ");\n");
                lsb.append("\t\t} else {\n");
                lsb.append("\t\t\tlStat.setLong(" + paramCount + ", " + name + ");\n");
                lsb.append("\t\t}\n");
                continue;
            }
            if (type.equals("double")) {
                lsb.append("\t\tif(" + name + " == Double.MIN_VALUE) {\n");
                lsb.append("\t\t\tlStat.setNull(" + paramCount + ", " + aMeta.getCodedColumnType(lCol) + ");\n");
                lsb.append("\t\t} else {\n");
                lsb.append("\t\t\tlStat.setDouble(" + paramCount + ", " + name + ");\n");
                lsb.append("\t\t}\n");
                continue;
            }
            if (type.equals("char")) {
                lsb.append("\t\tif(" + name + " == Character.MIN_VALUE) {\n");
                lsb.append("\t\t\tlStat.setNull(" + paramCount + ", " + aMeta.getCodedColumnType(lCol) + ");\n");
                lsb.append("\t\t} else {\n");
                lsb.append("\t\t\tlStat.setObject(" + paramCount + ", new Character(" + name + "));\n");
                lsb.append("\t\t}\n");
                continue;
            }
            if (!type.equals("boolean")) continue;
            lsb.append("\t\tlStat.setBoolean(" + paramCount + ", " + name + ");\n");
        }
        lsb.append("\t\tint result = lStat.executeUpdate();\n\n");
        lsb.append("\t\t// Retrieving the generated keys (if any).\n");
        lsb.append("\t\tResultSet lrsKeys = lStat.getGeneratedKeys();\n");
        lsb.append("\t\tResultSetMetaData lrsmKeys = lrsKeys.getMetaData();\n");
        lsb.append("\t\tint colCount = lrsmKeys.getColumnCount();\n");
        lsb.append("\t\tiKeys = new Object[colCount];\n");
        lsb.append("\t\twhile(lrsKeys.next()) {\n");
        lsb.append("\t\t\tfor(int i=0;i<iKeys.length;i++) {\n");
        lsb.append("\t\t\t\tiKeys[i] = lrsKeys.getObject(i+1);\n");
        lsb.append("\t\t\t}\n");
        lsb.append("\t\t}\n");
        lsb.append("\t\tlrsKeys.close();\n");
        lsb.append("\t\tlStat.close();\n");
        String[] pkCols = aMeta.getPrimaryKeyColumns();
        if (pkCols.length == 1 && (pkColType = aMeta.getCodedColumnType(pkCols[0])) == 4) {
            lsb.append("\t\t// Verify that we have a single, generated key.\n");
            lsb.append("\t\tif(iKeys != null && iKeys.length == 1 && iKeys[0] != null) {\n");
            lsb.append("\t\t\t// Since we have exactly one key specified, and only\n\t\t\t// one Primary Key column, we can infer that this was the\n\t\t\t// generated column, and we can therefore initialize it here.\n");
            lsb.append("\t\t\ti" + pkCols[0].substring(0, 1).toUpperCase() + pkCols[0].substring(1).toLowerCase() + " = ((Number) iKeys[0]).longValue();\n");
            lsb.append("\t\t}\n");
        }
        lsb.append("\t\tthis.iUpdated = false;\n");
        lsb.append("\t\treturn result;\n");
        lsb.append("\t}\n");
        lsb.append("\n\t/**\n\t * This method will return the automatically generated key for the insert if \n");
        lsb.append("\t * one was triggered, or 'null' otherwise.\n");
        lsb.append("\t *\n");
        lsb.append("\t * @return\tObject[]\twith the generated keys.\n");
        lsb.append("\t */\n");
        lsb.append("\tpublic Object[] getGeneratedKeys() {\n");
        lsb.append("\t\treturn this.iKeys;\n");
        lsb.append("\t}\n");
        this.iCode = lsb.toString();
    }

    public String toString() {
        return "\n" + this.iCode + "\n";
    }
}

