/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.io;

import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.interfaces.Modification;
import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.enumeration.MascotDatfileType;
import com.compomics.mascotdatfile.util.mascot.factory.MascotDatfileFactory;
import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.refinementparameters.MascotScore;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MascotIdfileReader
extends ExperimentObject
implements IdfileReader {
    private File inspectedFile;
    private MascotDatfileInf iMascotDatfile;
    private HashMap<String, LinkedList<Peptide>> peptideMap;
    private int peptideMapKeyLength;

    public MascotIdfileReader() {
    }

    public MascotIdfileReader(File aFile) {
        this(aFile, aFile.length() > 0x40000000L);
    }

    public MascotIdfileReader(File aFile, boolean index) {
        this.inspectedFile = aFile;
        try {
            this.iMascotDatfile = index ? MascotDatfileFactory.create(this.inspectedFile.getCanonicalPath(), MascotDatfileType.INDEX) : MascotDatfileFactory.create(this.inspectedFile.getCanonicalPath(), MascotDatfileType.MEMORY);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public String getMgfFileName() {
        String temp = this.iMascotDatfile.getParametersSection().getFile();
        return Util.getFileName(temp);
    }

    public String getFileName() {
        return this.iMascotDatfile.getFileName();
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, true);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        if (sequenceMatchingPreferences != null) {
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            this.peptideMapKeyLength = sequenceFactory.getDefaultProteinTree().getInitialTagSize();
            this.peptideMap = new HashMap(1024);
        }
        LinkedList<SpectrumMatch> result = new LinkedList<SpectrumMatch>();
        String mgfFileName = this.getMgfFileName();
        QueryToPeptideMapInf lQueryToPeptideMap = this.iMascotDatfile.getQueryToPeptideMap();
        QueryToPeptideMapInf lDecoyQueryToPeptideMap = this.iMascotDatfile.getDecoyQueryToPeptideMap(false);
        int numberOfQueries = this.iMascotDatfile.getNumberOfQueries();
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressCounter(numberOfQueries);
        }
        for (int i = 1; i <= numberOfQueries; ++i) {
            List<PeptideHit> mascotDecoyPeptideHits = null;
            try {
                mascotDecoyPeptideHits = lDecoyQueryToPeptideMap.getAllPeptideHits(i);
            }
            catch (Exception e) {
                // empty catch block
            }
            List<PeptideHit> mascotPeptideHits = lQueryToPeptideMap.getAllPeptideHits(i);
            PeptideHit testPeptide = null;
            if (mascotPeptideHits != null && !mascotPeptideHits.isEmpty()) {
                testPeptide = mascotPeptideHits.get(0);
            } else if (mascotDecoyPeptideHits != null && !mascotDecoyPeptideHits.isEmpty()) {
                testPeptide = mascotDecoyPeptideHits.get(0);
            }
            if (testPeptide != null) {
                Query tempQuery = this.iMascotDatfile.getQuery(i);
                String tempName = i + "";
                if (tempQuery.getTitle() != null && !tempQuery.getTitle().startsWith("No title (Query ")) {
                    tempName = tempQuery.getTitle();
                }
                String spectrumId = this.fixMgfTitle(tempName);
                String measuredCharge = tempQuery.getChargeString();
                String sign = String.valueOf(measuredCharge.charAt(1));
                Charge charge = measuredCharge.equalsIgnoreCase("Mr") ? null : (sign.compareTo("+") == 0 ? new Charge(1, Integer.valueOf(measuredCharge.substring(0, 1))) : new Charge(-1, Integer.valueOf(measuredCharge.substring(0, 1))));
                SpectrumMatch currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(mgfFileName, spectrumId));
                currentMatch.setSpectrumNumber(i);
                HashMap hitMap = new HashMap();
                if (mascotPeptideHits != null) {
                    for (PeptideHit peptideHit : mascotPeptideHits) {
                        if (!hitMap.containsKey(peptideHit.getExpectancy())) {
                            hitMap.put(peptideHit.getExpectancy(), new ArrayList());
                        }
                        ((ArrayList)hitMap.get(peptideHit.getExpectancy())).add(peptideHit);
                    }
                }
                if (mascotDecoyPeptideHits != null) {
                    for (PeptideHit peptideHit : mascotDecoyPeptideHits) {
                        if (!hitMap.containsKey(peptideHit.getExpectancy())) {
                            hitMap.put(peptideHit.getExpectancy(), new ArrayList());
                        }
                        ((ArrayList)hitMap.get(peptideHit.getExpectancy())).add(peptideHit);
                    }
                }
                ArrayList eValues = new ArrayList(hitMap.keySet());
                Collections.sort(eValues);
                int rank = 1;
                for (Double eValue : eValues) {
                    for (PeptideHit peptideHit : (ArrayList)hitMap.get(eValue)) {
                        PeptideAssumption peptideAssumption = this.getPeptideAssumption(peptideHit, charge, rank, sequenceMatchingPreferences);
                        if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideAssumption.getPeptide().getSequence())) {
                            Peptide peptide = peptideAssumption.getPeptide();
                            ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
                            for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                                Peptide newPeptide = new Peptide(expandedSequence.toString(), new ArrayList<ModificationMatch>(modificationMatches.size()));
                                for (ModificationMatch modificationMatch : modificationMatches) {
                                    newPeptide.addModificationMatch(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite()));
                                }
                                PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                                currentMatch.addHit(Advocate.mascot.getIndex(), newAssumption, false);
                            }
                            continue;
                        }
                        currentMatch.addHit(Advocate.mascot.getIndex(), peptideAssumption, false);
                    }
                    rank += ((ArrayList)hitMap.get(eValue)).size();
                }
                result.add(currentMatch);
            }
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) break;
            waitingHandler.setSecondaryProgressCounter(i);
        }
        return result;
    }

    private PeptideAssumption getPeptideAssumption(PeptideHit aPeptideHit, Charge charge, int rank, SequenceMatchingPreferences sequenceMatchingPreferences) {
        ArrayList<ModificationMatch> foundModifications = new ArrayList<ModificationMatch>();
        String peptideSequence = aPeptideHit.getSequence();
        int peptideSequenceLength = peptideSequence.length();
        int numberOfModifications = aPeptideHit.getModifications().length;
        for (int l = 0; l < numberOfModifications; ++l) {
            int modificationSite = l == 0 ? 1 : (l > peptideSequenceLength ? peptideSequenceLength : l);
            Modification handledModification = aPeptideHit.getModifications()[l];
            if (handledModification == null) continue;
            foundModifications.add(new ModificationMatch(handledModification.getMass() + "@" + peptideSequence.charAt(modificationSite - 1), !handledModification.isFixed(), modificationSite));
        }
        Peptide peptide = new Peptide(peptideSequence, foundModifications);
        if (sequenceMatchingPreferences != null) {
            String subSequence = peptideSequence.substring(0, this.peptideMapKeyLength);
            LinkedList<Peptide> peptidesForTag = this.peptideMap.get(subSequence = AminoAcid.getMatchingSequence(subSequence, sequenceMatchingPreferences));
            if (peptidesForTag == null) {
                peptidesForTag = new LinkedList();
                this.peptideMap.put(subSequence, peptidesForTag);
            }
            peptidesForTag.add(peptide);
        }
        PeptideAssumption currentAssumption = new PeptideAssumption(peptide, rank, Advocate.mascot.getIndex(), charge, aPeptideHit.getExpectancy(), this.getFileName());
        MascotScore scoreParam = new MascotScore(aPeptideHit.getIonsScore());
        currentAssumption.addUrParam(scoreParam);
        return currentAssumption;
    }

    private String fixMgfTitle(String spectrumTitle) {
        try {
            spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("An exception was thrown when trying to decode an mgf tile!");
            e.printStackTrace();
        }
        return spectrumTitle;
    }

    @Override
    public void close() throws IOException {
        this.iMascotDatfile.finish();
        this.iMascotDatfile = null;
    }

    @Override
    public String getExtension() {
        return ".dat";
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.iMascotDatfile.getHeaderSection().getVersion());
        result.put("Mascot", versions);
        return result;
    }

    @Override
    public HashMap<String, LinkedList<Peptide>> getPeptidesMap() {
        return this.peptideMap;
    }

    @Override
    public HashMap<String, LinkedList<SpectrumMatch>> getTagsMap() {
        return new HashMap<String, LinkedList<SpectrumMatch>>();
    }

    @Override
    public void clearTagsMap() {
    }

    @Override
    public void clearPeptidesMap() {
        if (this.peptideMap != null) {
            this.peptideMap.clear();
        }
    }
}

