/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTreeComponentsFactory;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.LastSelectedFolder;
import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class UtilitiesUserPreferences
implements Serializable {
    static final long serialVersionUID = -4343570286224891504L;
    private static String USER_PREFERENCES_FILE = System.getProperty("user.home") + "/.compomics/userpreferences.cup";
    private Float spectrumAnnotatedPeakWidth = Float.valueOf(1.0f);
    private Float spectrumBackgroundPeakWidth = Float.valueOf(1.0f);
    private Color spectrumAnnotatedPeakColor = Color.RED;
    private Color spectrumAnnotatedMirroredPeakColor = Color.BLUE;
    private Color spectrumBackgroundPeakColor = new Color(100, 100, 100, 50);
    private Color sparklineColorValidated = new Color(110, 196, 97);
    private Color sparklineColorNonValidated = new Color(208, 19, 19);
    private Color sparklineColorNotFound = new Color(222, 222, 222);
    private Color sparklineColorPossible = new Color(100, 150, 255);
    private Color sparklineColorDoubtful = new Color(255, 204, 0);
    private Color sparklineColorFalsePositive = new Color(255, 51, 51);
    private Color peptideSelected = new Color(0, 0, 255);
    private int memoryPreference = 4096;
    private File proteinTreeFolder = null;
    private HashMap<Long, ArrayList<Long>> proteinTreeImportTime;
    private String searchGuiPath = null;
    private String peptideShakerPath = null;
    private String reporterPath = null;
    private String relimsPath = null;
    private String localPrideFolder = "user.home";
    private File dbFolder = null;
    private ArrayList<File> favoriteDBs = null;
    private ArrayList<String> readTweets = null;
    private ArrayList<String> displayedTips = null;
    private Boolean autoUpdate = true;
    private Boolean notifyStart = true;
    private LastSelectedFolder lastSelectedFolder;

    public Color getSparklineColor() {
        return this.sparklineColorValidated;
    }

    public void setSparklineColor(Color sparklineColorValidated) {
        this.sparklineColorValidated = sparklineColorValidated;
    }

    public Color getSparklineColorNonValidated() {
        if (this.sparklineColorNonValidated == null) {
            this.sparklineColorNonValidated = new Color(255, 0, 0);
        }
        return this.sparklineColorNonValidated;
    }

    public Color getPeptideSelected() {
        if (this.peptideSelected == null) {
            this.peptideSelected = new Color(0, 0, 255);
        }
        return this.peptideSelected;
    }

    public Color getSparklineColorNotFound() {
        if (this.sparklineColorNotFound == null) {
            this.sparklineColorNotFound = new Color(222, 222, 222);
        }
        return this.sparklineColorNotFound;
    }

    public void setSparklineColorNonValidated(Color sparklineColorNonValidated) {
        this.sparklineColorNonValidated = sparklineColorNonValidated;
    }

    public Color getSparklineColorPossible() {
        if (this.sparklineColorPossible == null) {
            this.sparklineColorPossible = new Color(235, 235, 235);
        }
        return this.sparklineColorPossible;
    }

    public void setSparklineColorPossible(Color sparklineColorPossible) {
        this.sparklineColorPossible = sparklineColorPossible;
    }

    public Color getSparklineColorDoubtful() {
        if (this.sparklineColorDoubtful == null) {
            this.sparklineColorDoubtful = new Color(255, 204, 0);
        }
        return this.sparklineColorDoubtful;
    }

    public void setSparklineColorDoubtful(Color sparklineColorDoubtful) {
        this.sparklineColorDoubtful = sparklineColorDoubtful;
    }

    public Color getSparklineColorFalsePositives() {
        if (this.sparklineColorFalsePositive == null) {
            this.sparklineColorFalsePositive = new Color(255, 51, 51);
        }
        return this.sparklineColorFalsePositive;
    }

    public void setSparklineColorFalsePositives(Color sparklineColorFalsePositive) {
        this.sparklineColorFalsePositive = sparklineColorFalsePositive;
    }

    public int getMemoryPreference() {
        if (this.memoryPreference == 0) {
            this.memoryPreference = 4096;
        }
        return this.memoryPreference;
    }

    public void setMemoryPreference(int memoryPreference) {
        this.memoryPreference = memoryPreference;
    }

    public Color getSpectrumAnnotatedPeakColor() {
        if (this.spectrumAnnotatedPeakColor == null) {
            this.spectrumAnnotatedPeakColor = Color.RED;
        }
        return this.spectrumAnnotatedPeakColor;
    }

    public void setSpectrumAnnotatedPeakColor(Color spectrumAnnotatedPeakColor) {
        this.spectrumAnnotatedPeakColor = spectrumAnnotatedPeakColor;
    }

    public Color getSpectrumAnnotatedMirroredPeakColor() {
        if (this.spectrumAnnotatedMirroredPeakColor == null) {
            this.spectrumAnnotatedMirroredPeakColor = Color.BLUE;
        }
        return this.spectrumAnnotatedMirroredPeakColor;
    }

    public void setSpectrumAnnotatedMirroredPeakColor(Color spectrumAnnotatedMirroredPeakColor) {
        this.spectrumAnnotatedMirroredPeakColor = spectrumAnnotatedMirroredPeakColor;
    }

    public Color getSpectrumBackgroundPeakColor() {
        if (this.spectrumBackgroundPeakColor == null) {
            this.spectrumBackgroundPeakColor = new Color(100, 100, 100, 50);
        }
        return this.spectrumBackgroundPeakColor;
    }

    public void setSpectrumBackgroundPeakColor(Color spectrumBackgroundPeakColor) {
        this.spectrumBackgroundPeakColor = spectrumBackgroundPeakColor;
    }

    public Float getSpectrumAnnotatedPeakWidth() {
        if (this.spectrumAnnotatedPeakWidth == null) {
            this.spectrumAnnotatedPeakWidth = Float.valueOf(1.0f);
        }
        return this.spectrumAnnotatedPeakWidth;
    }

    public void setSpectrumAnnotatedPeakWidth(float spectrumAnnotatedPeakWidth) {
        this.spectrumAnnotatedPeakWidth = Float.valueOf(spectrumAnnotatedPeakWidth);
    }

    public Float getSpectrumBackgroundPeakWidth() {
        if (this.spectrumBackgroundPeakWidth == null) {
            this.spectrumBackgroundPeakWidth = Float.valueOf(1.0f);
        }
        return this.spectrumBackgroundPeakWidth;
    }

    public void setSpectrumBackgroundPeakWidth(float spectrumBackgroundPeakWidth) {
        this.spectrumBackgroundPeakWidth = Float.valueOf(spectrumBackgroundPeakWidth);
    }

    public String getSearchGuiPath() {
        return this.searchGuiPath;
    }

    public void setSearchGuiPath(String searchGuiPath) {
        this.searchGuiPath = searchGuiPath;
    }

    public String getRelimsPath() {
        return this.relimsPath;
    }

    public void setRelimsPath(String relimsPath) {
        this.relimsPath = relimsPath;
    }

    public String getPeptideShakerPath() {
        return this.peptideShakerPath;
    }

    public void setPeptideShakerPath(String peptideShakerPath) {
        this.peptideShakerPath = peptideShakerPath;
    }

    public String getReporterPath() {
        return this.reporterPath;
    }

    public void setReporterPath(String reporterPath) {
        this.reporterPath = reporterPath;
    }

    public static void saveUserPreferences(UtilitiesUserPreferences userPreferences) {
        try {
            File file = new File(USER_PREFERENCES_FILE);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            SerializationUtils.writeObject(userPreferences, file);
        }
        catch (Exception e) {
            System.err.println("An error occurred while saving " + USER_PREFERENCES_FILE + " (see below).");
            e.printStackTrace();
        }
    }

    public static UtilitiesUserPreferences loadUserPreferences() {
        UtilitiesUserPreferences userPreferences;
        File file = new File(USER_PREFERENCES_FILE);
        if (!file.exists()) {
            userPreferences = new UtilitiesUserPreferences();
            UtilitiesUserPreferences.saveUserPreferences(userPreferences);
        } else {
            try {
                userPreferences = (UtilitiesUserPreferences)SerializationUtils.readObject(file);
            }
            catch (Exception e) {
                System.err.println("An error occurred while loading " + USER_PREFERENCES_FILE + " (see below). Preferences set back to default.");
                e.printStackTrace();
                userPreferences = new UtilitiesUserPreferences();
                UtilitiesUserPreferences.saveUserPreferences(userPreferences);
            }
        }
        return userPreferences;
    }

    public String getLocalPrideFolder() {
        return this.localPrideFolder;
    }

    public void setLocalPrideFolder(String localPrideFolder) {
        this.localPrideFolder = localPrideFolder;
    }

    public File getDbFolder() {
        return this.dbFolder;
    }

    public void setDbFolder(File dbFolder) {
        this.dbFolder = dbFolder;
    }

    public ArrayList<File> getFavoriteDBs() {
        if (this.favoriteDBs == null) {
            this.favoriteDBs = new ArrayList();
        } else {
            this.checkDbFiles();
        }
        return this.favoriteDBs;
    }

    public void checkDbFiles() {
        ArrayList<File> checkedFiles = new ArrayList<File>();
        for (File dbFile : this.favoriteDBs) {
            if (!dbFile.exists()) continue;
            checkedFiles.add(dbFile);
        }
        this.favoriteDBs = checkedFiles;
    }

    public void addFavoriteDB(File dbFile) {
        if (this.favoriteDBs == null) {
            this.favoriteDBs = new ArrayList();
        }
        this.favoriteDBs.add(0, dbFile);
    }

    public File getProteinTreeFolder() {
        if (this.proteinTreeFolder == null) {
            this.proteinTreeFolder = new File(ProteinTreeComponentsFactory.getDefaultDbFolderPath());
        }
        return this.proteinTreeFolder;
    }

    public void setProteinTreeFolder(File proteinTreeFolder) {
        this.proteinTreeFolder = proteinTreeFolder;
    }

    public HashMap<Long, ArrayList<Long>> getProteinTreeImportTime() {
        if (this.proteinTreeImportTime == null) {
            this.proteinTreeImportTime = new HashMap();
        }
        return this.proteinTreeImportTime;
    }

    public void addProteinTreeImportTime(long fileSize, long importTime) {
        ArrayList<Long> importTimes;
        if (this.proteinTreeImportTime == null) {
            this.proteinTreeImportTime = new HashMap();
        }
        if ((importTimes = this.proteinTreeImportTime.get(fileSize)) == null) {
            importTimes = new ArrayList();
            this.proteinTreeImportTime.put(fileSize, importTimes);
        }
        importTimes.add(importTime);
    }

    public void clearProteinTreeImportTimes() {
        if (this.proteinTreeImportTime != null) {
            this.proteinTreeImportTime.clear();
        }
    }

    public ArrayList<String> getReadTweets() {
        if (this.readTweets == null) {
            this.readTweets = new ArrayList();
        }
        return this.readTweets;
    }

    public void setReadTweets(ArrayList<String> readTweets) {
        this.readTweets = readTweets;
    }

    public ArrayList<String> getDisplayedTips() {
        if (this.displayedTips == null) {
            this.displayedTips = new ArrayList();
        }
        return this.displayedTips;
    }

    public void setDisplayedTips(ArrayList<String> displayedTips) {
        this.displayedTips = displayedTips;
    }

    public static String getUserPreferencesFile() {
        return USER_PREFERENCES_FILE;
    }

    public static String getUserPreferencesFolder() {
        File tempFile = new File(UtilitiesUserPreferences.getUserPreferencesFile());
        return tempFile.getParent();
    }

    public static void setUserPreferencesFolder(String userPreferencesFolder) {
        File tempFile = new File(userPreferencesFolder, "/utilities_userpreferences.cup");
        USER_PREFERENCES_FILE = tempFile.getAbsolutePath();
    }

    public Boolean isAutoUpdate() {
        if (this.autoUpdate == null) {
            this.autoUpdate = true;
        }
        return this.autoUpdate;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public Boolean isNotifyStart() {
        if (this.notifyStart == null) {
            this.notifyStart = true;
        }
        return this.notifyStart;
    }

    public void setNotifyStart(Boolean notifyStart) {
        this.notifyStart = notifyStart;
    }

    public LastSelectedFolder getLastSelectedFolder() {
        if (this.lastSelectedFolder == null) {
            this.lastSelectedFolder = new LastSelectedFolder();
        }
        return this.lastSelectedFolder;
    }

    public void setLastSelectedFolder(LastSelectedFolder lastSelectedFolder) {
        this.lastSelectedFolder = lastSelectedFolder;
    }
}

