/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.roc;

import com.compomics.util.math.statistics.Distribution;
import com.compomics.util.math.statistics.ROC;
import org.apache.commons.math.MathException;

public class DistributionRoc
implements ROC {
    private final Distribution distributionControl;
    private final Distribution distributionPatient;

    public DistributionRoc(Distribution distributionControl, Distribution distributionPatient) {
        this.distributionControl = distributionControl;
        this.distributionPatient = distributionPatient;
    }

    @Override
    public double getValueAt(double specificity) throws MathException {
        double x = this.distributionPatient.getValueAtCumulativeProbability(specificity);
        return this.distributionControl.getCumulativeProbabilityAt(x);
    }

    @Override
    public double getSpecificityAt(double sensitivity) throws MathException {
        double x = this.distributionControl.getValueAtCumulativeProbability(sensitivity);
        return this.distributionPatient.getCumulativeProbabilityAt(x);
    }

    @Override
    public double[][] getxYValues() throws MathException {
        double[][] result = new double[101][2];
        for (int i = 0; i <= 100; ++i) {
            double x = (double)i / 100.0;
            double y = this.getValueAt(x);
            result[i][0] = x;
            result[i][1] = y;
        }
        return result;
    }

    @Override
    public double getAuc() throws MathException {
        int nBins = 1000;
        double binSize = 1.0 / (double)nBins;
        double halfBin = binSize / 2.0;
        double auc = 0.0;
        for (int i = 0; i < nBins; ++i) {
            double x = (double)i * binSize + halfBin;
            double y = this.getValueAt(x);
            auc += y;
        }
        return auc *= binSize;
    }
}

