/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring.psm_scores;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.math.BasicMathFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.math.util.FastMath;

public class ComplementarityScore {
    private static final Double log2 = FastMath.log((double)2.0);

    public static double getScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, HashSet<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int identificationCharge, double mzTolerance) {
        return ComplementarityScore.getScore(peptide, spectrum, iontypes, neutralLosses, charges, identificationCharge, mzTolerance, null);
    }

    public static double getScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Ion.IonType, HashSet<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int identificationCharge, double mzTolerance, PeptideSpectrumAnnotator peptideSpectrumAnnotator) {
        if (peptideSpectrumAnnotator == null) {
            peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
        }
        int sequenceLength = peptide.getSequence().length();
        ArrayList<IonMatch> matches = peptideSpectrumAnnotator.getSpectrumAnnotation(iontypes, neutralLosses, charges, identificationCharge, spectrum, peptide, 0.0, mzTolerance, false, true);
        HashMap<Integer, Double> residueToMatchesMap = new HashMap<Integer, Double>(sequenceLength);
        for (int i = 1; i <= sequenceLength; ++i) {
            residueToMatchesMap.put(i, 0.0);
        }
        for (IonMatch ionMatch : matches) {
            Ion ion = ionMatch.ion;
            if (!(ion instanceof PeptideFragmentIon)) continue;
            PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ion;
            int number = peptideFragmentIon.getNumber();
            residueToMatchesMap.put(number, (Double)residueToMatchesMap.get(number) + 1.0);
        }
        ArrayList<Double> scorePerResidue = new ArrayList<Double>(residueToMatchesMap.size());
        for (int number = 1; number <= sequenceLength; ++number) {
            Double nIons = (Double)residueToMatchesMap.get(number);
            if (nIons == null) continue;
            scorePerResidue.add(FastMath.log((double)nIons) / log2);
        }
        double mean = 0.0;
        if (!scorePerResidue.isEmpty()) {
            mean = BasicMathFunctions.mean(scorePerResidue);
        }
        return Math.pow(2.0, mean);
    }
}

