/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.IdentificationAlgorithmParameter;

public class MyriMatchParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = 8755937399680481097L;
    private Integer minPeptideLength = 6;
    private Integer maxPeptideLength = 30;
    private Integer numberOfSpectrumMatches = 10;
    private Double ticCutoffPercentage = 0.98;
    private Integer maxDynamicMods = 2;
    private Integer minTerminiCleavages = 2;
    private Double minPrecursorMass = 0.0;
    private Double maxPrecursorMass = 10000.0;
    private Boolean useSmartPlusThreeModel = true;
    private Boolean computeXCorr = false;
    private Integer numIntensityClasses = 3;
    private Integer classSizeMultiplier = 2;
    private Integer numberOfBatches = 50;
    private Integer lowerIsotopeCorrection = -1;
    private Integer upperIsotopeCorrection = 2;
    private String fragmentationRule = "CID";
    private Integer maxPeakCount = 100;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.myriMatch;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof MyriMatchParameters) {
            MyriMatchParameters msgfParameters = (MyriMatchParameters)identificationAlgorithmParameter;
            if (this.minPeptideLength != msgfParameters.getMinPeptideLength()) {
                return false;
            }
            if (this.maxPeptideLength != msgfParameters.getMaxPeptideLength()) {
                return false;
            }
            if (this.numberOfSpectrumMatches != msgfParameters.getNumberOfSpectrumMatches()) {
                return false;
            }
            double diff = Math.abs(this.ticCutoffPercentage - msgfParameters.getTicCutoffPercentage());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.maxDynamicMods != msgfParameters.getMaxDynamicMods()) {
                return false;
            }
            if (this.minTerminiCleavages != msgfParameters.getMinTerminiCleavages()) {
                return false;
            }
            diff = Math.abs(this.minPrecursorMass - msgfParameters.getMinPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            diff = Math.abs(this.maxPrecursorMass - msgfParameters.getMaxPrecursorMass());
            if (diff > 1.0E-13) {
                return false;
            }
            if (this.useSmartPlusThreeModel.booleanValue() != msgfParameters.getUseSmartPlusThreeModel()) {
                return false;
            }
            if (this.computeXCorr.booleanValue() != msgfParameters.getComputeXCorr()) {
                return false;
            }
            if (this.numIntensityClasses != msgfParameters.getNumIntensityClasses()) {
                return false;
            }
            if (this.classSizeMultiplier != msgfParameters.getClassSizeMultiplier()) {
                return false;
            }
            if (this.numberOfBatches != msgfParameters.getNumberOfBatches()) {
                return false;
            }
            if (this.lowerIsotopeCorrection != msgfParameters.getLowerIsotopeCorrectionRange()) {
                return false;
            }
            if (this.upperIsotopeCorrection != msgfParameters.getUpperIsotopeCorrectionRange()) {
                return false;
            }
            if (!this.fragmentationRule.equalsIgnoreCase(msgfParameters.getFragmentationRule())) {
                return false;
            }
            return this.maxPeakCount == msgfParameters.getMaxPeakCount();
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("MIN_PEP_LENGTH=");
        output.append(this.minPeptideLength);
        output.append(newLine);
        output.append("MAX_PEP_LENGTH=");
        output.append(this.maxPeptideLength);
        output.append(newLine);
        output.append("NUMBER_SPECTRUM_MATCHES=");
        output.append(this.numberOfSpectrumMatches);
        output.append(newLine);
        output.append("TIC_CUTOFF_PERCENTAGE=");
        output.append(this.ticCutoffPercentage);
        output.append(newLine);
        output.append("MAX_DYNMIC_MODS=");
        output.append(this.maxDynamicMods);
        output.append(newLine);
        output.append("MIN_TERMINI_CLEAVAGES=");
        output.append(this.minTerminiCleavages);
        output.append(newLine);
        output.append("MIN_PRECURSOR_MASS=");
        output.append(this.minPrecursorMass);
        output.append(newLine);
        output.append("MAX_PRECURSOR_MASS=");
        output.append(this.maxPrecursorMass);
        output.append(newLine);
        output.append("USE_SMART_PLUS_THREE_MODEL=");
        output.append(this.useSmartPlusThreeModel);
        output.append(newLine);
        output.append("COMPUTE_XCORR=");
        output.append(this.computeXCorr);
        output.append(newLine);
        output.append("NUM_INTENSITY_CLASSES=");
        output.append(this.numIntensityClasses);
        output.append(newLine);
        output.append("CLASS_SIZE_MULTIPLIER=");
        output.append(this.classSizeMultiplier);
        output.append(newLine);
        output.append("NUM_BATCHES=");
        output.append(this.numberOfBatches);
        output.append(newLine);
        output.append("LOWER_ISOTOPE_CORRECTION=");
        output.append(this.lowerIsotopeCorrection);
        output.append(newLine);
        output.append("UPPER_ISOTOPE_CORRECTION=");
        output.append(this.upperIsotopeCorrection);
        output.append(newLine);
        output.append("FRAGMENTATION_RULE=");
        output.append(this.fragmentationRule);
        output.append(newLine);
        output.append("MAX_PEAK_COUNT=");
        output.append(this.maxPeakCount);
        output.append(newLine);
        return output.toString();
    }

    public Integer getMaxPeptideLength() {
        return this.maxPeptideLength;
    }

    public void setMaxPeptideLength(Integer maxPeptideLength) {
        this.maxPeptideLength = maxPeptideLength;
    }

    public Integer getMinPeptideLength() {
        return this.minPeptideLength;
    }

    public void setMinPeptideLength(Integer minPeptideLength) {
        this.minPeptideLength = minPeptideLength;
    }

    public Integer getNumberOfSpectrumMatches() {
        if (this.numberOfSpectrumMatches == null) {
            this.numberOfSpectrumMatches = 10;
        }
        return this.numberOfSpectrumMatches;
    }

    public void setNumberOfSpectrumMatches(Integer numberOfSpectrumMarches) {
        this.numberOfSpectrumMatches = numberOfSpectrumMarches;
    }

    public Double getTicCutoffPercentage() {
        return this.ticCutoffPercentage;
    }

    public void setTicCutoffPercentage(Double ticCutoffPercentage) {
        this.ticCutoffPercentage = ticCutoffPercentage;
    }

    public Integer getMaxDynamicMods() {
        return this.maxDynamicMods;
    }

    public void setMaxDynamicMods(Integer maxDynamicMods) {
        this.maxDynamicMods = maxDynamicMods;
    }

    public Integer getMinTerminiCleavages() {
        return this.minTerminiCleavages;
    }

    public void setMinTerminiCleavages(Integer minTerminiCleavages) {
        this.minTerminiCleavages = minTerminiCleavages;
    }

    public Double getMinPrecursorMass() {
        return this.minPrecursorMass;
    }

    public void setMinPrecursorMass(Double minPrecursorMass) {
        this.minPrecursorMass = minPrecursorMass;
    }

    public Double getMaxPrecursorMass() {
        return this.maxPrecursorMass;
    }

    public void setMaxPrecursorMass(Double maxPrecursorMass) {
        this.maxPrecursorMass = maxPrecursorMass;
    }

    public boolean getUseSmartPlusThreeModel() {
        return this.useSmartPlusThreeModel;
    }

    public void setUseSmartPlusThreeModel(boolean useSmartPlusThreeModel) {
        this.useSmartPlusThreeModel = useSmartPlusThreeModel;
    }

    public boolean getComputeXCorr() {
        return this.computeXCorr;
    }

    public void setComputeXCorr(boolean computeXCorr) {
        this.computeXCorr = computeXCorr;
    }

    public Integer getNumIntensityClasses() {
        return this.numIntensityClasses;
    }

    public void setNumIntensityClasses(Integer numIntensityClasses) {
        this.numIntensityClasses = numIntensityClasses;
    }

    public Integer getClassSizeMultiplier() {
        return this.classSizeMultiplier;
    }

    public void setClassSizeMultiplier(Integer classSizeMultiplier) {
        this.classSizeMultiplier = classSizeMultiplier;
    }

    public Integer getNumberOfBatches() {
        return this.numberOfBatches;
    }

    public void setNumberOfBatches(Integer numberOfBatches) {
        this.numberOfBatches = numberOfBatches;
    }

    public Integer getLowerIsotopeCorrectionRange() {
        return this.lowerIsotopeCorrection;
    }

    public void setLowerIsotopeCorrectionRange(Integer lowerIsotopeCorrection) {
        this.lowerIsotopeCorrection = lowerIsotopeCorrection;
    }

    public Integer getUpperIsotopeCorrectionRange() {
        return this.upperIsotopeCorrection;
    }

    public void setUpperIsotopeCorrectionRange(Integer upperIsotopeCorrection) {
        this.upperIsotopeCorrection = upperIsotopeCorrection;
    }

    public String getFragmentationRule() {
        return this.fragmentationRule;
    }

    public void setFragmentationRule(String fragmentationRule) {
        this.fragmentationRule = fragmentationRule;
    }

    public Integer getMaxPeakCount() {
        if (this.maxPeakCount == null) {
            this.maxPeakCount = 100;
        }
        return this.maxPeakCount;
    }

    public void setMaxPeakCount(Integer maxPeakCount) {
        this.maxPeakCount = maxPeakCount;
    }

    public static String enzymeMapping(Enzyme enzyme) {
        String myriMatchEnzymeAsString = null;
        String enzymeName = enzyme.getName();
        if (enzyme.isUnspecific()) {
            myriMatchEnzymeAsString = "unspecific cleavage";
        } else if (enzymeName.equalsIgnoreCase("Trypsin") || enzymeName.equalsIgnoreCase("Semi-Tryptic")) {
            myriMatchEnzymeAsString = "Trypsin/P";
        } else if (enzymeName.equalsIgnoreCase("Chymotrypsin (FYWL)") || enzymeName.equalsIgnoreCase("Chymotrypsin, no P rule (FYWL)") || enzymeName.equalsIgnoreCase("Semi-Chymotrypsin (FYWL)")) {
            myriMatchEnzymeAsString = "Chymotrypsin";
        } else if (enzymeName.equalsIgnoreCase("Lys-C")) {
            myriMatchEnzymeAsString = "Lys-C";
        } else if (enzymeName.equalsIgnoreCase("Glu-C (DE)") || enzymeName.equalsIgnoreCase("Glu-C") || enzymeName.equalsIgnoreCase("Semi-Glu-C")) {
            myriMatchEnzymeAsString = "glutamyl endopeptidase";
        } else if (enzymeName.equalsIgnoreCase("Arg-C")) {
            myriMatchEnzymeAsString = "Arg-C";
        } else if (enzymeName.equalsIgnoreCase("Asp-N")) {
            myriMatchEnzymeAsString = "Asp-N";
        } else if (enzymeName.equalsIgnoreCase("Top-Down") || enzymeName.equalsIgnoreCase("Whole Protein")) {
            myriMatchEnzymeAsString = "no cleavage";
        } else if (enzymeName.equalsIgnoreCase("CNBr")) {
            myriMatchEnzymeAsString = "CNBr";
        } else if (enzymeName.equalsIgnoreCase("Formic Acid")) {
            myriMatchEnzymeAsString = "Formic_acid";
        } else if (enzymeName.equalsIgnoreCase("Lys-C, no P rule")) {
            myriMatchEnzymeAsString = "Lys-C/P";
        } else if (enzymeName.equalsIgnoreCase("Pepsin A")) {
            myriMatchEnzymeAsString = "Pepsin A";
        } else if (enzymeName.equalsIgnoreCase("Trypsin + Chymotrypsin (FYWLKR)")) {
            myriMatchEnzymeAsString = "TrypChymo";
        } else if (enzymeName.equalsIgnoreCase("Trypsin, no P rule")) {
            myriMatchEnzymeAsString = "Trypsin";
        } else if (enzymeName.equalsIgnoreCase("Asp-N (DE)")) {
            myriMatchEnzymeAsString = "Asp-N";
        }
        return myriMatchEnzymeAsString;
    }
}

