/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.tags.Tag;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.identification.tags.tagcomponents.MassGap;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.personalization.UrParameter;
import java.util.ArrayList;

public class TagAssumption
extends SpectrumIdentificationAssumption
implements UrParameter {
    static final long serialVersionUID = 8514376202742537298L;
    private Tag tag;

    public TagAssumption() {
    }

    public TagAssumption(int advocate, int rank, Tag tag, Charge identificationCharge, double score) {
        this.advocate = advocate;
        this.rank = rank;
        this.tag = tag;
        this.identificationCharge = identificationCharge;
        this.score = score;
    }

    public Tag getTag() {
        return this.tag;
    }

    @Override
    public double getTheoreticMass() {
        return this.tag.getMass();
    }

    public double getTheoreticMass(boolean includeCTermGap, boolean includeNTermGap) {
        return this.tag.getMass(includeCTermGap, includeNTermGap);
    }

    public double getTheoreticMz(boolean includeCTermGap, boolean includeNTermGap) {
        return (this.getTheoreticMass(includeCTermGap, includeNTermGap) + (double)this.identificationCharge.value * ElementaryIon.proton.getTheoreticMass()) / (double)this.identificationCharge.value;
    }

    public ArrayList<TagAssumption> getPossibleTags(boolean forwardIon, int minCharge, int maxCharge, int maxIsotope) {
        ArrayList<TagAssumption> results = new ArrayList<TagAssumption>();
        double refMz = this.getTheoreticMz(true, true);
        double refMass = this.getTheoreticMass();
        int refCharge = this.identificationCharge.value;
        for (int charge = minCharge; charge <= maxCharge; ++charge) {
            for (int isotope = 0; isotope <= maxIsotope; ++isotope) {
                TagComponent terminalComponent;
                if (charge == refCharge && isotope <= 0) continue;
                double newMass = refMz * (double)charge - (double)charge * ElementaryIon.proton.getTheoreticMass();
                double deltaMass = newMass - refMass + (double)isotope * Atom.C.getDifferenceToMonoisotopic(1);
                int index = 0;
                if (forwardIon) {
                    index = this.tag.getContent().size() - 1;
                }
                if (!((terminalComponent = this.tag.getContent().get(index)) instanceof MassGap) || !(terminalComponent.getMass() > -deltaMass)) continue;
                Tag newTag = new Tag(this.tag);
                MassGap terminalGap = (MassGap)newTag.getContent().get(index);
                terminalGap.setMass(terminalComponent.getMass() + deltaMass);
                TagAssumption tagAssumption = new TagAssumption(this.advocate, this.rank, newTag, new Charge(1, charge), this.score);
                results.add(tagAssumption);
            }
        }
        return results;
    }

    public TagAssumption reverse(boolean yIon) {
        return new TagAssumption(this.advocate, this.rank, this.tag.reverse(yIon), this.identificationCharge, this.score);
    }

    @Override
    public String getFamilyName() {
        return "deNovo";
    }

    @Override
    public int getIndex() {
        return 2;
    }

    public String toString() {
        return this.tag.asSequence() + ", " + this.identificationCharge.getChargeAsFormattedString() + " (" + this.score + ")";
    }
}

