/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.FastaIndex;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTree;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.protein.Header;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InvalidClassException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JProgressBar;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class SequenceFactory {
    private static SequenceFactory instance = null;
    private HashMap<String, Header> currentHeaderMap = new HashMap();
    private HashMap<String, Protein> currentProteinMap = new HashMap();
    private FastaIndex fastaIndex = null;
    private BufferedRandomAccessFile currentRandomAccessFile = null;
    private File currentFastaFile = null;
    private int nCache = 100000;
    private ArrayList<String> loadedProteins = new ArrayList();
    private static final String[] decoyFlags = new String[]{"REVERSED", "RND", "SHUFFLED", "DECOY"};
    private HashMap<String, Double> molecularWeights = new HashMap();
    private static String targetDecoyFileNameTag = "_concatenated_target_decoy.fasta";
    private ProteinTree defaultProteinTree = null;
    private boolean reading = false;
    public static final long timeOut = 10000L;
    private boolean decoyInMemory = true;

    private SequenceFactory() {
    }

    public static SequenceFactory getInstance() {
        if (instance == null) {
            instance = new SequenceFactory();
        }
        return instance;
    }

    public static SequenceFactory getInstance(int nCache) {
        if (instance == null) {
            instance = new SequenceFactory();
        }
        instance.setnCache(nCache);
        return instance;
    }

    public boolean hasEnoughSequences() {
        return this.getNTargetSequences() > 10000;
    }

    public void clearFactory() throws IOException, SQLException {
        this.closeFile();
        this.defaultProteinTree = null;
        this.currentHeaderMap.clear();
        this.currentProteinMap.clear();
        this.fastaIndex = null;
        this.currentRandomAccessFile = null;
        this.currentFastaFile = null;
        this.loadedProteins.clear();
        this.molecularWeights.clear();
    }

    public void emptyCache() {
        this.currentHeaderMap.clear();
        this.currentProteinMap.clear();
        this.loadedProteins.clear();
        this.molecularWeights.clear();
        if (this.defaultProteinTree != null) {
            this.defaultProteinTree.emptyCache();
        }
    }

    public void reduceNodeCacheSize(double share) {
        this.defaultProteinTree.reduceNodeCacheSize(share);
    }

    public int getNodesInCache() {
        return this.defaultProteinTree.getNodesInCache();
    }

    public Protein getProtein(String accession) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        return this.getProtein(accession, true);
    }

    private Protein getProtein(String accession, boolean reindex) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        if (this.fastaIndex == null) {
            throw new IllegalArgumentException("Protein sequences not loaded in the sequence factory.");
        }
        Protein currentProtein = this.currentProteinMap.get(accession);
        if (currentProtein == null && this.isDefaultReversed() && this.isDecoyAccession(accession)) {
            currentProtein = this.decoyInMemory ? this.getDecoyProteinFromTargetSynchronized(accession, reindex) : this.getDecoyProteinFromTarget(accession, reindex);
        }
        if (currentProtein == null) {
            currentProtein = this.getProteinSynchronized(accession, reindex);
        }
        if (currentProtein == null) {
            throw new IllegalArgumentException("Protein not found: " + accession + ".");
        }
        return currentProtein;
    }

    public synchronized Protein getDecoyProteinFromTargetSynchronized(String accession, boolean reindex) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        Protein currentProtein = this.currentProteinMap.get(accession);
        if (currentProtein == null) {
            currentProtein = this.getDecoyProteinFromTarget(accession, reindex);
        }
        return currentProtein;
    }

    public Protein getDecoyProteinFromTarget(String accession, boolean reindex) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        Protein currentProtein = null;
        String targetAccession = SequenceFactory.getDefaultTargetAccession(accession);
        try {
            Protein targetProtein = this.currentProteinMap.get(targetAccession);
            if (targetProtein == null && this.decoyInMemory) {
                currentProtein = this.getProteinSynchronized(accession, reindex);
            } else {
                if (targetProtein == null) {
                    targetProtein = this.getProtein(targetAccession, reindex);
                }
                currentProtein = new Protein(accession, targetProtein.getDatabaseType(), SequenceFactory.reverseSequence(targetProtein.getSequence()), true);
                if (this.decoyInMemory) {
                    this.addProteinToCache(accession, currentProtein);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return currentProtein;
    }

    private synchronized Protein getProteinSynchronized(String accession, boolean reindex) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        Protein currentProtein = this.currentProteinMap.get(accession);
        if (currentProtein == null) {
            Long index = this.fastaIndex.getIndex(accession);
            if (index == null) {
                if (reindex) {
                    this.fastaIndex = this.getFastaIndex(true, null);
                    return this.getProtein(accession, false);
                }
                throw new IllegalArgumentException("Protein not found: " + accession + ".");
            }
            return this.getProtein(accession, index, 1L);
        }
        return currentProtein;
    }

    private synchronized Protein getProtein(String accession, long index, long waitingTime) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        if (waitingTime <= 0L) {
            throw new IllegalArgumentException("Waiting time should be a positive number.");
        }
        try {
            String line;
            if (this.reading) {
                throw new IllegalStateException("Attempting to read new line before current read operation is completed.");
            }
            this.reading = true;
            this.currentRandomAccessFile.seek(index);
            String sequence = "";
            Header currentHeader = this.currentHeaderMap.get(accession);
            boolean headerFound = false;
            while ((line = this.currentRandomAccessFile.readLine()) != null) {
                if ((line = line.trim()).startsWith(">")) {
                    if (!sequence.equals("") || headerFound) break;
                    if (currentHeader == null) {
                        currentHeader = Header.parseFromFASTA(line);
                        if (currentHeader == null) {
                            throw new IllegalArgumentException("Could not parse fasta header \"" + line + "\".");
                        }
                        this.currentHeaderMap.put(accession, currentHeader);
                    }
                    headerFound = true;
                    continue;
                }
                sequence = sequence + line;
            }
            Protein currentProtein = new Protein(accession, currentHeader.getDatabaseType(), sequence, this.isDecoyAccession(accession));
            this.addProteinToCache(accession, currentProtein);
            this.reading = false;
            return currentProtein;
        }
        catch (IOException e) {
            this.reading = false;
            if (waitingTime < 10000L) {
                this.wait(waitingTime);
                e.printStackTrace();
                return this.getProtein(accession, index, 2L * waitingTime);
            }
            throw e;
        }
    }

    private synchronized void addProteinToCache(String accession, Protein protein) {
        while (this.loadedProteins.size() >= this.nCache) {
            this.currentProteinMap.remove(this.loadedProteins.get(0));
            this.currentHeaderMap.remove(this.loadedProteins.get(0));
            this.loadedProteins.remove(0);
        }
        this.loadedProteins.add(accession);
        this.currentProteinMap.put(accession, protein);
    }

    public Header getHeader(String accession) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        return this.getHeader(accession, true);
    }

    private Header getHeader(String accession, boolean reindex) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        Header result = this.currentHeaderMap.get(accession);
        if (result == null) {
            Long index = this.fastaIndex.getIndex(accession);
            if (index == null) {
                if (reindex) {
                    this.fastaIndex = this.getFastaIndex(true, null);
                    return this.getHeader(accession, false);
                }
                throw new IllegalArgumentException("Protein not found: " + accession + ".");
            }
            return this.getHeader(index, 0);
        }
        return result;
    }

    private synchronized Header getHeader(long index, int nTries) throws InterruptedException, IOException {
        if (this.reading) {
            throw new IllegalStateException("Attempting to read new line before current read operation is completed.");
        }
        try {
            this.reading = true;
            this.currentRandomAccessFile.seek(index);
            Header result = Header.parseFromFASTA(this.currentRandomAccessFile.readLine());
            this.reading = false;
            return result;
        }
        catch (IOException e) {
            this.reading = false;
            if (nTries <= 100) {
                this.wait(10L);
                return this.getHeader(index, nTries + 1);
            }
            throw e;
        }
    }

    public void loadFastaFile(File fastaFile) throws FileNotFoundException, IOException, ClassNotFoundException, StringIndexOutOfBoundsException, IllegalArgumentException {
        this.loadFastaFile(fastaFile, null);
    }

    public void loadFastaFile(File fastaFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, ClassNotFoundException, StringIndexOutOfBoundsException, IllegalArgumentException {
        if (!fastaFile.exists()) {
            throw new FileNotFoundException("The FASTA file '" + fastaFile.getAbsolutePath() + "' could not be found!");
        }
        this.defaultProteinTree = null;
        this.currentFastaFile = fastaFile;
        this.currentRandomAccessFile = new BufferedRandomAccessFile(fastaFile, "r", 102400);
        this.fastaIndex = this.getFastaIndex(false, waitingHandler);
    }

    public boolean isClosed() {
        return this.currentFastaFile == null;
    }

    public void resetConnection() throws IOException {
        this.currentRandomAccessFile.close();
        this.currentRandomAccessFile = new BufferedRandomAccessFile(this.currentFastaFile, "r", 102400);
    }

    private FastaIndex getFastaIndex() throws FileNotFoundException, IOException, ClassNotFoundException, IllegalArgumentException {
        return this.getFastaIndex(false, null);
    }

    private synchronized FastaIndex getFastaIndex(boolean overwrite, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, ClassNotFoundException, StringIndexOutOfBoundsException {
        FastaIndex tempFastaIndex;
        File indexFile;
        if (!overwrite && (indexFile = new File(this.currentFastaFile.getParent(), this.currentFastaFile.getName() + ".cui")).exists()) {
            try {
                tempFastaIndex = (FastaIndex)SerializationUtils.readObject(indexFile);
                Long indexLastModified = tempFastaIndex.getLastModified();
                if (indexLastModified != null) {
                    long fileLastModified = this.currentFastaFile.lastModified();
                    if (indexLastModified == fileLastModified) {
                        return tempFastaIndex;
                    }
                    System.err.println("Reindexing: " + this.currentFastaFile.getName() + ". (changes in the file detected)");
                }
            }
            catch (InvalidClassException e) {
                System.err.println("Reindexing: " + this.currentFastaFile.getName() + ". (Reason: " + e.getLocalizedMessage() + ")");
            }
            catch (Exception e) {
                System.err.println("Reindexing: " + this.currentFastaFile.getName() + ". (Reason: " + e.getLocalizedMessage() + ")");
            }
        }
        String decoyTag = null;
        String name = null;
        String version = null;
        File indexFile2 = new File(this.currentFastaFile.getParent(), this.currentFastaFile.getName() + ".cui");
        if (indexFile2.exists()) {
            try {
                tempFastaIndex = (FastaIndex)SerializationUtils.readObject(indexFile2);
                decoyTag = tempFastaIndex.getDecoyTag();
                version = tempFastaIndex.getVersion();
                name = tempFastaIndex.getName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        System.out.println("Reindexing: " + this.currentFastaFile.getName() + ".");
        tempFastaIndex = SequenceFactory.createFastaIndex(this.currentFastaFile, name, decoyTag, version, waitingHandler);
        if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
            try {
                this.writeIndex(tempFastaIndex, this.currentFastaFile.getParentFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tempFastaIndex;
    }

    private static FastaIndex createFastaIndex(File fastaFile, String name, String decoyTag, String version, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, StringIndexOutOfBoundsException, IllegalArgumentException {
        String line;
        HashMap<String, Long> indexes = new HashMap<String, Long>();
        HashSet<String> decoyAccessions = new HashSet<String>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(fastaFile, "r", 102400);
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        boolean decoy = false;
        boolean defaultReversed = false;
        int nTarget = 0;
        long index = bufferedRandomAccessFile.getFilePointer();
        HashMap<Header.DatabaseType, Integer> databaseTypes = new HashMap<Header.DatabaseType, Integer>();
        while ((line = bufferedRandomAccessFile.readLine()) != null) {
            if (line.startsWith(">")) {
                Header fastaHeader = Header.parseFromFASTA(line);
                String accession = fastaHeader.getAccessionOrRest();
                if (indexes.containsKey(accession)) {
                    throw new IllegalArgumentException("Non unique accession number found '" + accession + "'!\nPlease check the FASTA file.");
                }
                indexes.put(accession, index);
                if (decoyTag == null) {
                    decoyTag = SequenceFactory.getDecoyFlag(accession);
                }
                if (decoyTag == null || !SequenceFactory.isDecoy(accession, decoyTag)) {
                    ++nTarget;
                    Header.DatabaseType tempDatabaseType = fastaHeader.getDatabaseType();
                    Integer typeCounter = (Integer)databaseTypes.get((Object)tempDatabaseType);
                    if (typeCounter == null) {
                        databaseTypes.put(tempDatabaseType, 1);
                    } else {
                        databaseTypes.put(tempDatabaseType, typeCounter + 1);
                    }
                } else {
                    decoyAccessions.add(accession);
                    if (!decoy) {
                        decoy = true;
                        if (accession.endsWith(SequenceFactory.getDefaultDecoyAccessionSuffix())) {
                            defaultReversed = true;
                        }
                    }
                }
                if (waitingHandler != null && progressUnit != 0L) {
                    waitingHandler.setSecondaryProgressCounter((int)(index / progressUnit));
                    if (waitingHandler.isRunCanceled()) break;
                }
                index = bufferedRandomAccessFile.getFilePointer();
                continue;
            }
            index = bufferedRandomAccessFile.getFilePointer();
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        bufferedRandomAccessFile.close();
        long lastModified = fastaFile.lastModified();
        if (version == null) {
            version = FastaIndex.getDefaultVersion(lastModified);
        }
        String fileName = fastaFile.getName();
        if (name == null) {
            name = fileName;
        }
        Header.DatabaseType mainDatabaseType = null;
        int maxCounter = 0;
        for (Header.DatabaseType tempDatabaseType : databaseTypes.keySet()) {
            if ((Integer)databaseTypes.get((Object)tempDatabaseType) <= maxCounter) continue;
            maxCounter = (Integer)databaseTypes.get((Object)tempDatabaseType);
            mainDatabaseType = tempDatabaseType;
        }
        return new FastaIndex(indexes, decoyAccessions, fileName, name, decoy, defaultReversed, nTarget, lastModified, mainDatabaseType, databaseTypes, decoyTag, version);
    }

    private void writeIndex(FastaIndex fastaIndex, File directory) throws IOException {
        File destinationFile = new File(directory, SequenceFactory.getIndexName(fastaIndex.getFileName()));
        SerializationUtils.writeObject(fastaIndex, destinationFile);
    }

    public static String getIndexName(String fastaName) {
        return fastaName + ".cui";
    }

    public void saveIndex() throws IOException {
        this.writeIndex(this.fastaIndex, this.currentFastaFile.getParentFile());
    }

    public void closeFile() throws IOException, SQLException {
        if (this.currentRandomAccessFile != null) {
            this.currentRandomAccessFile.close();
            this.currentFastaFile = null;
        }
        if (this.defaultProteinTree != null) {
            this.defaultProteinTree.close();
        }
    }

    public static boolean isDecoy(String proteinAccession, String decoyFlag) {
        if (decoyFlag == null || decoyFlag.isEmpty()) {
            return false;
        }
        String start = decoyFlag + ".*";
        String end = ".*" + decoyFlag;
        return proteinAccession.matches(start) || proteinAccession.matches(end);
    }

    private static String getDecoyFlag(String proteinAccession) {
        for (String flag : decoyFlags) {
            if (!SequenceFactory.isDecoy(proteinAccession, flag)) continue;
            return flag;
        }
        return null;
    }

    public boolean isDecoyAccession(String proteinAccession) {
        return this.fastaIndex.isDecoy(proteinAccession);
    }

    public static boolean isDecoy(String proteinAccession) {
        for (String flag : decoyFlags) {
            if (!SequenceFactory.isDecoy(proteinAccession, flag)) continue;
            return true;
        }
        return false;
    }

    public boolean concatenatedTargetDecoy() {
        return this.fastaIndex.isConcatenatedTargetDecoy();
    }

    public boolean isDefaultReversed() {
        return this.fastaIndex.isDefaultReversed();
    }

    public int getNTargetSequences() {
        return this.fastaIndex.getNTarget();
    }

    public int getNSequences() {
        return this.fastaIndex.getNSequences();
    }

    public void appendDecoySequences(File destinationFile) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        this.appendDecoySequences(destinationFile, null);
    }

    public void appendDecoySequences(File destinationFile, WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(this.fastaIndex.getNTarget());
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(destinationFile));
        for (String accession : this.fastaIndex.getIndexes().keySet()) {
            if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
            if (waitingHandler != null) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
            Protein currentProtein = this.getProtein(accession);
            Header currentHeader = this.getHeader(accession);
            String decoyAccession = SequenceFactory.getDefaultDecoyAccession(currentProtein.getAccession());
            String currentRawHeader = currentHeader.getRawHeader();
            String escapedString = Pattern.quote(accession);
            currentRawHeader = currentRawHeader.replaceAll(escapedString, decoyAccession);
            if (currentHeader.getDescription() != null && !currentHeader.getDescription().isEmpty()) {
                escapedString = Pattern.quote(currentHeader.getDescription());
                currentRawHeader = currentRawHeader.replaceAll(escapedString, SequenceFactory.getDefaultDecoyDescription(currentHeader.getDescription()));
            }
            bufferedWriter.write(currentHeader.getRawHeader() + System.getProperty("line.separator"));
            bufferedWriter.write(currentProtein.getSequence() + System.getProperty("line.separator"));
            bufferedWriter.write(currentRawHeader + System.getProperty("line.separator"));
            bufferedWriter.write(SequenceFactory.reverseSequence(currentProtein.getSequence()) + System.getProperty("line.separator"));
        }
        bufferedWriter.close();
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        boolean indexFile = true;
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            indexFile = false;
        }
        if (indexFile) {
            this.loadFastaFile(destinationFile, waitingHandler);
        } else {
            destinationFile.delete();
        }
    }

    public static String reverseSequence(String sequence) {
        return new StringBuilder(sequence).reverse().toString();
    }

    public Set<String> getAccessions() {
        Set<String> setToFill = new HashSet<String>();
        if (this.fastaIndex != null) {
            setToFill = this.fastaIndex.getIndexes().keySet();
        }
        return setToFill;
    }

    public int getnCache() {
        return this.nCache;
    }

    public void setnCache(int nCache) {
        this.nCache = nCache;
    }

    public HashMap<String, Integer> getAAOccurrences(JProgressBar progressBar) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        HashMap<String, Integer> aaMap = new HashMap<String, Integer>();
        Set<String> accessions = this.getAccessions();
        if (progressBar != null) {
            progressBar.setIndeterminate(false);
            progressBar.setMaximum(accessions.size());
            progressBar.setValue(0);
        }
        for (String accession : accessions) {
            if (!this.isDecoyAccession(accession)) {
                Protein protein = this.getProtein(accession);
                for (String aa : protein.getSequence().split("")) {
                    Integer n = aaMap.get(aa);
                    if (n == null) {
                        n = 0;
                    }
                    aaMap.put(aa, n + 1);
                }
            }
            if (progressBar == null) continue;
            progressBar.setValue(progressBar.getValue() + 1);
        }
        if (progressBar != null) {
            progressBar.setIndeterminate(true);
        }
        return aaMap;
    }

    public double computeMolecularWeight(String accession) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        if (this.isDefaultReversed() && this.isDecoyAccession(accession)) {
            try {
                return this.computeMolecularWeight(SequenceFactory.getDefaultTargetAccession(accession));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.molecularWeights.containsKey(accession)) {
            return this.molecularWeights.get(accession);
        }
        Protein protein = this.getProtein(accession);
        double weight = protein.computeMolecularWeight() / 1000.0;
        this.molecularWeights.put(accession, weight);
        return weight;
    }

    public static String getTargetDecoyFileNameTag() {
        return targetDecoyFileNameTag;
    }

    public static void setTargetDecoyFileNameTag(String targetDecoyFileNameTag) {
        SequenceFactory.targetDecoyFileNameTag = targetDecoyFileNameTag;
    }

    public String getFileName() {
        if (this.fastaIndex == null) {
            return null;
        }
        return this.fastaIndex.getFileName();
    }

    public File getCurrentFastaFile() {
        return this.currentFastaFile;
    }

    public static String getDefaultDecoyAccessionSuffix() {
        return "_" + decoyFlags[0];
    }

    public static String getDefaultDecoyAccession(String targetAccession) {
        return targetAccession + SequenceFactory.getDefaultDecoyAccessionSuffix();
    }

    public static String getDefaultDecoyDescription(String targetDescription) {
        return targetDescription + "-" + decoyFlags[0];
    }

    public static String getDefaultTargetAccession(String decoyAccession) {
        return decoyAccession.substring(0, decoyAccession.length() - SequenceFactory.getDefaultDecoyAccessionSuffix().length());
    }

    public FastaIndex getCurrentFastaIndex() {
        return this.fastaIndex;
    }

    public ProteinTree getDefaultProteinTree() throws IOException, InterruptedException, ClassNotFoundException, IllegalArgumentException, SQLException {
        int nThreads = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        return this.getDefaultProteinTree(nThreads, null, false);
    }

    public ProteinTree getDefaultProteinTree(int nThreads) throws IOException, InterruptedException, ClassNotFoundException, IllegalArgumentException, SQLException {
        return this.getDefaultProteinTree(nThreads, null, false);
    }

    public ProteinTree getDefaultProteinTree(WaitingHandler waitingHandler) throws IOException, InterruptedException, ClassNotFoundException, IllegalArgumentException, SQLException {
        int nThreads = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        return this.getDefaultProteinTree(nThreads, waitingHandler, true);
    }

    public ProteinTree getDefaultProteinTree(int nThreads, WaitingHandler waitingHandler) throws IOException, InterruptedException, ClassNotFoundException, IllegalArgumentException, SQLException {
        return this.getDefaultProteinTree(nThreads, waitingHandler, true);
    }

    public ProteinTree getDefaultProteinTree(int nThreads, WaitingHandler waitingHandler, boolean displayProgress) throws IOException, InterruptedException, ClassNotFoundException, IllegalArgumentException, SQLException {
        if (this.defaultProteinTree == null) {
            UtilitiesUserPreferences userPreferences = UtilitiesUserPreferences.loadUserPreferences();
            int memoryPreference = userPreferences.getMemoryPreference();
            int memoryAllocated = 3 * memoryPreference / 4;
            int cacheSize = 250000;
            if (memoryPreference < 2500) {
                cacheSize = 5000;
            } else if (memoryPreference < 10000) {
                cacheSize = 25000;
            }
            this.defaultProteinTree = new ProteinTree(memoryAllocated, cacheSize);
            int tagLength = 3;
            this.defaultProteinTree.initiateTree(tagLength, 50, 50, waitingHandler, true, displayProgress, nThreads);
            this.emptyCache();
            int treeSize = memoryPreference / 4;
            this.defaultProteinTree.setMemoryAllocation(treeSize);
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                this.defaultProteinTree.close();
                this.defaultProteinTree.deleteDb();
            }
        }
        return this.defaultProteinTree;
    }

    public synchronized boolean deleteProteinTree() {
        if (this.defaultProteinTree != null) {
            try {
                this.defaultProteinTree.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
            if (this.defaultProteinTree != null) {
                return this.defaultProteinTree.deleteDb();
            }
        }
        return true;
    }

    public HeaderIterator getHeaderIterator(boolean targetOnly) throws FileNotFoundException {
        return new HeaderIterator(this.currentFastaFile, targetOnly);
    }

    public ProteinIterator getProteinIterator(boolean targetOnly) throws FileNotFoundException {
        return new ProteinIterator(this.currentFastaFile, targetOnly);
    }

    public boolean isDecoyInMemory() {
        return this.decoyInMemory;
    }

    public void setDecoyInMemory(boolean decoyInMemory) {
        this.decoyInMemory = decoyInMemory;
    }

    public class ProteinIterator {
        private Header nextHeader = null;
        private Protein nextProtein = null;
        private BufferedReader br;
        private final boolean targetOnly;

        public ProteinIterator(File file, boolean targetOnly) throws FileNotFoundException {
            this.targetOnly = targetOnly;
            this.br = new BufferedReader(new FileReader(file));
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean hasNext() throws IOException {
            this.nextProtein = null;
            String sequence = "";
            Header header = this.nextHeader;
            boolean newHeaderFound = false;
            String line = this.br.readLine();
            if (line == null) {
                return false;
            }
            while (line != null) {
                block8: {
                    if (line.startsWith(">")) {
                        Header tempHeader = Header.parseFromFASTA(line);
                        if (this.targetOnly && SequenceFactory.this.isDecoyAccession(tempHeader.getAccessionOrRest())) {
                            while ((line = this.br.readLine()) != null && (!line.startsWith(">") || SequenceFactory.this.isDecoyAccession((tempHeader = Header.parseFromFASTA(line)).getAccessionOrRest()))) {
                            }
                            if (line == null) break;
                        }
                        if (header == null) {
                            header = tempHeader;
                            break block8;
                        } else {
                            this.nextHeader = tempHeader;
                            newHeaderFound = true;
                            break;
                        }
                    }
                    sequence = sequence + line.trim();
                }
                line = this.br.readLine();
            }
            if (!newHeaderFound && line != null) {
                this.close();
                return false;
            }
            this.nextProtein = new Protein(header.getAccessionOrRest(), header.getDatabaseType(), sequence, SequenceFactory.this.isDecoyAccession(header.getAccessionOrRest()));
            return true;
        }

        public Protein getNextProtein() {
            return this.nextProtein;
        }

        public void close() throws IOException {
            this.br.close();
        }
    }

    public class HeaderIterator {
        private Header nextHeader = null;
        private BufferedReader br;
        private final boolean targetOnly;

        public HeaderIterator(File file, boolean targetOnly) throws FileNotFoundException {
            this.targetOnly = targetOnly;
            this.br = new BufferedReader(new FileReader(file));
        }

        public boolean hasNext() throws IOException {
            String line;
            this.nextHeader = null;
            while ((line = this.br.readLine()) != null) {
                if ((line = line.trim()).equals("") || !line.startsWith(">")) continue;
                this.nextHeader = Header.parseFromFASTA(line);
                if (!this.targetOnly || !SequenceFactory.this.isDecoyAccession(this.nextHeader.getAccession())) break;
                this.nextHeader = null;
            }
            if (this.nextHeader != null) {
                return true;
            }
            this.close();
            return false;
        }

        public Header getNext() {
            return this.nextHeader;
        }

        public void close() throws IOException {
            this.br.close();
        }
    }
}

