/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.Tag;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.preferences.ModificationProfile;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PTMFactory
implements Serializable {
    static final long serialVersionUID = 7935264190312934466L;
    private static PTMFactory instance = null;
    private static String SERIALIZATION_FILE_FOLDER = System.getProperty("user.home") + "/.compomics";
    private static String SERIALIZATION_FILE_NAME = "ptmFactory-3.28.24.cus";
    private HashMap<String, PTM> ptmMap = new HashMap();
    private ArrayList<String> defaultMods = new ArrayList();
    private ArrayList<String> userMods = new ArrayList();
    private HashMap<String, Color> userColors = new HashMap();
    private HashMap<String, String> shortNames = new HashMap();
    private HashMap<String, Integer> defaultOmssaIndexes = new HashMap();
    public static final PTM unknownPTM = new PTM(0, "unknown", 0.0, new AminoAcidPattern());
    public static final String SEARCH_SUFFIX = "|search-only";
    public boolean defaultModsSorted = false;
    public boolean usersModsSorted = false;

    private PTMFactory() {
        this.defaultMods = new ArrayList();
    }

    public static PTMFactory getInstance() {
        if (instance == null) {
            try {
                File savedFile = new File(SERIALIZATION_FILE_FOLDER, SERIALIZATION_FILE_NAME);
                instance = (PTMFactory)SerializationUtils.readObject(savedFile);
            }
            catch (Exception e) {
                instance = new PTMFactory();
                try {
                    instance.saveFactory();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            instance.setDefaultReporterIons();
        }
        return instance;
    }

    public void clearFactory() {
        instance = new PTMFactory();
    }

    public void reloadFactory() {
        instance = null;
    }

    public void saveFactory() throws IOException {
        File factoryFile = new File(SERIALIZATION_FILE_FOLDER, SERIALIZATION_FILE_NAME);
        if (!factoryFile.getParentFile().exists()) {
            factoryFile.getParentFile().mkdir();
        }
        SerializationUtils.writeObject(instance, factoryFile);
    }

    public PTM getPTM(ModificationProfile modificationProfile, int index) {
        String name = modificationProfile.getModification(index);
        if (name != null && this.ptmMap.get(name) != null) {
            return this.ptmMap.get(name);
        }
        return unknownPTM;
    }

    public PTM getSearchedPTM(PTM modification) {
        if (!modification.isStandardSearch()) {
            return new PTM(modification.getType(), modification.getName() + SEARCH_SUFFIX, modification.getMass(), modification.getPattern().getStandardSearchPattern());
        }
        return modification;
    }

    public PTM getSearchedPTM(String modificationName) {
        PTM modification = this.getPTM(modificationName);
        return this.getSearchedPTM(modification);
    }

    public void addUserPTM(PTM ptm) {
        String modName = ptm.getName();
        this.ptmMap.put(modName, ptm);
        if (!this.userMods.contains(modName)) {
            this.userMods.add(modName);
        } else {
            this.userMods.set(this.userMods.indexOf(modName), modName);
        }
        this.usersModsSorted = false;
    }

    public void removeUserPtm(String ptmName) {
        if (this.defaultMods.contains(ptmName)) {
            throw new IllegalArgumentException("Impossible to remove default modification " + ptmName);
        }
        this.ptmMap.remove(ptmName);
        this.userMods.remove(ptmName);
    }

    public PTM getPTM(String name) {
        PTM ptm = this.ptmMap.get(name);
        if (ptm != null) {
            return ptm;
        }
        return unknownPTM;
    }

    public boolean containsPTM(String name) {
        return this.ptmMap.containsKey(name) || name.equals(unknownPTM.getName());
    }

    public void importModifications(File modificationsFile, boolean userMod) throws XmlPullParserException, IOException {
        this.importModifications(modificationsFile, userMod, false);
    }

    public void importModifications(File modificationsFile, boolean userMod, boolean overwrite) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(modificationsFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        while (type != 1) {
            if (type == 2 && parser.getName().equals("MSModSpec")) {
                this.parseMSModSpec(parser, userMod, overwrite);
            }
            type = parser.next();
        }
        br.close();
        this.setDefaultNeutralLosses();
        this.setDefaultReporterIons();
    }

    public Integer getDefaultOMSSAIndex(String modificationName) {
        return this.defaultOmssaIndexes.get(modificationName);
    }

    public static HashMap<String, Integer> getOMSSAIndexes(File modificationsFile) throws XmlPullParserException, FileNotFoundException, IOException {
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(modificationsFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        Integer number = null;
        while (type != 1) {
            if (type == 2 && parser.getName().equals("MSMod")) {
                parser.next();
                String numberString = parser.getText();
                try {
                    number = new Integer(numberString);
                }
                catch (NumberFormatException nfe) {
                    throw new XmlPullParserException("Found non-parseable text '" + numberString + "' for the value of the 'MSMod' tag on line " + parser.getLineNumber() + ".");
                }
            }
            if (type == 2 && parser.getName().equals("MSModSpec_name")) {
                parser.next();
                String name = parser.getText();
                if (number != null) {
                    indexes.put(name, number);
                }
            }
            type = parser.next();
        }
        br.close();
        return indexes;
    }

    private void parseMSModSpec(XmlPullParser parser, boolean userMod, boolean overwrite) throws XmlPullParserException, IOException {
        if (!parser.getName().equals("MSModSpec") || parser.getEventType() != 2) {
            throw new IllegalArgumentException("XmlPullParser should have been on the start tag for 'MSModSpec', but was on '" + parser.getName() + "' instead.");
        }
        parser.nextTag();
        if (!parser.getName().equals("MSModSpec_mod")) {
            throw new XmlPullParserException("Found tag '" + parser.getName() + "' where 'MSModSpec_mod' was expected on line " + parser.getLineNumber() + ".");
        }
        parser.nextTag();
        if (!parser.getName().equals("MSMod")) {
            throw new XmlPullParserException("Found tag '" + parser.getName() + "' where 'MSMod' was expected on line " + parser.getLineNumber() + ".");
        }
        parser.next();
        String numberString = parser.getText();
        int number = -1;
        try {
            number = Integer.parseInt(numberString);
        }
        catch (NumberFormatException nfe) {
            throw new XmlPullParserException("Found non-parseable text '" + numberString + "' for the value of the 'MSMod' tag on line " + parser.getLineNumber() + ".");
        }
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("MSModType")) {
            type = parser.next();
        }
        String modType = parser.getAttributeValue(0);
        type = parser.next();
        while (type != 2 || !parser.getName().equals("MSModSpec_name")) {
            type = parser.next();
        }
        parser.next();
        String name = parser.getText().trim().toLowerCase();
        type = parser.next();
        while (type != 2 || !parser.getName().equals("MSModSpec_monomass")) {
            type = parser.next();
        }
        parser.next();
        String mass = parser.getText().trim();
        type = parser.next();
        ArrayList<String> residues = new ArrayList<String>();
        if (modType.compareTo("modcaa") == 0 || modType.compareTo("modcpaa") == 0 || modType.compareTo("modnaa") == 0 || modType.compareTo("modnpaa") == 0 || modType.compareTo("modaa") == 0) {
            while (type != 2 || !parser.getName().equals("MSModSpec_residues_E")) {
                type = parser.next();
            }
            ArrayList<String> aminoAcids = new ArrayList<String>();
            while (type == 2 && parser.getName().equals("MSModSpec_residues_E")) {
                parser.next();
                aminoAcids.add(parser.getText().trim());
                parser.next();
                parser.next();
                type = parser.next();
            }
            for (String aa : aminoAcids) {
                if (residues.contains(aa)) continue;
                residues.add(aa);
            }
        }
        AminoAcidPattern pattern = new AminoAcidPattern(residues);
        PTM currentPTM = new PTM(this.getIndex(modType), name, (double)new Double(mass), pattern);
        while (!(type == 2 && parser.getName().equals("MSModSpec_neutralloss") || type == 3 && parser.getName().equals("MSModSpec"))) {
            type = parser.next();
        }
        if (parser.getName().equals("MSModSpec_neutralloss")) {
            ArrayList<NeutralLoss> neutralLosses = new ArrayList<NeutralLoss>();
            int cpt = 1;
            while (type != 3 || !parser.getName().equals("MSModSpec_neutralloss")) {
                type = parser.next();
                if (type != 2 || !parser.getName().equals("MSMassSet_monomass")) continue;
                parser.next();
                String doubleString = "";
                try {
                    doubleString = parser.getText().trim();
                    double neutralLossMass = new Double(doubleString);
                    neutralLosses.add(new NeutralLoss(name + " " + cpt, neutralLossMass, true));
                }
                catch (Exception e) {
                    throw new XmlPullParserException("Found non-parseable text '" + doubleString + "' for the value of the 'MSMassSet_monomass' neutral loss tag on line " + parser.getLineNumber() + ".");
                }
                ++cpt;
            }
            currentPTM.setNeutralLosses(neutralLosses);
        }
        while (type != 3 || !parser.getName().equals("MSModSpec")) {
            type = parser.next();
        }
        if (!name.startsWith("user modification ") && !name.equals(unknownPTM.getName())) {
            if (!name.endsWith(SEARCH_SUFFIX)) {
                this.ptmMap.put(name, currentPTM);
            } else {
                name = name.substring(0, name.lastIndexOf(SEARCH_SUFFIX));
            }
            if (userMod) {
                if (this.defaultMods.contains(name)) {
                    if (!name.equalsIgnoreCase("unknown")) {
                        throw new IllegalArgumentException("Impossible to load '" + name + "' as user modification. Already defined as default modification.");
                    }
                    System.out.println("Impossible to load '" + name + "' as user modification. Already defined as default modification.");
                } else if (!this.userMods.contains(name) || overwrite) {
                    this.userMods.add(name);
                    this.usersModsSorted = false;
                }
            } else if (!this.defaultMods.contains(name) || overwrite) {
                this.defaultMods.add(name);
                this.defaultOmssaIndexes.put(name, number);
                this.defaultModsSorted = false;
            }
        }
    }

    private int getIndex(String modType) {
        if (modType.compareTo("modaa") == 0) {
            return 0;
        }
        if (modType.compareTo("modn") == 0) {
            return 1;
        }
        if (modType.compareTo("modnaa") == 0) {
            return 2;
        }
        if (modType.compareTo("modnp") == 0) {
            return 5;
        }
        if (modType.compareTo("modnpaa") == 0) {
            return 6;
        }
        if (modType.compareTo("modc") == 0) {
            return 3;
        }
        if (modType.compareTo("modcaa") == 0) {
            return 4;
        }
        if (modType.compareTo("modcp") == 0) {
            return 7;
        }
        if (modType.compareTo("modcpaa") == 0) {
            return 8;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOmssaModificationsFiles(File aFolder, File utilitiesModFile, File utilitiesUserModFile) throws IOException {
        int c;
        BufferedWriter bw;
        BufferedReader br = new BufferedReader(new FileReader(utilitiesModFile));
        try {
            bw = new BufferedWriter(new FileWriter(new File(aFolder, "mods.xml")));
            try {
                while ((c = br.read()) != -1) {
                    bw.write(c);
                }
            }
            finally {
                bw.close();
            }
        }
        finally {
            br.close();
        }
        br = new BufferedReader(new FileReader(utilitiesUserModFile));
        try {
            bw = new BufferedWriter(new FileWriter(new File(aFolder, "usermods.xml")));
            try {
                while ((c = br.read()) != -1) {
                    bw.write(c);
                }
            }
            finally {
                bw.close();
            }
        }
        finally {
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOmssaUserModificationFile(File file) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        try {
            String toWrite = "<?xml version=\"1.0\"?>\n<MSModSpecSet\nxmlns=\"http://www.ncbi.nlm.nih.gov\"\nxmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\nxs:schemaLocation=\"http://www.ncbi.nlm.nih.gov OMSSA.xsd\"\n>\n\n";
            bw.write(toWrite);
            int cpt = 1;
            for (String ptmName : this.userMods) {
                if (ptmName.equals(unknownPTM.getName())) continue;
                toWrite = this.getOmssaUserModBloc(ptmName, cpt++);
                bw.write(toWrite);
            }
            while (cpt <= 30) {
                int omssaIndex = cpt + 118;
                if (omssaIndex > 128) {
                    omssaIndex += 13;
                }
                toWrite = "\t<MSModSpec>\n\t\t<MSModSpec_mod>\n\t\t\t<MSMod value=\"usermod" + cpt + "\">" + omssaIndex + "</MSMod>\n" + "\t\t</MSModSpec_mod>\n" + "\t\t<MSModSpec_type>\n" + "\t\t\t<MSModType value=\"modaa\">0</MSModType>\n" + "\t\t</MSModSpec_type>\n" + "\t\t<MSModSpec_name>User modification " + cpt + "</MSModSpec_name>\n" + "\t\t<MSModSpec_monomass>0</MSModSpec_monomass>\n" + "\t\t<MSModSpec_averagemass>0</MSModSpec_averagemass>\n" + "\t\t<MSModSpec_n15mass>0</MSModSpec_n15mass>\n" + "\t\t<MSModSpec_residues>\n" + "\t\t\t<MSModSpec_residues_E>X</MSModSpec_residues_E>\n" + "\t\t</MSModSpec_residues>\n" + "\t</MSModSpec>\n";
                bw.write(toWrite);
                ++cpt;
            }
            toWrite = "</MSModSpecSet>";
            bw.write(toWrite);
        }
        finally {
            bw.close();
        }
    }

    public String getOmssaUserModBloc(String ptmName, int cpt) {
        int omssaIndex = cpt + 118;
        if (omssaIndex > 128) {
            omssaIndex += 13;
        }
        PTM ptm = this.getSearchedPTM(ptmName);
        String result = "\t<MSModSpec>\n";
        result = result + "\t\t<MSModSpec_mod>\n";
        result = result + "\t\t\t<MSMod value=\"usermod" + cpt + "\">" + omssaIndex + "</MSMod>\n";
        result = result + "\t\t</MSModSpec_mod>\n\t\t<MSModSpec_type>\n";
        if (ptm.getType() == 0) {
            result = result + "\t\t\t<MSModType value=\"modaa\">0</MSModType>\n";
        } else if (ptm.getType() == 1) {
            result = result + "\t\t\t<MSModType value=\"modn\">1</MSModType>\n";
        } else if (ptm.getType() == 2) {
            result = result + "\t\t\t<MSModType value=\"modnaa\">2</MSModType>\n";
        } else if (ptm.getType() == 5) {
            result = result + "\t\t\t<MSModType value=\"modnp\">5</MSModType>\n";
        } else if (ptm.getType() == 6) {
            result = result + "\t\t\t<MSModType value=\"modnpaa\">6</MSModType>\n";
        } else if (ptm.getType() == 3) {
            result = result + "\t\t\t<MSModType value=\"modc\">3</MSModType>\n";
        } else if (ptm.getType() == 4) {
            result = result + "\t\t\t<MSModType value=\"modcaa\">4</MSModType>\n";
        } else if (ptm.getType() == 7) {
            result = result + "\t\t\t<MSModType value=\"modcp\">7</MSModType>\n";
        } else if (ptm.getType() == 8) {
            result = result + "\t\t\t<MSModType value=\"modcpaa\">8</MSModType>\n";
        }
        result = result + "\t\t</MSModSpec_type>\n";
        result = result + "\t\t<MSModSpec_name>" + ptm.getName() + "</MSModSpec_name>\n";
        result = result + "\t\t<MSModSpec_monomass>" + ptm.getMass() + "</MSModSpec_monomass>\n" + "\t\t<MSModSpec_averagemass>0</MSModSpec_averagemass>\n" + "\t\t<MSModSpec_n15mass>0</MSModSpec_n15mass>\n";
        if (ptm.getType() == 0 || ptm.getType() == 2 || ptm.getType() == 6 || ptm.getType() == 4 || ptm.getType() == 8) {
            result = result + "\t\t<MSModSpec_residues>\n";
            for (Character aa : ptm.getPattern().getAminoAcidsAtTarget()) {
                result = result + "\t\t\t<MSModSpec_residues_E>" + aa + "</MSModSpec_residues_E>\n";
            }
            result = result + "\t\t</MSModSpec_residues>\n";
        }
        boolean first = true;
        for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
            if (!neutralLoss.isFixed()) continue;
            if (first) {
                result = result + "\t\t<MSModSpec_neutralloss>\n";
                first = false;
            }
            result = result + "\t\t\t<MSMassSet>\n";
            result = result + "\t\t\t\t<MSMassSet_monomass>" + neutralLoss.mass + "</MSMassSet_monomass>\n";
            result = result + "\t\t\t\t<MSMassSet_averagemass>0</MSMassSet_averagemass>";
            result = result + "\t\t\t\t<MSMassSet_n15mass>0</MSMassSet_n15mass>";
            result = result + "\t\t\t</MSMassSet>\n";
        }
        if (!first) {
            result = result + "\t\t</MSModSpec_neutralloss>\n";
        }
        result = result + "\t</MSModSpec>\n";
        return result;
    }

    public ArrayList<String> getDefaultModifications() {
        return this.defaultMods;
    }

    public ArrayList<String> getDefaultModificationsOrdered() {
        if (!this.defaultModsSorted) {
            Collections.sort(this.defaultMods);
            this.defaultModsSorted = true;
        }
        return this.defaultMods;
    }

    public ArrayList<String> getUserModifications() {
        return this.userMods;
    }

    public ArrayList<String> getUserModificationsOrdered() {
        if (!this.usersModsSorted) {
            Collections.sort(this.userMods);
            this.usersModsSorted = true;
        }
        return this.userMods;
    }

    public ArrayList<String> getPTMs() {
        return new ArrayList<String>(this.ptmMap.keySet());
    }

    public boolean isUserDefined(String ptmName) {
        return !this.defaultMods.contains(ptmName);
    }

    public ArrayList<String> loadBackedUpModifications(SearchParameters searchParameters, boolean overwrite) {
        ModificationProfile modificationProfile = searchParameters.getModificationProfile();
        ArrayList<String> toCheck = new ArrayList<String>();
        for (String modification : modificationProfile.getBackedUpPtms()) {
            PTM ptm;
            if (this.containsPTM(modification)) {
                PTM newPTM;
                PTM oldPTM = this.getPTM(modification);
                if (!oldPTM.isSameAs(newPTM = modificationProfile.getPtm(modification))) {
                    toCheck.add(modification);
                    if (overwrite) {
                        this.ptmMap.put(modification, modificationProfile.getPtm(modification));
                    }
                }
            } else {
                this.addUserPTM(modificationProfile.getPtm(modification));
            }
            if (this.shortNames.containsKey(modification) || (ptm = modificationProfile.getPtm(modification)).getShortName() == null) continue;
            this.shortNames.put(modification, ptm.getShortName());
        }
        return toCheck;
    }

    public HashMap<Integer, ArrayList<String>> getExpectedPTMs(ModificationProfile modificationProfile, Peptide peptide, double modificationMass, double ptmMassTolerance, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, FileNotFoundException, SQLException {
        HashMap<Integer, ArrayList<String>> mapping = new HashMap<Integer, ArrayList<String>>();
        for (String ptmName : modificationProfile.getAllNotFixedModifications()) {
            PTM ptm = this.getPTM(ptmName);
            if (!(Math.abs(ptm.getMass() - modificationMass) <= ptmMassTolerance)) continue;
            for (int site : peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences)) {
                ArrayList<String> modifications = mapping.get(site);
                if (modifications == null) {
                    modifications = new ArrayList();
                    mapping.put(site, modifications);
                }
                modifications.add(ptmName);
            }
        }
        return mapping;
    }

    public HashMap<Integer, ArrayList<String>> getExpectedPTMs(ModificationProfile modificationProfile, Peptide peptide, String ptmName, Double ptmMassTolerance, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        PTM ptm = this.getPTM(ptmName);
        return this.getExpectedPTMs(modificationProfile, peptide, ptm.getMass(), (double)ptmMassTolerance, sequenceMatchingPreferences);
    }

    public void checkFixedModifications(ModificationProfile modificationProfile, Peptide peptide, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        ArrayList<ModificationMatch> toRemove = new ArrayList<ModificationMatch>();
        for (ModificationMatch modMatch : peptide.getModificationMatches()) {
            if (modMatch.isVariable()) continue;
            toRemove.add(modMatch);
        }
        for (ModificationMatch modMatch : toRemove) {
            peptide.getModificationMatches().remove(modMatch);
        }
        HashMap<Integer, Double> taken = new HashMap<Integer, Double>();
        for (String fixedModification : modificationProfile.getFixedModifications()) {
            String sequence;
            PTM ptm = this.getPTM(fixedModification);
            if (ptm.getType() == 0) {
                for (int pos : peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences)) {
                    if (!taken.containsKey(pos)) {
                        taken.put(pos, ptm.getMass());
                        peptide.addModificationMatch(new ModificationMatch(fixedModification, false, pos));
                        continue;
                    }
                    if (((Double)taken.get(pos)).doubleValue() == ptm.getMass()) continue;
                    throw new IllegalArgumentException("Attempting to put two fixed modifications of different masses (" + taken.get(pos) + ", " + ptm.getMass() + ") at position " + pos + " in peptide " + peptide.getSequence() + ".");
                }
                continue;
            }
            if (ptm.getType() == 3) {
                if (peptide.isCterm(sequenceMatchingPreferences).isEmpty()) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, peptide.getSequence().length()));
                continue;
            }
            if (ptm.getType() == 1) {
                if (peptide.isNterm(sequenceMatchingPreferences).isEmpty()) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                continue;
            }
            if (ptm.getType() == 4) {
                sequence = peptide.getSequence();
                if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(sequence.length())) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, peptide.getSequence().length()));
                continue;
            }
            if (ptm.getType() == 2) {
                if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(1)) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                continue;
            }
            if (ptm.getType() == 7) {
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, peptide.getSequence().length()));
                continue;
            }
            if (ptm.getType() == 5) {
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
                continue;
            }
            if (ptm.getType() == 8) {
                sequence = peptide.getSequence();
                if (!peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(sequence.length())) continue;
                peptide.addModificationMatch(new ModificationMatch(fixedModification, false, sequence.length()));
                continue;
            }
            if (ptm.getType() != 6 || !peptide.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(1)) continue;
            peptide.addModificationMatch(new ModificationMatch(fixedModification, false, 1));
        }
    }

    public void checkFixedModifications(ModificationProfile modificationProfile, Tag tag, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        int indexInTag = 0;
        int componentNumber = 0;
        for (TagComponent tagComponent : tag.getContent()) {
            ++componentNumber;
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                ArrayList<ModificationMatch> toRemove = new ArrayList<ModificationMatch>();
                for (int aa : aminoAcidPattern.getModificationIndexes()) {
                    ArrayList<ModificationMatch> modificationMatches = aminoAcidPattern.getModificationsAt(aa);
                    for (ModificationMatch modMatch : modificationMatches) {
                        if (modMatch.isVariable()) continue;
                        toRemove.add(modMatch);
                    }
                    for (ModificationMatch modMatch : toRemove) {
                        aminoAcidPattern.removeModificationMatch(aa, modMatch);
                    }
                }
                for (int aa = 1; aa <= aminoAcidPattern.length(); ++aa) {
                    ++indexInTag;
                    Double modification = null;
                    for (String fixedModification : modificationProfile.getFixedModifications()) {
                        PTM ptm = this.getPTM(fixedModification);
                        if (ptm.getType() == 0) {
                            if (!tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(indexInTag)) continue;
                            if (modification == null) {
                                modification = ptm.getMass();
                                aminoAcidPattern.addModificationMatch(aa, new ModificationMatch(fixedModification, false, aa));
                                continue;
                            }
                            if (modification.doubleValue() == ptm.getMass()) continue;
                            throw new IllegalArgumentException("Attempting to put two fixed modifications of different masses (" + modification + ", " + ptm.getMass() + ") at position " + aa + " in pattern " + aminoAcidPattern.asSequence() + " of tag " + tag.asSequence() + ".");
                        }
                        if (ptm.getType() == 7 && componentNumber == tag.getContent().size() && aa == aminoAcidPattern.length()) {
                            aminoAcidPattern.addModificationMatch(aa, new ModificationMatch(fixedModification, false, aa));
                            continue;
                        }
                        if (ptm.getType() == 5 && componentNumber == 1 && aa == 1) {
                            aminoAcidPattern.addModificationMatch(1, new ModificationMatch(fixedModification, false, 1));
                            continue;
                        }
                        if (ptm.getType() == 8 && componentNumber == tag.getContent().size() && aa == aminoAcidPattern.length()) {
                            if (!tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(indexInTag)) continue;
                            aminoAcidPattern.addModificationMatch(aa, new ModificationMatch(fixedModification, false, aa));
                            continue;
                        }
                        if (ptm.getType() != 6 || componentNumber != 1 || aa != 1 || !tag.getPotentialModificationSites(ptm, sequenceMatchingPreferences).contains(1)) continue;
                        aminoAcidPattern.addModificationMatch(1, new ModificationMatch(fixedModification, false, 1));
                    }
                }
                continue;
            }
            ++indexInTag;
        }
    }

    public void setSearchedOMSSAIndexes(ModificationProfile modificationProfile) {
        for (int rank = 1; rank <= this.userMods.size(); ++rank) {
            String ptm;
            int omssaIndex = rank + 118;
            if (omssaIndex > 128) {
                omssaIndex += 13;
            }
            if (!modificationProfile.contains(ptm = this.userMods.get(rank - 1))) continue;
            modificationProfile.setOmssaIndex(ptm, omssaIndex);
        }
        for (String ptm : this.defaultOmssaIndexes.keySet()) {
            if (!modificationProfile.contains(ptm)) continue;
            modificationProfile.setOmssaIndex(ptm, this.defaultOmssaIndexes.get(ptm));
        }
    }

    public void setDefaultNeutralLosses() {
        boolean changed = false;
        for (String ptmName : this.defaultMods) {
            boolean found;
            PTM ptm;
            if (ptmName.contains("phospho")) {
                ptm = this.ptmMap.get(ptmName);
                if (ptmName.contains(" s") || ptmName.contains(" t")) {
                    found = false;
                    for (NeutralLoss implemented : ptm.getNeutralLosses()) {
                        if (!implemented.isSameAs(NeutralLoss.H3PO4)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ptm.addNeutralLoss(NeutralLoss.H3PO4);
                    }
                }
                if (ptmName.contains(" y")) {
                    found = false;
                    for (NeutralLoss implemented : ptm.getNeutralLosses()) {
                        if (!implemented.isSameAs(NeutralLoss.HPO3)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ptm.addNeutralLoss(NeutralLoss.HPO3);
                    }
                }
            } else if (ptmName.contains("oxidation") && ptmName.contains("M")) {
                ptm = this.ptmMap.get(ptmName);
                found = false;
                for (NeutralLoss implemented : ptm.getNeutralLosses()) {
                    if (!implemented.isSameAs(NeutralLoss.CH4OS)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ptm.addNeutralLoss(NeutralLoss.CH4OS);
                }
            }
            if (!changed) continue;
            try {
                this.saveFactory();
            }
            catch (IOException e) {}
        }
    }

    public void setDefaultReporterIons() {
        boolean tempChange;
        boolean changed = false;
        for (String ptmName : this.userMods) {
            tempChange = this.addDefaultReporterIons(ptmName);
            if (!tempChange) continue;
            changed = true;
        }
        for (String ptmName : this.defaultMods) {
            tempChange = this.addDefaultReporterIons(ptmName);
            if (!tempChange) continue;
            changed = true;
        }
        if (changed) {
            try {
                this.saveFactory();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean addDefaultReporterIons(String ptmName) {
        PTM ptm;
        boolean changed = false;
        if (ptmName.contains("itraq")) {
            PTM ptm2 = this.ptmMap.get(ptmName);
            if (ptm2.getReporterIons().isEmpty()) {
                ptm2.addReporterIon(ReporterIon.iTRAQ114);
                ptm2.addReporterIon(ReporterIon.iTRAQ115);
                ptm2.addReporterIon(ReporterIon.iTRAQ116);
                ptm2.addReporterIon(ReporterIon.iTRAQ117);
                if (ptmName.contains("8")) {
                    ptm2.addReporterIon(ReporterIon.iTRAQ113);
                    ptm2.addReporterIon(ReporterIon.iTRAQ118);
                    ptm2.addReporterIon(ReporterIon.iTRAQ119);
                    ptm2.addReporterIon(ReporterIon.iTRAQ121);
                    ptm2.addReporterIon(ReporterIon.iTRAQ_305);
                } else {
                    ptm2.addReporterIon(ReporterIon.iTRAQ_145);
                }
                changed = true;
            }
        } else if (ptmName.contains("tmt")) {
            PTM ptm3 = this.ptmMap.get(ptmName);
            if (ptm3.getReporterIons().isEmpty()) {
                if (ptmName.contains("old")) {
                    ptm3.addReporterIon(ReporterIon.TMT126_old);
                    ptm3.addReporterIon(ReporterIon.TMT127_old);
                    if (ptmName.contains("6")) {
                        ptm3.addReporterIon(ReporterIon.TMT128_old);
                        ptm3.addReporterIon(ReporterIon.TMT129_old);
                        ptm3.addReporterIon(ReporterIon.TMT130_old);
                        ptm3.addReporterIon(ReporterIon.TMT131_old);
                        ptm3.addReporterIon(ReporterIon.TMT_230);
                    } else {
                        ptm3.addReporterIon(ReporterIon.TMT_226);
                    }
                } else if (ptmName.contains("duplex")) {
                    ptm3.addReporterIon(ReporterIon.TMT126_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT126_etd);
                    ptm3.addReporterIon(ReporterIon.TMT127_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT127_etd);
                    ptm3.addReporterIon(ReporterIon.TMT_226);
                } else if (ptmName.contains("6")) {
                    ptm3.addReporterIon(ReporterIon.TMT126_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT126_etd);
                    ptm3.addReporterIon(ReporterIon.TMT127_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT127_etd);
                    ptm3.addReporterIon(ReporterIon.TMT128_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT128_etd);
                    ptm3.addReporterIon(ReporterIon.TMT129_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT129_etd);
                    ptm3.addReporterIon(ReporterIon.TMT130_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT130_etd);
                    ptm3.addReporterIon(ReporterIon.TMT131_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT131_etd);
                    ptm3.addReporterIon(ReporterIon.TMT_230);
                } else if (ptmName.contains("10")) {
                    ptm3.addReporterIon(ReporterIon.TMT126_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT127N_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT127C_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT128N_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT128C_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT129N_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT129C_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT130N_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT130C_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT131_hcd);
                    ptm3.addReporterIon(ReporterIon.TMT_230);
                }
                changed = true;
            }
        } else if (ptmName.contains("acetylation of k")) {
            PTM ptm4 = this.ptmMap.get(ptmName);
            if (ptm4.getReporterIons().isEmpty()) {
                ptm4.addReporterIon(ReporterIon.ACE_K_126);
                ptm4.addReporterIon(ReporterIon.ACE_K_143);
                changed = true;
            }
        } else if (ptmName.contains("phosphorylation of y") && (ptm = this.ptmMap.get(ptmName)).getReporterIons().isEmpty()) {
            ptm.addReporterIon(ReporterIon.PHOSPHO_Y);
            changed = true;
        }
        return changed;
    }

    public void setShortName(String modification, String shortName) {
        this.shortNames.put(modification, shortName);
    }

    public String getShortName(String modification) {
        if (this.shortNames.containsKey(modification)) {
            return this.shortNames.get(modification);
        }
        PTM ptm = this.getPTM(modification);
        if (ptm.getShortName() != null) {
            return ptm.getShortName();
        }
        return PTMFactory.getDefaultShortName(modification);
    }

    public static String getDefaultShortName(String modificationName) {
        if (modificationName.contains("oxidation")) {
            return "ox";
        }
        if (modificationName.contains("phospho")) {
            return "p";
        }
        if (modificationName.contains("sulfation")) {
            return "sulf";
        }
        if (modificationName.contains("acetylation")) {
            return "ace";
        }
        if (modificationName.contains("deamidation")) {
            return "deam";
        }
        if (modificationName.contains("itraq")) {
            return "iTRAQ";
        }
        if (modificationName.contains("icat")) {
            return "icat";
        }
        if (modificationName.contains("heavy arginine")) {
            return "heavyR";
        }
        if (modificationName.contains("heavy lysine")) {
            return "heavyK";
        }
        if (modificationName.contains("o18")) {
            return "o18";
        }
        if (modificationName.contains("tmt")) {
            return "tmt";
        }
        if (modificationName.contains("carbamidomethyl")) {
            return "cmm";
        }
        if (modificationName.contains("di-methylation") || modificationName.contains("dimethylation")) {
            return "dimeth";
        }
        if (modificationName.contains("tri-methylation") || modificationName.contains("trimethylation")) {
            return "trimeth";
        }
        if (modificationName.contains("methylation")) {
            return "meth";
        }
        if (modificationName.contains("pyro")) {
            return "pyro";
        }
        String result = modificationName;
        if (result.contains(" ")) {
            result = result.substring(0, result.indexOf(" "));
        }
        return result;
    }

    public Color getColor(String modification) {
        if (!this.userColors.containsKey(modification)) {
            this.setColor(modification, PTMFactory.getDefaultColor(modification));
        }
        return this.userColors.get(modification);
    }

    public void setColor(String expectedModification, Color color) {
        this.userColors.put(expectedModification, color);
    }

    public static Color getDefaultColor(String modification) {
        if (modification.contains("no modification")) {
            return Color.LIGHT_GRAY;
        }
        if (modification.contains("phospho")) {
            return Color.RED;
        }
        if (modification.contains("ox")) {
            return Color.BLUE;
        }
        if (modification.contains("itraq")) {
            return Color.magenta;
        }
        if (modification.contains("carbamido")) {
            return Color.LIGHT_GRAY;
        }
        if (modification.contains("ace")) {
            return new Color(153, 153, 0);
        }
        if (modification.contains("glyco")) {
            return Color.ORANGE;
        }
        float r = (float)Math.random();
        float g = (float)Math.random();
        float b = (float)Math.random();
        return new Color(r, g, b);
    }

    public String convertPridePtm(String pridePtmName, ModificationProfile modProfile, ArrayList<String> unknownPtms, boolean isFixed) {
        String prideParametersReport = "";
        if (pridePtmName.equalsIgnoreCase("iTRAQ4plex") || pridePtmName.equalsIgnoreCase("iTRAQ4plex reporter+balance reagent N-acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ4plex reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-114 reporter+balance reagent N6-acylated lysine") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-114 reporter+balance reagent O4&apos;-acylated tyrosine") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-114 reporter+balance reagent acylated N-terminal") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-114 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-116 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ4plex-117 reporter+balance reagent N6-acylated lysine")) {
            if (!modProfile.contains("itraq114 on k")) {
                modProfile.addFixedModification(this.getPTM("itraq114 on k"));
                prideParametersReport = prideParametersReport + "<br>itraq114 on k (assumed fixed)";
            }
            if (!modProfile.contains("itraq114 on nterm")) {
                modProfile.addFixedModification(this.getPTM("itraq114 on nterm"));
                prideParametersReport = prideParametersReport + "<br>itraq114 on nterm (assumed fixed)";
            }
            if (!modProfile.contains("itraq114 on y")) {
                modProfile.addVariableModification(this.getPTM("itraq114 on y"));
                prideParametersReport = prideParametersReport + "<br>itraq114 on y (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("iTRAQ8plex") || pridePtmName.equalsIgnoreCase("iTRAQ8plex reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-113 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-114 reporter+balance reagent N6-acylated lysine") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-114 reporter+balance reagent O4&apos;-acylated tyrosine") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-114 reporter+balance reagent acylated N-terminal") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-115 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ8plex-116 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("iTRAQ8plex:13C(6)15N(2)")) {
            if (!modProfile.contains("itraq8plex:13c(6)15n(2) on k")) {
                modProfile.addFixedModification(this.getPTM("itraq8plex:13c(6)15n(2) on k"));
                prideParametersReport = prideParametersReport + "<br>itraq8plex:13c(6)15n(2) on k (assumed fixed)";
            }
            if (!modProfile.contains("itraq8plex:13c(6)15n(2) on nterm")) {
                modProfile.addFixedModification(this.getPTM("itraq8plex:13c(6)15n(2) on nterm"));
                prideParametersReport = prideParametersReport + "<br>itraq8plex:13c(6)15n(2) on nterm (assumed fixed)";
            }
            if (!modProfile.contains("itraq8plex:13c(6)15n(2) on y")) {
                modProfile.addVariableModification(this.getPTM("itraq8plex:13c(6)15n(2) on y"));
                prideParametersReport = prideParametersReport + "<br>itraq8plex:13c(6)15n(2) on y (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("TMT2plex") || pridePtmName.equalsIgnoreCase("TMTduplex")) {
            if (!modProfile.contains("tmt duplex on k")) {
                modProfile.addFixedModification(this.getPTM("tmt duplex on k"));
                prideParametersReport = prideParametersReport + "<br>tmt duplex on k (assumed fixed)";
            }
            if (!modProfile.contains("tmt duplex on n-term peptide")) {
                modProfile.addFixedModification(this.getPTM("tmt duplex on n-term peptide"));
                prideParametersReport = prideParametersReport + "<br>tmt duplex on n-term peptide (assumed fixed)";
            }
        } else if (pridePtmName.equalsIgnoreCase("TMT6plex") || pridePtmName.equalsIgnoreCase("TMT6plex-126 reporter+balance reagent acylated residue") || pridePtmName.equalsIgnoreCase("TMT6plex-131 reporter+balance reagent N6-acylated lysine")) {
            if (!modProfile.contains("tmt 6-plex on k")) {
                modProfile.addFixedModification(this.getPTM("tmt 6-plex on k"));
                prideParametersReport = prideParametersReport + "<br>tmt 6-plex on k (assumed fixed)";
            }
            if (!modProfile.contains("tmt 6-plex on n-term peptide")) {
                modProfile.addFixedModification(this.getPTM("tmt 6-plex on n-term peptide"));
                prideParametersReport = prideParametersReport + "<br>tmt 6-plex on n-term peptide (assumed fixed)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Phosphorylation") || pridePtmName.equalsIgnoreCase("L-aspartic 4-phosphoric anhydride") || pridePtmName.equalsIgnoreCase("O-phosphorylated residue") || pridePtmName.equalsIgnoreCase("Phospho") || pridePtmName.equalsIgnoreCase("phosphorylated residue")) {
            if (!modProfile.contains("phosphorylation of s")) {
                modProfile.addVariableModification(this.getPTM("phosphorylation of s"));
                prideParametersReport = prideParametersReport + "<br>phosphorylation of s (assumed variable)";
            }
            if (!modProfile.contains("phosphorylation of t")) {
                modProfile.addVariableModification(this.getPTM("phosphorylation of t"));
                prideParametersReport = prideParametersReport + "<br>phosphorylation of t (assumed variable)";
            }
            if (!modProfile.contains("phosphorylation of y")) {
                modProfile.addVariableModification(this.getPTM("phosphorylation of y"));
                prideParametersReport = prideParametersReport + "<br>phosphorylation of y (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Palmitoylation")) {
            if (!modProfile.contains("palmitoylation of c")) {
                modProfile.addVariableModification(this.getPTM("palmitoylation of c"));
                prideParametersReport = prideParametersReport + "<br>palmitoylation of c (assumed variable)";
            }
            if (!modProfile.contains("palmitoylation of k")) {
                modProfile.addVariableModification(this.getPTM("palmitoylation of k"));
                prideParametersReport = prideParametersReport + "<br>palmitoylation of k (assumed variable)";
            }
            if (!modProfile.contains("palmitoylation of s")) {
                modProfile.addVariableModification(this.getPTM("palmitoylation of s"));
                prideParametersReport = prideParametersReport + "<br>palmitoylation of s (assumed variable)";
            }
            if (!modProfile.contains("palmitoylation of t")) {
                modProfile.addVariableModification(this.getPTM("palmitoylation of t"));
                prideParametersReport = prideParametersReport + "<br>palmitoylation of t (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Formylation")) {
            if (!modProfile.contains("formylation of k")) {
                modProfile.addVariableModification(this.getPTM("formylation of k"));
                prideParametersReport = prideParametersReport + "<br>formylation of k (assumed variable)";
            }
            if (!modProfile.contains("formylation of peptide n-term")) {
                modProfile.addVariableModification(this.getPTM("formylation of peptide n-term"));
                prideParametersReport = prideParametersReport + "<br>formylation of peptide n-term (assumed variable)";
            }
            if (!modProfile.contains("formylation of protein c-term")) {
                modProfile.addVariableModification(this.getPTM("formylation of protein c-term"));
                prideParametersReport = prideParametersReport + "<br>formylation of protein c-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Carbamylation")) {
            if (!modProfile.contains("carbamylation of k")) {
                modProfile.addVariableModification(this.getPTM("carbamylation of k"));
                prideParametersReport = prideParametersReport + "<br>carbamylation of k (assumed variable)";
            }
            if (!modProfile.contains("carbamylation of n-term peptide")) {
                modProfile.addVariableModification(this.getPTM("carbamylation of n-term peptide"));
                prideParametersReport = prideParametersReport + "<br>carbamylation of n-term peptide (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("3x(12)C labeled N6-propanoyl-L-lysine")) {
            if (!modProfile.contains("propionyl light k")) {
                modProfile.addVariableModification(this.getPTM("propionyl light k"));
                prideParametersReport = prideParametersReport + "<br>propionyl light k (assumed variable)";
            }
            if (!modProfile.contains("propionyl light on peptide n-term")) {
                modProfile.addVariableModification(this.getPTM("propionyl light on peptide n-term"));
                prideParametersReport = prideParametersReport + "<br>propionyl light on peptide n-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("3x(13)C labeled N6-propanoyl-L-lysine")) {
            if (!modProfile.contains("propionyl heavy k")) {
                modProfile.addVariableModification(this.getPTM("propionyl heavy k"));
                prideParametersReport = prideParametersReport + "<br>propionyl heavy k (assumed variable)";
            }
            if (!modProfile.contains("propionyl heavy peptide n-term")) {
                modProfile.addVariableModification(this.getPTM("propionyl heavy peptide n-term"));
                prideParametersReport = prideParametersReport + "<br>propionyl heavy peptide n-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("3x(2)H residue methyl ester")) {
            if (!modProfile.contains("tri-deuteromethylation of d")) {
                modProfile.addVariableModification(this.getPTM("tri-deuteromethylation of d"));
                prideParametersReport = prideParametersReport + "<br>tri-deuteromethylation of d (assumed variable)";
            }
            if (!modProfile.contains("tri-deuteromethylation of e")) {
                modProfile.addVariableModification(this.getPTM("tri-deuteromethylation of e"));
                prideParametersReport = prideParametersReport + "<br>tri-deuteromethylation of e (assumed variable)";
            }
            if (!modProfile.contains("tri-deuteromethylation of peptide c-term")) {
                modProfile.addVariableModification(this.getPTM("tri-deuteromethylation of peptide c-term"));
                prideParametersReport = prideParametersReport + "<br>tri-deuteromethylation of peptide c-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("6x(13)C labeled residue")) {
            if (!modProfile.contains("heavy arginine-13C6")) {
                modProfile.addVariableModification(this.getPTM("heavy arginine-13C6"));
                prideParametersReport = prideParametersReport + "<br>heavy arginine-13C6 (assumed variable)";
            }
            if (!modProfile.contains("heavy lysine-13C6")) {
                modProfile.addVariableModification(this.getPTM("heavy lysine-13C6"));
                prideParametersReport = prideParametersReport + "<br>heavy lysine-13C6 (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("Acetyl") || pridePtmName.equalsIgnoreCase("N-acetylated residue") || pridePtmName.equalsIgnoreCase("N-acylated residue") || pridePtmName.equalsIgnoreCase("acetylated residue")) {
            if (!modProfile.contains("acetylation of k")) {
                modProfile.addVariableModification(this.getPTM("acetylation of k"));
                prideParametersReport = prideParametersReport + "<br>acetylation of k (assumed variable)";
            }
            if (!modProfile.contains("acetylation of protein n-term")) {
                modProfile.addVariableModification(this.getPTM("acetylation of protein n-term"));
                prideParametersReport = prideParametersReport + "<br>acetylation of protein n-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("carbamoylated residue")) {
            if (!modProfile.contains("carbamylation of k")) {
                modProfile.addVariableModification(this.getPTM("carbamylation of k"));
                prideParametersReport = prideParametersReport + "<br>carbamylation of k (assumed variable)";
            }
            if (!modProfile.contains("carbamylation of n-term peptide")) {
                modProfile.addVariableModification(this.getPTM("carbamylation of n-term peptide"));
                prideParametersReport = prideParametersReport + "<br>carbamylation of n-term peptide (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("dimethylated residue")) {
            if (!modProfile.contains("di-methylation of k")) {
                modProfile.addVariableModification(this.getPTM("di-methylation of k"));
                prideParametersReport = prideParametersReport + "<br>di-methylation of k (assumed variable)";
            }
            if (!modProfile.contains("di-methylation of r")) {
                modProfile.addVariableModification(this.getPTM("di-methylation of r"));
                prideParametersReport = prideParametersReport + "<br>di-methylation of r (assumed variable)";
            }
            if (!modProfile.contains("di-methylation of peptide n-term")) {
                modProfile.addVariableModification(this.getPTM("di-methylation of peptide n-term"));
                prideParametersReport = prideParametersReport + "<br>di-methylation of peptide n-term (assumed variable)";
            }
        } else if (pridePtmName.equalsIgnoreCase("trimethylated residue")) {
            if (!modProfile.contains("tri-methylation of k")) {
                modProfile.addVariableModification(this.getPTM("tri-methylation of k"));
                prideParametersReport = prideParametersReport + "<br>tri-methylation of k (assumed variable)";
            }
            if (!modProfile.contains("tri-methylation of r")) {
                modProfile.addVariableModification(this.getPTM("tri-methylation of r"));
                prideParametersReport = prideParametersReport + "<br>tri-methylation of r (assumed variable)";
            }
            if (!modProfile.contains("tri-methylation of protein n-term")) {
                modProfile.addVariableModification(this.getPTM("tri-methylation of protein n-term"));
                prideParametersReport = prideParametersReport + "<br>tri-methylation of protein n-term (assumed variable)";
            }
        } else if (!pridePtmName.equalsIgnoreCase("No PTMs are included in the dataset")) {
            String utilitiesPtmName = this.convertPridePtmToUtilitiesPtm(pridePtmName);
            if (utilitiesPtmName != null) {
                if (!modProfile.contains(utilitiesPtmName)) {
                    if (isFixed) {
                        modProfile.addFixedModification(this.getPTM(utilitiesPtmName));
                        prideParametersReport = prideParametersReport + "<br>" + utilitiesPtmName + " (assumed fixed)";
                    } else {
                        modProfile.addVariableModification(this.getPTM(utilitiesPtmName));
                        prideParametersReport = prideParametersReport + "<br>" + utilitiesPtmName + " (assumed variable)";
                    }
                }
            } else if (!unknownPtms.contains(pridePtmName)) {
                unknownPtms.add(pridePtmName);
            }
        }
        return prideParametersReport;
    }

    private String convertPridePtmToUtilitiesPtm(String pridePtmName) {
        if (pridePtmName.equalsIgnoreCase("Carbamidomethyl") || pridePtmName.equalsIgnoreCase("S-carboxamidomethyl-L-cysteine") || pridePtmName.equalsIgnoreCase("iodoacetamide - site C") || pridePtmName.equalsIgnoreCase("iodoacetamide derivatized residue") || pridePtmName.equalsIgnoreCase("Iodoacetamide derivative")) {
            return "carbamidomethyl c";
        }
        if (pridePtmName.equalsIgnoreCase("Oxidation") || pridePtmName.equalsIgnoreCase("monohydroxylated residue") || pridePtmName.equalsIgnoreCase("oxidized residue")) {
            return "oxidation of m";
        }
        if (pridePtmName.equalsIgnoreCase("Acetylation")) {
            return "acetylation of k";
        }
        if (pridePtmName.equalsIgnoreCase("Amidation")) {
            return "amidation of peptide c-term";
        }
        if (pridePtmName.equalsIgnoreCase("Carboxymethyl") || pridePtmName.equalsIgnoreCase("S-carboxymethyl-L-cysteine") || pridePtmName.equalsIgnoreCase("iodoacetic acid derivatized residue")) {
            return "carboxymethyl c";
        }
        if (pridePtmName.equalsIgnoreCase("Farnesylation")) {
            return "farnesylation of c";
        }
        if (pridePtmName.equalsIgnoreCase("Geranyl-geranyl")) {
            return "geranyl-geranyl";
        }
        if (pridePtmName.equalsIgnoreCase("Guanidination")) {
            return "guanidination of k";
        }
        if (pridePtmName.equalsIgnoreCase("Homoserine")) {
            return "homoserine";
        }
        if (pridePtmName.equalsIgnoreCase("Homoserine lactone")) {
            return "homoserine lactone";
        }
        if (pridePtmName.equalsIgnoreCase("ICAT-C") || pridePtmName.equalsIgnoreCase("Applied Biosystems cleavable ICAT(TM) light")) {
            return "icat light";
        }
        if (pridePtmName.equalsIgnoreCase("ICAT-C:13C(9)") || pridePtmName.equalsIgnoreCase("Applied Biosystems cleavable ICAT(TM) heavy")) {
            return "icat heavy";
        }
        if (pridePtmName.equalsIgnoreCase("Lipoyl")) {
            return "lipoyl k";
        }
        if (pridePtmName.equalsIgnoreCase("Methylthio")) {
            return "beta-methylthiolation of d (duplicate of 13)";
        }
        if (pridePtmName.equalsIgnoreCase("NIPCAM(C)")) {
            return "nipcam";
        }
        if (pridePtmName.equalsIgnoreCase("Phosphopantetheine")) {
            return "phosphopantetheine s";
        }
        if (pridePtmName.equalsIgnoreCase("Propionamide(C)") || pridePtmName.equalsIgnoreCase("Acrylamide adduct")) {
            return "propionamide c";
        }
        if (pridePtmName.equalsIgnoreCase("Pyridylethyl")) {
            return "s-pyridylethylation of c";
        }
        if (pridePtmName.equalsIgnoreCase("Pyridylethyl")) {
            return "s-pyridylethylation of c";
        }
        if (pridePtmName.equalsIgnoreCase("Sulfo") || pridePtmName.equalsIgnoreCase("sulfated residue")) {
            return "sulfation of y";
        }
        if (pridePtmName.equalsIgnoreCase("Dehydratation")) {
            return "dehydro of s and t";
        }
        if (pridePtmName.equalsIgnoreCase("Deamination") || pridePtmName.equalsIgnoreCase("Deamidated") || pridePtmName.equalsIgnoreCase("deamidated L-glutamine") || pridePtmName.equalsIgnoreCase("deamidated residue") || pridePtmName.equalsIgnoreCase("deaminated residue")) {
            return "deamidation of n and q";
        }
        if (pridePtmName.equalsIgnoreCase("Dioxidation")) {
            return "sulphone of m";
        }
        if (pridePtmName.equalsIgnoreCase("(18)O label at both C-terminal oxygens")) {
            return "di-o18 on peptide n-term";
        }
        if (pridePtmName.equalsIgnoreCase("(18)O monosubstituted residue")) {
            return "o18 on peptide n-term";
        }
        if (pridePtmName.equalsIgnoreCase("(4,4,5,5-(2)H4)-L-lysine")) {
            return "heavy lysine - 2h4";
        }
        if (pridePtmName.equalsIgnoreCase("2-pyrrolidone-5-carboxylic acid (Gln)") || pridePtmName.equalsIgnoreCase("Ammonia-loss")) {
            return "pyro-glu from n-term q";
        }
        if (pridePtmName.equalsIgnoreCase("2-pyrrolidone-5-carboxylic acid (Glu)") || pridePtmName.equalsIgnoreCase("Glu->pyro-Glu")) {
            return "pyro-glu from n-term e";
        }
        if (pridePtmName.equalsIgnoreCase("3-hydroxy-L-proline")) {
            return "hydroxylation of p";
        }
        if (pridePtmName.equalsIgnoreCase("3x(2)H labeled L-aspartic acid 4-methyl ester")) {
            return "tri-deuteromethylation of d";
        }
        if (pridePtmName.equalsIgnoreCase("4x(2)H labeled alpha-dimethylamino N-terminal residue")) {
            return "chd2-di-methylation of peptide n-term";
        }
        if (pridePtmName.equalsIgnoreCase("4x(2)H labeled dimethylated L-lysine")) {
            return "chd2-di-methylation of k";
        }
        if (pridePtmName.equalsIgnoreCase("5-methyl-L-arginine")) {
            return "methyl r";
        }
        if (pridePtmName.equalsIgnoreCase("6x(13)C labeled L-arginine") || pridePtmName.equalsIgnoreCase("6x(13)C,4x(15)N labeled L-arginine")) {
            return "heavy arginine-13C6";
        }
        if (pridePtmName.equalsIgnoreCase("6x(13)C labeled L-lysine") || pridePtmName.equalsIgnoreCase("6x(13)C,2x(15)N labeled L-lysine")) {
            return "heavy lysine-13C6";
        }
        if (pridePtmName.equalsIgnoreCase("L-aspartic acid 4-methyl ester")) {
            return "methyl ester of d";
        }
        if (pridePtmName.equalsIgnoreCase("L-cysteic acid (L-cysteine sulfonic acid)")) {
            return "oxidation of C to cysteic acid";
        }
        if (pridePtmName.equalsIgnoreCase("L-cysteine glutathione disulfide")) {
            return "glutathione disulfide";
        }
        if (pridePtmName.equalsIgnoreCase("L-cysteine methyl disulfide") || pridePtmName.equalsIgnoreCase("methyl methanethiosulfonate")) {
            return "mmts on c";
        }
        if (pridePtmName.equalsIgnoreCase("L-cystine (cross-link)")) {
            return "2-amino-3-oxo-butanoic acid t";
        }
        if (pridePtmName.equalsIgnoreCase("L-glutamic acid 5-methyl ester (Glu)") || pridePtmName.equalsIgnoreCase("methylated glutamic acid")) {
            return "methylation of e";
        }
        if (pridePtmName.equalsIgnoreCase("L-homoarginine")) {
            return "guanidination of k";
        }
        if (pridePtmName.equalsIgnoreCase("L-methionine (R)-sulfoxide") || pridePtmName.equalsIgnoreCase("L-methionine (S)-sulfoxide") || pridePtmName.equalsIgnoreCase("L-methionine sulfoxide")) {
            return "oxidation of m";
        }
        if (pridePtmName.equalsIgnoreCase("L-methionine sulfone")) {
            return "sulphone of m";
        }
        if (pridePtmName.equalsIgnoreCase("N-acetyl-L-asparagine") || pridePtmName.equalsIgnoreCase("N-acetyl-L-cysteine") || pridePtmName.equalsIgnoreCase("N-acetyl-L-glutamic acid") || pridePtmName.equalsIgnoreCase("N-acetyl-L-isoleucine") || pridePtmName.equalsIgnoreCase("N-acetyl-L-serine") || pridePtmName.equalsIgnoreCase("N-acetyl-L-tyrosine")) {
            return "acetylation of protein n-term";
        }
        if (pridePtmName.equalsIgnoreCase("N-acetylated L-lysine") || pridePtmName.equalsIgnoreCase("N6-acetyl-L-lysine")) {
            return "acetylation of k";
        }
        if (pridePtmName.equalsIgnoreCase("N-ethylmaleimide derivatized cysteine")) {
            return "nem c";
        }
        if (pridePtmName.equalsIgnoreCase("N-formyl-L-methionine")) {
            return "n-formyl met addition";
        }
        if (pridePtmName.equalsIgnoreCase("N-formylated residue")) {
            return "formylation of peptide n-term";
        }
        if (pridePtmName.equalsIgnoreCase("N-methyl-L-serine")) {
            return "methyl ester of s";
        }
        if (pridePtmName.equalsIgnoreCase("N2-acetyl-L-tryptophan")) {
            return "acetylation of protein n-term";
        }
        if (pridePtmName.equalsIgnoreCase("N6,N6-dimethyl-L-lysine")) {
            return "di-methylation of k";
        }
        if (pridePtmName.equalsIgnoreCase("N6-formyl-L-lysine")) {
            return "formylation of k";
        }
        if (pridePtmName.equalsIgnoreCase("N6-methyl-L-lysine") || pridePtmName.equalsIgnoreCase("methylated lysine") || pridePtmName.equalsIgnoreCase("monomethylated L-lysine")) {
            return "methylation of k";
        }
        if (pridePtmName.equalsIgnoreCase("N6-propanoyl-L-lysine")) {
            return "propionyl light k";
        }
        if (pridePtmName.equalsIgnoreCase("O-(N-acetylamino)glucosyl-L-serine")) {
            return "serine hexnac";
        }
        if (pridePtmName.equalsIgnoreCase("O-(N-acetylamino)glucosyl-L-threonine")) {
            return "threonine hexnac";
        }
        if (pridePtmName.equalsIgnoreCase("O-phospho-L-serine")) {
            return "phosphorylation of s";
        }
        if (pridePtmName.equalsIgnoreCase("O-phospho-L-threonine")) {
            return "phosphorylation of t";
        }
        if (pridePtmName.equalsIgnoreCase("O4&apos;-phospho-L-tyrosine")) {
            return "phosphorylation of y";
        }
        if (pridePtmName.equalsIgnoreCase("S-carboxamidoethyl-L-cysteine")) {
            return "propionamide c";
        }
        if (pridePtmName.equalsIgnoreCase("S-methyl-L-cysteine")) {
            return "methyl c";
        }
        if (pridePtmName.equalsIgnoreCase("alpha-amino acetylated residue")) {
            return "acetylation of protein n-term";
        }
        if (pridePtmName.equalsIgnoreCase("alpha-amino dimethylated residue")) {
            return "di-methylation of peptide n-term";
        }
        if (pridePtmName.equalsIgnoreCase("amidated residue")) {
            return "amidation of peptide c-term";
        }
        if (pridePtmName.equalsIgnoreCase("deamidated L-asparagine") || pridePtmName.equalsIgnoreCase("deglycosylated asparagine")) {
            return "deamidation of n";
        }
        if (pridePtmName.equalsIgnoreCase("dehydrated residue")) {
            return "dehydro of s and t";
        }
        if (pridePtmName.equalsIgnoreCase("dihydroxylated residue - site W")) {
            return "oxidation of w to formylkynurenin";
        }
        if (pridePtmName.equalsIgnoreCase("diiodinated residue")) {
            return "di-iodination of y";
        }
        if (pridePtmName.equalsIgnoreCase("hydroxylated lysine") || pridePtmName.equalsIgnoreCase("monohydroxylated lysine")) {
            return "hydroxylation of k";
        }
        if (pridePtmName.equalsIgnoreCase("iodoacetamide -site E")) {
            return "carboxyamidomethylation of e";
        }
        if (pridePtmName.equalsIgnoreCase("iodoacetamide N6-derivatized lysine")) {
            return "carboxyamidomethylation of k";
        }
        if (pridePtmName.equalsIgnoreCase("monomethylated L-aspartic acid")) {
            return "methylation of d";
        }
        if (pridePtmName.equalsIgnoreCase("thioacylation of primary amines - site N-term")) {
            return "gammathiopropionylation of peptide n-term";
        }
        if (pridePtmName.equalsIgnoreCase("ubiquitination signature dipeptidyl lysine")) {
            return "ubiquitinylation residue";
        }
        return null;
    }

    public static String getSerializationFolder() {
        return SERIALIZATION_FILE_FOLDER;
    }

    public static void setSerializationFolder(String serializationFolder) {
        SERIALIZATION_FILE_FOLDER = serializationFolder;
    }
}

