/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.mascot.FixedModification;
import com.compomics.mascotdatfile.util.mascot.ModificationConversion;
import com.compomics.mascotdatfile.util.mascot.VariableModification;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ModificationList
implements Serializable {
    private static Logger logger = Logger.getLogger(ModificationList.class);
    private Vector iFixedModifications = new Vector(0, 1);
    private Vector iVariableModifications = new Vector(0, 1);
    private Connection iConnection;

    public ModificationList(ArrayList aFModStringArrayList, ArrayList aVModStringArrayList) {
        this.generateVModVector(aVModStringArrayList);
        this.generateFModVector(aFModStringArrayList);
    }

    public ModificationList(ArrayList aFModStringArrayList, ArrayList aVModStringArrayList, String aFixedModifications_ParameterSection) {
        this.generateVModVector(aVModStringArrayList);
        if (aFixedModifications_ParameterSection != null) {
            this.generateFModVector(aFixedModifications_ParameterSection);
        }
    }

    public ModificationList(ArrayList aFModStringArrayList, ArrayList aVModStringArrayList, Connection iConnection) {
        this.iConnection = iConnection;
        this.generateVModVector(aVModStringArrayList);
        this.generateFModVector(aFModStringArrayList);
    }

    public ModificationList(ArrayList aFModStringArrayList, ArrayList aVModStringArrayList, String aFixedModifications_ParameterSection, Connection iConnection) {
        this.iConnection = iConnection;
        this.generateVModVector(aVModStringArrayList);
        if (aFixedModifications_ParameterSection != null) {
            this.generateFModVector(aFixedModifications_ParameterSection);
        }
    }

    private void generateVModVector(ArrayList aVModStringArrayList) {
        StringTokenizer st = null;
        String lStringV = null;
        for (int i = 0; i < aVModStringArrayList.size(); ++i) {
            lStringV = (String)aVModStringArrayList.get(i);
            st = new StringTokenizer(lStringV, ",");
            VariableModification lV = null;
            double lMass = Double.parseDouble(st.nextToken());
            String lTypeAndLocation = st.nextToken().trim();
            String lShortType = this.getShortType(lTypeAndLocation);
            String[] lNameArray = this.parseVariableModName(lTypeAndLocation);
            String lType = lNameArray[0].trim();
            String lLocation = lNameArray[1];
            if (lLocation != null) {
                lLocation = lLocation.trim();
            }
            double lNeutralLoss = Double.parseDouble(st.nextToken());
            int lModificationID = i + 1;
            lV = new VariableModification(lType, lShortType, lMass, lNeutralLoss, lLocation, lModificationID);
            this.iVariableModifications.add(lV);
        }
    }

    private void generateFModVector(ArrayList aFModStringArrayList) {
        StringTokenizer st = null;
        String lStringF = null;
        for (int i = 0; i < aFModStringArrayList.size(); ++i) {
            lStringF = (String)aFModStringArrayList.get(i);
            st = new StringTokenizer(lStringF, ",");
            FixedModification lF = null;
            double lMass = Double.parseDouble(st.nextToken());
            String lTypeAndLocation = st.nextToken().trim();
            String lType = this.parseFixedModName(lTypeAndLocation);
            String lShortType = this.getShortType(lTypeAndLocation);
            String lLocation = st.nextToken();
            int lModificationID = i + 1;
            lF = new FixedModification(lType, lShortType, lMass, lLocation, lModificationID);
            this.iFixedModifications.add(lF);
        }
    }

    private void generateFModVector(String aFixedModifications_ParameterSection) {
        ArrayList<String> lFixedMods = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(aFixedModifications_ParameterSection, ",");
        while (st.hasMoreTokens()) {
            lFixedMods.add(st.nextToken());
        }
        for (int i = 0; i < lFixedMods.size(); ++i) {
            String lStringF = (String)lFixedMods.get(i);
            String lType = lStringF.substring(0, lStringF.indexOf(32));
            String lLocation = lStringF.substring(lStringF.indexOf(40) + 1, lStringF.indexOf(41));
            String lShortType = this.getShortType(lStringF);
            int lModificationID = i + 1;
            FixedModification lF = new FixedModification(lType, lShortType, lLocation, lModificationID);
            this.iFixedModifications.add(lF);
        }
    }

    public Vector getFixedModifications() {
        return this.iFixedModifications;
    }

    public Vector getVariableModifications() {
        return this.iVariableModifications;
    }

    public VariableModification getVariableModificationByModificationID(int aModificationID) {
        int n = 0;
        VariableModification m = null;
        for (int i = 0; i < this.iVariableModifications.size(); ++i) {
            m = (VariableModification)this.iVariableModifications.get(i);
            if (m.getModificationID() != aModificationID) continue;
            n = i;
            break;
        }
        return m;
    }

    private String getShortType(String aKey) {
        if (this.iConnection == null) {
            return ModificationConversion.getShortType(aKey);
        }
        return ModificationConversion.getShortType(aKey, this.iConnection);
    }

    private String[] parseVariableModName(String aName) {
        String[] lNameArray = new String[2];
        int lBeginIndex = aName.lastIndexOf(40);
        if (lBeginIndex > 0) {
            int lEndIndex = aName.lastIndexOf(41);
            lNameArray[0] = aName.substring(0, lBeginIndex);
            lNameArray[1] = aName.substring(lBeginIndex + 1, lEndIndex);
        } else {
            lNameArray[0] = aName;
            lNameArray[1] = null;
        }
        return lNameArray;
    }

    private String parseFixedModName(String aName) {
        int lEndIndex = (aName = aName.trim()).lastIndexOf(40) - 1;
        if (lEndIndex >= 0) {
            aName = aName.substring(0, lEndIndex);
        }
        return aName;
    }
}

