/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_gui;

import com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_gui.DataBridge;
import com.compomics.util.gui.JLabelAndComponentPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SpectrumViewer_Filter_JDialog
extends JDialog {
    private static Logger logger = Logger.getLogger(SpectrumViewer_Filter_JDialog.class);
    DataBridge iTarget = null;
    String iPropsFile = null;
    private JTextField txtThreshold = null;
    private JButton btnApply = null;
    private JButton btnCancel = null;

    public SpectrumViewer_Filter_JDialog(Frame aOwner, DataBridge aTarget, String aTitle, String aPropsFile) throws HeadlessException {
        super(aOwner, aTitle, true);
        this.iTarget = aTarget;
        this.iPropsFile = aPropsFile;
        this.show_Filter_JDialog();
    }

    private void show_Filter_JDialog() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SpectrumViewer_Filter_JDialog.this.btnCancelTriggered();
            }
        });
        this.constructScreen();
        this.tryToLoadParams();
        this.setLocation(100, 100);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    private void constructScreen() {
        this.btnApply = new JButton("Apply");
        this.btnApply.setMnemonic(65);
        this.btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpectrumViewer_Filter_JDialog.this.btnApplyTriggered();
            }
        });
        this.btnApply.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    SpectrumViewer_Filter_JDialog.this.btnApply.requestFocus();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setMnemonic(67);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpectrumViewer_Filter_JDialog.this.btnCancelTriggered();
            }
        });
        this.btnCancel.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    SpectrumViewer_Filter_JDialog.this.btnCancel.requestFocus();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        this.txtThreshold = new JTextField(25);
        this.txtThreshold.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    SpectrumViewer_Filter_JDialog.this.txtThreshold.requestFocus();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        JLabelAndComponentPanel jpanCenter = new JLabelAndComponentPanel(new JLabel[]{new JLabel("Identity threshold (0.05 means 95% confidence).")}, new JTextField[]{this.txtThreshold});
        jpanCenter.setToolTipText("Set an identitythreshold to filter the tree so it only contains PeptideHits scoring above the entered threshold. If you want the tree to list PeptideHits scoring above 95% Confidence, then the input value alpha must be 0.05.\n(Confidence = 1 - alpha)");
        jpanCenter.setBorder(BorderFactory.createTitledBorder("SpectrumViewer Filter Settings."));
        JPanel jpanButtons = new JPanel();
        jpanButtons.setLayout(new BoxLayout(jpanButtons, 0));
        jpanButtons.add(Box.createHorizontalGlue());
        jpanButtons.add(this.btnApply);
        jpanButtons.add(Box.createRigidArea(new Dimension(15, this.btnApply.getHeight())));
        jpanButtons.add(this.btnCancel);
        jpanButtons.add(Box.createRigidArea(new Dimension(10, this.btnCancel.getHeight())));
        JPanel jpanMain = new JPanel();
        jpanMain.setLayout(new BoxLayout(jpanMain, 1));
        jpanMain.add(Box.createVerticalStrut(10));
        jpanMain.add(jpanCenter);
        jpanMain.add(Box.createVerticalGlue());
        jpanMain.add(jpanButtons);
        jpanMain.add(Box.createVerticalStrut(10));
        this.getContentPane().add((Component)jpanMain, "Center");
    }

    public void btnApplyTriggered() {
        double lIdentityThreshold = Double.parseDouble(this.txtThreshold.getText());
        this.iTarget.passFilterSettings(lIdentityThreshold);
        super.pack();
        this.setVisible(false);
        this.dispose();
    }

    public void btnCancelTriggered() {
        this.setVisible(false);
        this.dispose();
    }

    private void tryToLoadParams() {
        if (this.iPropsFile != null) {
            try {
                Properties p = new Properties();
                InputStream is = ClassLoader.getSystemResourceAsStream(this.iPropsFile);
                if (is == null) {
                    is = this.getClass().getClassLoader().getResourceAsStream(this.iPropsFile);
                    if (is == null) {
                        return;
                    }
                    System.out.println("local classloader.");
                }
                p.load(is);
                String lDatfile = p.getProperty("FILTER_THRESHOLD");
                if (lDatfile != null) {
                    this.txtThreshold.setText(lDatfile.trim());
                }
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

