/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import cn.bgi.TableHeader;

public class Spectra {
    private String index;
    private String pepSeq;
    private double score;
    private boolean isScoreHighBetter = true;
    private double qvalue;
    private double fdr;
    private boolean isDecoy;
    private int charge;
    private boolean isSAP;
    private String chargeClassString;
    private String proString;
    private String posString;
    private static String sapPrefixString;
    private static String decoyPrefixString;
    private String mods;
    private double rt;
    private int missc;
    private double parentmass;
    private double mz;
    private double delta_da;
    private double delta_ppm;

    public String getMods() {
        return this.mods;
    }

    public void setMods(String mods) {
        this.mods = mods;
    }

    public double getRt() {
        return this.rt;
    }

    public void setRt(double rt) {
        this.rt = rt;
    }

    public int getMissc() {
        return this.missc;
    }

    public void setMissc(int missc) {
        this.missc = missc;
    }

    public double getParentmass() {
        return this.parentmass;
    }

    public void setParentmass(double parentmass) {
        this.parentmass = parentmass;
    }

    public double getMz() {
        return this.mz;
    }

    public void setMz(double mz) {
        this.mz = mz;
    }

    public double getDelta_da() {
        return this.delta_da;
    }

    public void setDelta_da(double delta_da) {
        this.delta_da = delta_da;
    }

    public double getDelta_ppm() {
        return this.delta_ppm;
    }

    public void setDelta_ppm(double delta_ppm) {
        this.delta_ppm = delta_ppm;
    }

    public static String getDecoyPrefixString() {
        return decoyPrefixString;
    }

    public static void setDecoyPrefixString(String decoyPrefixString) {
        Spectra.decoyPrefixString = decoyPrefixString;
    }

    public Spectra(String indexString) {
        this.setIndex(indexString);
    }

    public void setScoreHighBetter(boolean i) {
        this.isScoreHighBetter = i;
    }

    public void setScore(double s) {
        this.score = s;
    }

    public static String getOutHead() {
        StringBuilder line = new StringBuilder();
        line.append(String.valueOf(TableHeader.SpectraIndex) + "\t");
        line.append(String.valueOf(TableHeader.evalue) + "\t");
        line.append(String.valueOf(TableHeader.charge) + "\t");
        line.append(String.valueOf(TableHeader.pepmass) + "\t");
        line.append(String.valueOf(TableHeader.mz) + "\t");
        line.append(String.valueOf(TableHeader.delta_da) + "\t");
        line.append(String.valueOf(TableHeader.delta_ppm) + "\t");
        line.append(String.valueOf(TableHeader.peptideSeq) + "\t");
        line.append(String.valueOf(TableHeader.decoy) + "\t");
        line.append(String.valueOf(TableHeader.miss) + "\t");
        line.append(String.valueOf(TableHeader.ProteinID) + "\t");
        line.append(String.valueOf(TableHeader.pepPosition) + "\t");
        line.append(String.valueOf(TableHeader.rt) + "\t");
        line.append(String.valueOf(TableHeader.isSAP) + "\t");
        line.append(String.valueOf(TableHeader.mods) + "\t");
        line.append(String.valueOf(TableHeader.fdr) + "\t");
        line.append(TableHeader.qvalue);
        return line.toString();
    }

    public String getOutLine() {
        StringBuilder line = new StringBuilder();
        line.append(String.valueOf(this.getIndex()) + "\t");
        line.append(String.valueOf(this.getScore()) + "\t");
        line.append(String.valueOf(this.getCharge()) + "\t");
        line.append(String.valueOf(this.getParentmass()) + "\t");
        line.append(String.valueOf(this.getMz()) + "\t");
        line.append(String.valueOf(this.getDelta_da()) + "\t");
        line.append(String.valueOf(this.getDelta_ppm()) + "\t");
        line.append(String.valueOf(this.getPepSeq()) + "\t");
        line.append(String.valueOf(this.isDecoy()) + "\t");
        line.append(String.valueOf(this.getMissc()) + "\t");
        line.append(String.valueOf(this.getProString()) + "\t");
        line.append(String.valueOf(this.getPosString()) + "\t");
        line.append(String.valueOf(this.getRt()) + "\t");
        line.append(String.valueOf(this.isSap()) + "\t");
        line.append(String.valueOf(this.getMods()) + "\t");
        line.append(String.valueOf(this.getFDR()) + "\t");
        line.append(this.getQvalue());
        return line.toString();
    }

    public void setIndex(String i) {
        this.index = i;
    }

    public void setPepSeq(String seq) {
        this.pepSeq = seq;
    }

    public void setDecoy(boolean decoy) {
        this.isDecoy = decoy;
    }

    public void setFDR(double f) {
        this.fdr = f;
    }

    public void setQvalue(double f) {
        this.qvalue = f;
    }

    public void setCharge(int c) {
        this.charge = c;
        this.setChargeClass();
    }

    public void setChargeClass() {
        if (this.charge <= 2) {
            this.chargeClassString = "<=2";
        } else if (this.charge == 3) {
            this.chargeClassString = "3";
        } else if (this.charge >= 4) {
            this.chargeClassString = ">=4";
        } else {
            System.out.println("Spectra:" + this.index + ", charge state is not valid:'" + this.charge + "'!");
            System.exit(0);
        }
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isDecoy() {
        return this.isDecoy;
    }

    public int getCharge() {
        return this.charge;
    }

    public double getScore() {
        return this.score;
    }

    public String getChargeClass() {
        return this.chargeClassString;
    }

    public double getFDR() {
        return this.fdr;
    }

    public String getPepSeq() {
        return this.pepSeq;
    }

    public double getQvalue() {
        return this.qvalue;
    }

    public void setSAP(boolean isSAP) {
        this.isSAP = isSAP;
    }

    public String getProString() {
        return this.proString;
    }

    public void setProString(String proString) {
        this.proString = proString;
    }

    public String getPosString() {
        return this.posString;
    }

    public void setPosString(String posString) {
        this.posString = posString;
    }

    public static String getSapPrefixString() {
        return sapPrefixString;
    }

    public static void setSapPrefixString(String prefix) {
        sapPrefixString = prefix;
    }

    public boolean isSap() {
        this.isSAP = true;
        String[] stringArray = this.proString.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String acc = stringArray[n2];
            if (!acc.startsWith(sapPrefixString)) {
                this.isSAP = false;
            }
            ++n2;
        }
        return this.isSAP;
    }

    public boolean isDecoySAP() {
        boolean b = false;
        String[] stringArray = this.proString.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String acc = stringArray[n2];
            if (!this.isDecoy() || !acc.startsWith(String.valueOf(decoyPrefixString) + sapPrefixString)) {
                b = false;
                break;
            }
            b = true;
            ++n2;
        }
        return b;
    }

    public boolean isAnyProFromDecoySAP() {
        boolean b = false;
        String[] stringArray = this.proString.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String acc = stringArray[n2];
            if (this.isDecoy() && acc.startsWith(String.valueOf(decoyPrefixString) + sapPrefixString)) {
                b = true;
            }
            ++n2;
        }
        return b;
    }
}

