## ---- echo=FALSE, warning=FALSE--------------------------------------------
suppressPackageStartupMessages({
    library(MultiAssayExperiment)
    library(HDF5Array)
    library(SummarizedExperiment)
})

## ---- eval = FALSE---------------------------------------------------------
#  library(MultiAssayExperiment)
#  library(HDF5Array)
#  library(SummarizedExperiment)

## --------------------------------------------------------------------------
smallMatrix <- matrix(rnorm(10e5), ncol = 20)

## --------------------------------------------------------------------------
rownames(smallMatrix) <- paste0("GENE", seq_len(nrow(smallMatrix)))
colnames(smallMatrix) <- paste0("SampleID", seq_len(ncol(smallMatrix)))

## --------------------------------------------------------------------------
smallMatrix <- DelayedArray(smallMatrix)
class(smallMatrix)
head(smallMatrix)
dim(smallMatrix)

## --------------------------------------------------------------------------
dataLocation <- system.file("extdata", "exMatrix.h5", package =
                              "MultiAssayExperiment", mustWork = TRUE)
h5ls(dataLocation)
hdf5Data <- HDF5ArraySeed(file = dataLocation, name = "exMatrix")
newDelayedMatrix <- DelayedArray(hdf5Data)
class(newDelayedMatrix)
head(newDelayedMatrix)

## --------------------------------------------------------------------------
HDF5MAE <- MultiAssayExperiment(experiments = list(smallMatrix = smallMatrix))
sampleMap(HDF5MAE)
colData(HDF5MAE)

## --------------------------------------------------------------------------
HDF5SE <- SummarizedExperiment(assays = smallMatrix)
assay(HDF5SE)
MultiAssayExperiment(list(HDF5SE = HDF5SE))

