## ----reading-------------------------------------------------------------
require(IrisSpatialFeatures)
raw_data<- read_raw(path=system.file("extdata", package = "IrisSpatialFeatures"),
                    format='Mantra')

#apply all the thresholds PD1 for T and other cells, PD-L1 for macrophages and tumor cells
dataset <- threshold_dataset(raw_data,
                             marker='PD-Ligand-1 (Opal 690)',
                             marker_name='PDL1',
                             base=c('SOX10+'))
dataset <- threshold_dataset(dataset,
                             marker='PD-1 (Opal 540)',
                             marker_name='PD1',
                             base=c('CD8+','OTHER'))

## ----overview_plots------------------------------------------------------
plot_dir <- file.path(tempdir(),'plots')
if (!file.exists(plot_dir)){
    dir.create(file.path(plot_dir))
}
p <- overview_plot(dataset,outdir=plot_dir,palette=NULL,type='png')

## ----counts--------------------------------------------------------------
get_counts_per_mm2(dataset)
get_counts_per_mm2_noncollapsed(dataset)
get_count_ratios(dataset,'SOX10+ PDL1-','SOX10+ PDL1+')

## ----nearest_neighbor, fig.width=5, fig.height=5-------------------------
dataset <- extract_nearest_neighbor(dataset,min_num_cells=2)
get_nearest_neighbors(dataset,"SOX10+ PDL1+")
p <- plot_nearest_neighbor(dataset,'CD8+ PD1+','SOX10+ PDL1')
p <- plot_nearest_neighbor(dataset,'SOX10+ PDL1+','SOX10+ PDL1-')

#ray plots for 
plot_dir <- file.path(tempdir(),'ray_plots')
if (!file.exists(plot_dir)){
    dir.create(file.path(plot_dir))
}
neighbor_ray_plot(dataset,from_type='CD8+ PD1+',to_type='SOX10+ PDL1+',plot_dir=plot_dir,format ='pdf')

## ----interaction_analysis, fig.width=7, fig.height=7---------------------
dataset <- extract_interactions(dataset)
get_interactions(dataset,'SOX10+ PDL1+')

#plotting interaction summaries
p <- plot_interactions(dataset,'SOX10+ PDL1+',xlim_fix=4)

#plotting interaction maps
int_markers <- c('CD8+ PD1+','SOX10+ PDL1+')
int_marker_cols <- c('#fc5858','#66c2a4')
silent_markers <- c('CD8+ PD1-','SOX10+ PDL1-' )
silent_col=c('#fff7bc','#a6bddb')
plot_dir <- file.path(tempdir(),'interaction_maps')
if (!file.exists(plot_dir)){
    dir.create(file.path(plot_dir))
}
p <- interaction_maps(dataset,int_markers,int_marker_cols,silent_markers,
                      silent_col,outdir=plot_dir)

## ----proximity_analysis, fig.width=7, fig.height=7-----------------------
dataset <- extract_proximity(dataset,only_closest=TRUE,radii=25)
p <- plot_proximities(dataset,"SOX10+ PDL1-",xlim_fix=3)



