## ---- echo=FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  tidy = TRUE,
  collapse = TRUE, 
  comment = "#>"
  )

## ------------------------------------------------------------------------
library("HDTD")
data(VEGFmouse)
dim(VEGFmouse)
rownames(VEGFmouse)

## ------------------------------------------------------------------------
colnames(VEGFmouse)[1:18]

## ------------------------------------------------------------------------
meanmat.ts(VEGFmouse,40,group.sizes=9,voi="columns")

## ------------------------------------------------------------------------
colnames(VEGFmouse)[1:9]
VEGForder <- orderdata(VEGFmouse,40,order.cols=c(1,4,5,8,2,3,6,7,9)) 
colnames(VEGForder)[1:9]

## ------------------------------------------------------------------------
meanmat.ts(VEGForder,40,group.sizes=c(4,1,1,1,1,1),voi="columns")

## ------------------------------------------------------------------------
sample.mean <- meanmat.hat(VEGFmouse,40)
sample.mean

## ------------------------------------------------------------------------
head(round(sample.mean$estmeanmat,4),n=10)

## ------------------------------------------------------------------------
estcovmat <- covmat.hat(datamat = VEGFmouse, N = 40, shrink = "both", centered = FALSE)
estcovmat

## ------------------------------------------------------------------------
round(estcovmat$cols.covmat,4)

## ------------------------------------------------------------------------
covmat.ts(datamat = VEGFmouse, N = 40, voi = "columns", centered = FALSE)

## ------------------------------------------------------------------------
print(citation("HDTD"),bibtex=TRUE)

