/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import java.util.List;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Last
extends AbstractFunction {
    public Last() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.ANY_LIST, "list", "Any non-empty list.")});
    }

    public String getName() {
        return "LAST";
    }

    public String getFunctionSummary() {
        return "Returns the last entry in a list.";
    }

    public Class getReturnType() {
        return Object.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        List list = (List)args[0];
        if (list.isEmpty()) {
            throw new IllegalArgumentException("can't get the last argument of an empty list in a call to LAST()!");
        }
        Object lastElement = list.get(list.size() - 1);
        Object retVal = FunctionUtil.translateObjectType(lastElement);
        if (retVal == null) {
            throw new IllegalArgumentException("bad list element type: " + lastElement.getClass() + " in a call to LAST()!");
        }
        return retVal;
    }
}

