/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.ding.DingNetworkView;
import cytoscape.giny.CytoscapeFingRootGraph;
import cytoscape.view.CyNetworkView;
import ding.view.DGraphView;
import giny.view.GraphView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class DefaultViewPanel
extends JPanel {
    private static final int PADDING = 20;
    private static final CyNetworkView view;
    private static final CyNetwork dummyNet;
    private Color background = Cytoscape.getVisualMappingManager().getVisualStyle().getGlobalAppearanceCalculator().getDefaultBackgroundColor();
    private static final DefaultViewPanel panel;
    private static final CytoscapeFingRootGraph dummyGraph;
    private static final CyNode source;
    private static final CyNode target;
    private static final CyEdge edge;

    protected static DefaultViewPanel getDefaultViewPanel() {
        return panel;
    }

    private DefaultViewPanel() {
        this.setBackground(this.background);
    }

    protected void updateBackgroungColor(Color newColor) {
        this.background = newColor;
        this.setBackground(this.background);
        this.repaint();
    }

    protected void updateView() {
        Cytoscape.getVisualMappingManager().setNetworkView(view);
        view.setVisualStyle(Cytoscape.getVisualMappingManager().getVisualStyle().getName());
        Dimension panelSize = this.getSize();
        ((DGraphView)((Object)view)).getCanvas().setSize(new Dimension((int)panelSize.getWidth() - 20, (int)panelSize.getHeight() - 20));
        view.fitContent();
        Component canvas = view.getComponent();
        for (MouseListener listener : canvas.getMouseListeners()) {
            canvas.removeMouseListener(listener);
        }
        this.removeAll();
        this.add(canvas);
        canvas.setLocation(10, 10);
        Cytoscape.getVisualMappingManager().applyAppearances();
        canvas.setBackground(this.background);
    }

    public GraphView getView() {
        return view;
    }

    static {
        dummyGraph = new CytoscapeFingRootGraph();
        source = (CyNode)dummyGraph.getNode(dummyGraph.createNode());
        source.setIdentifier("Source");
        target = (CyNode)dummyGraph.getNode(dummyGraph.createNode());
        target.setIdentifier("Target");
        edge = (CyEdge)dummyGraph.getEdge(dummyGraph.createEdge(source, target));
        edge.setIdentifier("dummyInteraction");
        ArrayList<CyNode> nodes = new ArrayList<CyNode>();
        ArrayList<CyEdge> edges = new ArrayList<CyEdge>();
        nodes.add(source);
        nodes.add(target);
        edges.add(edge);
        dummyNet = dummyGraph.createNetwork(nodes, edges);
        dummyNet.setTitle("Default Appearance");
        view = new DingNetworkView(dummyNet, "Default Appearence");
        view.setIdentifier(dummyNet.getIdentifier());
        view.setTitle(dummyNet.getTitle());
        view.getNodeView(source).setOffset(0.0, 0.0);
        view.getNodeView(target).setOffset(150.0, 10.0);
        panel = new DefaultViewPanel();
        CyAttributes nodeAttr = Cytoscape.getNodeAttributes();
        nodeAttr.setAttribute("Source", "hiddenLabel", "Source");
        nodeAttr.setAttribute("Target", "hiddenLabel", "Target");
        nodeAttr.setUserVisible("hiddenLabel", false);
        nodeAttr.setUserEditable("hiddenLabel", false);
        CyAttributes edgeAttr = Cytoscape.getEdgeAttributes();
        edgeAttr.setUserVisible("dummyInteraction", false);
        edgeAttr.setUserEditable("dummyInteraction", false);
    }
}

