/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic.impl.vector;

import cytoscape.render.stateful.CustomGraphic;
import cytoscape.visual.customgraphic.IDGenerator;
import cytoscape.visual.customgraphic.impl.DLayer;
import cytoscape.visual.customgraphic.impl.vector.GradientLayerCustomGraphics;
import cytoscape.visual.customgraphic.paint.GradientPaintFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

public class GradientOvalLayer
extends GradientLayerCustomGraphics {
    private static final String NAME = "Glossy Oval Layer";

    public GradientOvalLayer() {
        this(IDGenerator.getIDGenerator().getNextId(), NAME);
    }

    public GradientOvalLayer(Long id, String name) {
        super(id, name);
    }

    protected void renderImage(Graphics graphics) {
        super.renderImage(graphics);
        Graphics2D g2d = (Graphics2D)graphics;
        this.update();
        g2d.setPaint(this.paintFactory.getPaint(this.bound.getBounds2D()));
        g2d.fillOval(this.rendered.getMinX(), this.rendered.getMinY(), this.width, this.height);
    }

    public void update() {
        this.layers.clear();
        this.bound = new Ellipse2D.Double(-this.width / 2, -this.height / 2, this.width, this.height);
        this.paintFactory = new GradientPaintFactory((Color)this.c1.getValue(), (Color)this.c2.getValue());
        CustomGraphic cg = new CustomGraphic(this.bound, this.paintFactory);
        DLayer layer = new DLayer(cg, 1);
        this.layers.add(layer);
    }
}

