/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.util.GraphSetUtils;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphSetUtilsTest
extends TestCase {
    protected List<CyNetwork> networklist;
    protected int a;
    protected int b;
    protected int c;
    protected int d;
    protected int e;
    protected int ab;
    protected int bc;
    protected int ac;
    protected int bd;
    protected int be;
    protected int cd;
    protected CyNetwork net1;
    protected CyNetwork net2;

    @Override
    public void setUp() throws Exception {
        this.networklist = new ArrayList<CyNetwork>();
        CytoscapeRootGraph root = Cytoscape.getRootGraph();
        this.a = root.createNode();
        this.b = root.createNode();
        this.c = root.createNode();
        this.d = root.createNode();
        this.e = root.createNode();
        int[] nodes1 = new int[]{this.a, this.b, this.c, this.d};
        int[] nodes2 = new int[]{this.b, this.c, this.d, this.e};
        this.ab = root.createEdge(this.a, this.b, true);
        this.bc = root.createEdge(this.b, this.c, true);
        this.ac = root.createEdge(this.a, this.c, true);
        this.bd = root.createEdge(this.b, this.d, true);
        this.be = root.createEdge(this.b, this.e, true);
        this.cd = root.createEdge(this.c, this.d, true);
        int[] edges1 = new int[]{this.ab, this.bc, this.ac, this.bd};
        int[] edges2 = new int[]{this.bd, this.bc, this.be};
        this.net1 = Cytoscape.createNetwork(nodes1, edges1, "graph1");
        this.net2 = Cytoscape.createNetwork(nodes2, edges2, "graph2");
        this.networklist.add(0, this.net1);
        this.networklist.add(1, this.net2);
    }

    public void testNetwork() {
        GraphSetUtilsTest.assertTrue(this.net1.containsNode(this.net1.getNode(this.a)));
        GraphSetUtilsTest.assertTrue(this.net1.containsNode(this.net1.getNode(this.b)));
        GraphSetUtilsTest.assertTrue(this.net1.containsNode(this.net1.getNode(this.c)));
        GraphSetUtilsTest.assertTrue(this.net1.containsNode(this.net1.getNode(this.d)));
        GraphSetUtilsTest.assertTrue(this.net2.containsNode(this.net2.getNode(this.b)));
        GraphSetUtilsTest.assertTrue(this.net2.containsNode(this.net2.getNode(this.c)));
        GraphSetUtilsTest.assertTrue(this.net2.containsNode(this.net2.getNode(this.d)));
        GraphSetUtilsTest.assertTrue(this.net2.containsNode(this.net2.getNode(this.e)));
        GraphSetUtilsTest.assertTrue(this.net1.containsEdge(this.net1.getEdge(this.ab)));
        GraphSetUtilsTest.assertTrue(this.net1.containsEdge(this.net1.getEdge(this.bc)));
        GraphSetUtilsTest.assertTrue(this.net1.containsEdge(this.net1.getEdge(this.ac)));
        GraphSetUtilsTest.assertTrue(this.net1.containsEdge(this.net1.getEdge(this.bd)));
        GraphSetUtilsTest.assertTrue(this.net2.containsEdge(this.net2.getEdge(this.bd)));
        GraphSetUtilsTest.assertTrue(this.net2.containsEdge(this.net2.getEdge(this.bc)));
        GraphSetUtilsTest.assertTrue(this.net2.containsEdge(this.net2.getEdge(this.be)));
    }

    @Override
    public void tearDown() throws Exception {
    }

    public void testIntersection() {
        CyNetwork n = GraphSetUtils.createIntersectionGraph(this.networklist, true, "intersect");
        GraphSetUtilsTest.assertTrue(n.containsEdge(n.getEdge(this.bc)));
        GraphSetUtilsTest.assertTrue(n.containsEdge(n.getEdge(this.bd)));
        GraphSetUtilsTest.assertNull(n.getEdge(this.ab));
        GraphSetUtilsTest.assertNull(n.getEdge(this.be));
        GraphSetUtilsTest.assertTrue(n.containsNode(n.getNode(this.b)));
        GraphSetUtilsTest.assertTrue(n.containsNode(n.getNode(this.c)));
        GraphSetUtilsTest.assertTrue(n.containsNode(n.getNode(this.d)));
        GraphSetUtilsTest.assertNull(n.getNode(this.a));
        GraphSetUtilsTest.assertNull(n.getNode(this.e));
    }

    public void testDifference() {
        CyNetwork x = GraphSetUtils.createDifferenceGraph(this.networklist, true, "difference");
        GraphSetUtilsTest.assertTrue(x.containsNode(x.getNode(this.a)));
        GraphSetUtilsTest.assertTrue(x.containsNode(x.getNode(this.b)));
        GraphSetUtilsTest.assertTrue(x.containsNode(x.getNode(this.c)));
        GraphSetUtilsTest.assertNull(x.getNode(this.d));
        GraphSetUtilsTest.assertNull(x.getNode(this.e));
        GraphSetUtilsTest.assertTrue(x.containsEdge(x.getEdge(this.ab)));
        GraphSetUtilsTest.assertNull(x.getEdge(this.bc));
        GraphSetUtilsTest.assertTrue(x.containsEdge(x.getEdge(this.ac)));
        GraphSetUtilsTest.assertNull(x.getEdge(this.be));
        GraphSetUtilsTest.assertNull(x.getEdge(this.bd));
    }

    public void testDifference2() {
        CyNetwork x = GraphSetUtils.createDifferenceGraph2(this.networklist, true, "difference2");
        GraphSetUtilsTest.assertTrue(x.containsNode(x.getNode(this.a)));
        GraphSetUtilsTest.assertNull(x.getNode(this.b));
        GraphSetUtilsTest.assertNull(x.getNode(this.c));
        GraphSetUtilsTest.assertNull(x.getNode(this.d));
        GraphSetUtilsTest.assertNull(x.getNode(this.e));
        GraphSetUtilsTest.assertNull(x.getEdge(this.ab));
        GraphSetUtilsTest.assertNull(x.getEdge(this.bc));
        GraphSetUtilsTest.assertNull(x.getEdge(this.ac));
        GraphSetUtilsTest.assertNull(x.getEdge(this.be));
        GraphSetUtilsTest.assertNull(x.getEdge(this.bd));
    }

    public void testDifference_2() {
        CyNetwork x = GraphSetUtils.createDifferenceGraph(this.createNetworks_2(), true, "difference");
        GraphSetUtilsTest.assertTrue(x.containsNode(x.getNode(this.c)));
        GraphSetUtilsTest.assertTrue(x.containsNode(x.getNode(this.a)));
        GraphSetUtilsTest.assertTrue(x.containsNode(x.getNode(this.b)));
        GraphSetUtilsTest.assertNull(x.getEdge(this.ab));
        GraphSetUtilsTest.assertTrue(x.containsEdge(x.getEdge(this.ac)));
        GraphSetUtilsTest.assertTrue(x.containsEdge(x.getEdge(this.bc)));
    }

    public void testDifference2_2() {
        CyNetwork x = GraphSetUtils.createDifferenceGraph2(this.createNetworks_2(), true, "difference2");
        GraphSetUtilsTest.assertTrue(x.containsNode(x.getNode(this.c)));
        GraphSetUtilsTest.assertNull(x.getNode(this.a));
        GraphSetUtilsTest.assertNull(x.getNode(this.b));
        GraphSetUtilsTest.assertNull(x.getEdge(this.ab));
        GraphSetUtilsTest.assertNull(x.getEdge(this.ac));
        GraphSetUtilsTest.assertNull(x.getEdge(this.bc));
    }

    public void testUnion() {
        CyNetwork y = GraphSetUtils.createUnionGraph(this.networklist, true, "union");
        GraphSetUtilsTest.assertTrue(y.containsEdge(y.getEdge(this.ab)));
        GraphSetUtilsTest.assertTrue(y.containsEdge(y.getEdge(this.bc)));
        GraphSetUtilsTest.assertTrue(y.containsEdge(y.getEdge(this.ac)));
        GraphSetUtilsTest.assertTrue(y.containsEdge(y.getEdge(this.bd)));
        GraphSetUtilsTest.assertTrue(y.containsNode(y.getNode(this.a)));
        GraphSetUtilsTest.assertTrue(y.containsNode(y.getNode(this.b)));
        GraphSetUtilsTest.assertTrue(y.containsNode(y.getNode(this.c)));
        GraphSetUtilsTest.assertTrue(y.containsNode(y.getNode(this.d)));
        GraphSetUtilsTest.assertTrue(y.containsNode(y.getNode(this.e)));
    }

    private List<CyNetwork> createNetworks_2() {
        int[] nodes1 = new int[]{this.a, this.b, this.c};
        int[] nodes2 = new int[]{this.a, this.b};
        int[] edges1 = new int[]{this.ab, this.bc, this.ac};
        int[] edges2 = new int[]{this.ab};
        ArrayList<CyNetwork> result = new ArrayList<CyNetwork>();
        result.add(Cytoscape.createNetwork(nodes1, edges1, "graph1"));
        result.add(Cytoscape.createNetwork(nodes2, edges2, "graph2"));
        return result;
    }
}

