/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.VisualStyle;
import giny.model.Edge;
import giny.model.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class GraphSetUtils {
    protected static final int UNION = 0;
    protected static final int INTERSECTION = 1;
    protected static final int DIFFERENCE = 2;
    protected static final int DIFFERENCE2 = 3;

    public static CyNetwork createUnionGraph(List networkList, boolean copyView, String title) {
        return GraphSetUtils.performNetworkOperation(networkList, 0, copyView, title);
    }

    public static CyNetwork createIntersectionGraph(List networkList, boolean copyView, String title) {
        return GraphSetUtils.performNetworkOperation(networkList, 1, copyView, title);
    }

    public static CyNetwork createDifferenceGraph(List networkList, boolean copyView, String title) {
        return GraphSetUtils.performNetworkOperation(networkList, 2, copyView, title);
    }

    public static CyNetwork createDifferenceGraph2(List networkList, boolean copyView, String title) {
        return GraphSetUtils.performNetworkOperation(networkList, 3, copyView, title);
    }

    protected static CyNetwork performNetworkOperation(List networkList, int operation, boolean copyView, String title) {
        if (networkList.size() == 0) {
            throw new IllegalArgumentException("Must have at least one network in the list");
        }
        int[] new_nodes = null;
        int[] new_edges = null;
        switch (operation) {
            case 0: {
                new_nodes = GraphSetUtils.unionizeNodes(networkList);
                new_edges = GraphSetUtils.unionizeEdges(networkList);
                break;
            }
            case 1: {
                new_nodes = GraphSetUtils.intersectNodes(networkList);
                new_edges = GraphSetUtils.intersectEdges(networkList);
                CyLogger.getLogger().warn("number of intersecting nodes is " + new_nodes.length);
                break;
            }
            case 2: {
                new_edges = GraphSetUtils.differenceEdges(networkList);
                new_nodes = GraphSetUtils.differenceNodes(networkList, new_edges);
                break;
            }
            case 3: {
                new_nodes = GraphSetUtils.differenceNodes2(networkList);
                new_edges = GraphSetUtils.differenceEdges2(networkList, new_nodes);
                break;
            }
            default: {
                throw new IllegalArgumentException("Specified invalid graph set operation");
            }
        }
        CyNetwork newNetwork = Cytoscape.createNetwork(new_nodes, new_edges, title);
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        CyNetworkView firstView = Cytoscape.getNetworkView(firstNetwork.getIdentifier());
        if (firstView != null && firstView != Cytoscape.getNullNetworkView()) {
            VisualStyle firstVS = firstView.getVisualStyle();
            CyNetworkView newView = Cytoscape.getNetworkView(newNetwork.getIdentifier());
            if (newView != null && newView != Cytoscape.getNullNetworkView() && firstVS != null) {
                newView.setVisualStyle(firstVS.getName());
                Cytoscape.getVisualMappingManager().setVisualStyle(firstVS);
                newView.redrawGraph(true, true);
            }
        }
        return newNetwork;
    }

    protected static int[] differenceEdges(List networkList) {
        Vector<Edge> edges = new Vector<Edge>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator edgeIt = firstNetwork.edgesIterator();
        block0: while (edgeIt.hasNext()) {
            Edge currentEdge = (Edge)edgeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (currentNetwork.containsEdge(currentEdge)) continue block0;
            }
            edges.add(currentEdge);
        }
        int[] result = new int[edges.size()];
        int idx = 0;
        for (Edge currentEdge : edges) {
            result[idx] = currentEdge.getRootGraphIndex();
            ++idx;
        }
        return result;
    }

    protected static int[] differenceNodes2(List networkList) {
        Vector<Node> nodes = new Vector<Node>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator nodeIt = firstNetwork.nodesIterator();
        block0: while (nodeIt.hasNext()) {
            Node currentNode = (Node)nodeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (currentNetwork.containsNode(currentNode)) continue block0;
            }
            nodes.add(currentNode);
        }
        int[] result = new int[nodes.size()];
        int idx = 0;
        for (Node currentNode : nodes) {
            result[idx] = currentNode.getRootGraphIndex();
            ++idx;
        }
        return result;
    }

    protected static int[] differenceNodes(List networkList, int[] edges) {
        HashSet<Node> nodes = new HashSet<Node>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator nodeIt = firstNetwork.nodesIterator();
        block0: while (nodeIt.hasNext()) {
            Node currentNode = (Node)nodeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (currentNetwork.containsNode(currentNode)) continue block0;
            }
            nodes.add(currentNode);
        }
        for (int idx = 0; idx < edges.length; ++idx) {
            nodes.add(firstNetwork.getNode(firstNetwork.getEdgeSourceIndex(edges[idx])));
            nodes.add(firstNetwork.getNode(firstNetwork.getEdgeTargetIndex(edges[idx])));
        }
        int[] result = new int[nodes.size()];
        int idx = 0;
        for (Node currentNode : nodes) {
            result[idx] = currentNode.getRootGraphIndex();
            ++idx;
        }
        return result;
    }

    protected static int[] differenceEdges2(List networkList, int[] nodes) {
        HashSet<Edge> edges = new HashSet<Edge>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator edgeIt = firstNetwork.edgesIterator();
        block0: while (edgeIt.hasNext()) {
            Edge currentEdge = (Edge)edgeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (currentNetwork.containsEdge(currentEdge)) continue block0;
            }
            edges.add(currentEdge);
        }
        HashSet<Integer> knownNodes = new HashSet<Integer>(nodes.length);
        for (int nodeIndex : nodes) {
            knownNodes.add(nodeIndex);
        }
        ArrayList<Integer> acceptableEdges = new ArrayList<Integer>(edges.size());
        for (Edge edgeCandidate : edges) {
            if (!knownNodes.contains(edgeCandidate.getSource()) || !knownNodes.contains(edgeCandidate.getTarget())) continue;
            acceptableEdges.add(edgeCandidate.getRootGraphIndex());
        }
        int[] result = new int[acceptableEdges.size()];
        int index = 0;
        Iterator i$ = acceptableEdges.iterator();
        while (i$.hasNext()) {
            int edgeIndex = (Integer)i$.next();
            result[index++] = edgeIndex;
        }
        return result;
    }

    protected static int[] intersectNodes(List networkList) {
        Vector<Node> nodes = new Vector<Node>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator nodeIt = firstNetwork.nodesIterator();
        block0: while (nodeIt.hasNext()) {
            Node currentNode = (Node)nodeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (!currentNetwork.containsNode(currentNode)) continue block0;
            }
            nodes.add(currentNode);
        }
        int[] result = new int[nodes.size()];
        int idx = 0;
        for (Node currentNode : nodes) {
            result[idx] = currentNode.getRootGraphIndex();
            ++idx;
        }
        return result;
    }

    protected static int[] intersectEdges(List networkList) {
        Vector<Edge> edges = new Vector<Edge>();
        CyNetwork firstNetwork = (CyNetwork)networkList.get(0);
        Iterator edgeIt = firstNetwork.edgesIterator();
        block0: while (edgeIt.hasNext()) {
            Edge currentEdge = (Edge)edgeIt.next();
            for (int idx = 1; idx < networkList.size(); ++idx) {
                CyNetwork currentNetwork = (CyNetwork)networkList.get(idx);
                if (!currentNetwork.containsEdge(currentEdge)) continue block0;
            }
            edges.add(currentEdge);
        }
        int[] result = new int[edges.size()];
        int idx = 0;
        for (Edge currentEdge : edges) {
            result[idx] = currentEdge.getRootGraphIndex();
            ++idx;
        }
        return result;
    }

    protected static int[] unionizeNodes(List networkList) {
        Iterator nodeIt;
        HashSet<Integer> nodes = new HashSet<Integer>();
        for (CyNetwork currentNetwork : networkList) {
            nodeIt = currentNetwork.nodesIterator();
            while (nodeIt.hasNext()) {
                nodes.add(new Integer(((Node)nodeIt.next()).getRootGraphIndex()));
            }
        }
        int[] result = new int[nodes.size()];
        int idx = 0;
        nodeIt = nodes.iterator();
        while (nodeIt.hasNext()) {
            result[idx] = (Integer)nodeIt.next();
            ++idx;
        }
        return result;
    }

    protected static int[] unionizeEdges(List networkList) {
        Iterator edgeIt;
        HashSet<Integer> edges = new HashSet<Integer>();
        for (CyNetwork currentNetwork : networkList) {
            edgeIt = currentNetwork.edgesIterator();
            while (edgeIt.hasNext()) {
                edges.add(new Integer(((Edge)edgeIt.next()).getRootGraphIndex()));
            }
        }
        int[] result = new int[edges.size()];
        int idx = 0;
        edgeIt = edges.iterator();
        while (edgeIt.hasNext()) {
            result[idx] = (Integer)edgeIt.next();
            ++idx;
        }
        return result;
    }
}

