/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology;

import cytoscape.Cytoscape;
import cytoscape.data.ontology.Ontology;
import cytoscape.data.ontology.OntologyTerm;
import java.util.ArrayList;
import java.util.Set;
import junit.framework.TestCase;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.utils.ChangeVetoException;

public class OntologyTest
extends TestCase {
    private Ontology onto;
    private OntologyTerm newTerm1;
    private OntologyTerm newTerm2;

    protected void setUp() throws Exception {
        super.setUp();
        this.onto = new Ontology("Sample Ontology", "GO", "Fake ontology", null);
        Cytoscape.buildOntologyServer();
        Cytoscape.getOntologyServer().addOntology(this.onto);
        this.newTerm1 = new OntologyTerm("GO Term1", "Sample Ontology", "This is a fake description 1.");
        this.onto.add(this.newTerm1);
        this.newTerm2 = new OntologyTerm("GO Term2", "Sample Ontology", "This is a fake description 2.");
        this.onto.add(this.newTerm2);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.onto = null;
    }

    public void testGetName() {
        OntologyTest.assertNotNull(this.onto.getName());
        OntologyTest.assertEquals("Sample Ontology", this.onto.getName());
    }

    public void testGetCurator() {
        OntologyTest.assertNotNull(this.onto.getCurator());
        OntologyTest.assertEquals("GO", this.onto.getCurator());
    }

    public void testAdd() {
        OntologyTerm newTerm3 = new OntologyTerm("GO Term3", "Sample Ontology", "This is a fake description 3.");
        this.onto.add(newTerm3);
        OntologyTerm newTerm4 = new OntologyTerm("GO Term4", "Sample Ontology", "This is a fake description 4.");
        this.onto.add(newTerm4);
        OntologyTest.assertEquals(4, this.onto.size());
    }

    public void testSize() {
        OntologyTest.assertEquals(2, this.onto.size());
    }

    public void testGetTerms() {
        Set terms = this.onto.getTerms();
        ArrayList<String> termNames = new ArrayList<String>();
        OntologyTest.assertNotNull(terms);
        OntologyTest.assertEquals(2, terms.size());
        for (Term term : terms) {
            System.out.println("Term in Set = " + term.getName());
            termNames.add(term.getName());
        }
        OntologyTest.assertTrue(termNames.contains("GO Term2"));
        OntologyTest.assertTrue(termNames.contains("GO Term1"));
        OntologyTest.assertFalse(terms.contains(new OntologyTerm("foo", "Sample Ontology", null)));
    }

    public void testContainsTerm() {
        OntologyTest.assertTrue(this.onto.containsTerm("GO Term1"));
        OntologyTest.assertTrue(this.onto.containsTerm("GO Term2"));
        OntologyTest.assertFalse(this.onto.containsTerm("foo"));
    }

    public void testGetTerm() {
        OntologyTerm target = this.onto.getTerm("GO Term1");
        OntologyTest.assertNotNull(target);
        OntologyTest.assertEquals(this.newTerm1.getName(), target.getName());
        OntologyTest.assertEquals(this.newTerm1.getDescription(), target.getDescription());
        OntologyTest.assertEquals(this.newTerm1.getOntology().getName(), target.getOntology().getName());
    }

    public void testToString() {
        String message = this.onto.toString();
        System.out.println("# Ontology toString() method = " + message);
        OntologyTest.assertEquals("Ontology Name: Sample Ontology, Curator: GO, Description: Fake ontology", message);
    }

    public void testContainsTriple() {
    }

    public void testCreateTermStringString() {
        try {
            Term testTerm = this.onto.createTerm("TestTerm1", "Test Term description1.");
            OntologyTest.assertNotNull(testTerm);
            OntologyTest.assertEquals("TestTerm1", testTerm.getName());
            OntologyTest.assertEquals("Test Term description1.", testTerm.getDescription());
            OntologyTest.assertEquals(this.onto.getName(), testTerm.getOntology().getName());
        }
        catch (AlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ChangeVetoException e) {
            e.printStackTrace();
        }
    }

    public void testCreateTermStringStringObjectArray() {
    }

    public void testCreateTriple() {
        Term object = null;
        Term subject = null;
        OntologyTerm predicate = null;
        try {
            object = this.onto.createTerm("object", "Fro triple test");
            subject = this.onto.createTerm("subject", "test subject.");
            predicate = new OntologyTerm("pred", this.onto.getName(), "pred test");
        }
        catch (AlreadyExistsException e1) {
            e1.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (ChangeVetoException e1) {
            e1.printStackTrace();
        }
        try {
            Triple triple = this.onto.createTriple(subject, object, predicate, "Sample Triple", "Test triple creation.");
            OntologyTest.assertNotNull(triple);
            OntologyTest.assertEquals("Sample Triple", triple.getName());
            OntologyTest.assertEquals("Test triple creation.", triple.getDescription());
        }
        catch (AlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (ChangeVetoException e) {
            e.printStackTrace();
        }
    }

    public void testDeleteTerm() {
        OntologyTerm toBeDeleted = this.onto.getTerm("GO Term1");
        try {
            this.onto.deleteTerm(toBeDeleted);
            OntologyTest.assertEquals(1, this.onto.size());
        }
        catch (ChangeVetoException e) {
            e.printStackTrace();
        }
    }

    public void testGetDescription() {
        String desc = this.onto.getDescription();
        OntologyTest.assertEquals("Fake ontology", desc);
    }

    public void testGetTriples() {
    }
}

