/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.ExportFilter;
import cytoscape.actions.ExportTask;
import cytoscape.dialogs.ExportBitmapOptionsDialog;
import cytoscape.util.export.BitmapExporter;
import cytoscape.view.CyNetworkView;
import cytoscape.view.InternalFrameComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;

class BitmapExportFilter
extends ExportFilter {
    private final String extension;

    public BitmapExportFilter(String extension, String description) {
        super(extension, description);
        this.extension = extension;
    }

    public void export(final CyNetworkView view, final FileOutputStream stream) {
        InternalFrameComponent ifc = Cytoscape.getDesktop().getNetworkViewManager().getInternalFrameComponent(view);
        final ExportBitmapOptionsDialog dialog = new ExportBitmapOptionsDialog(ifc.getWidth(), ifc.getHeight());
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BitmapExporter exporter = new BitmapExporter(BitmapExportFilter.this.extension, dialog.getZoom());
                dialog.dispose();
                ExportTask.run("Exporting to " + BitmapExportFilter.this.extension, exporter, view, stream);
            }
        };
        dialog.addActionListener(listener);
        dialog.setVisible(true);
    }
}

