/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import javax.swing.filechooser.FileSystemView;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.StringValue;

public final class StringValues {
    public static final StringValue EMPTY = new StringValue(){

        public String getString(Object value) {
            return "";
        }
    };
    public static final StringValue TO_STRING = new StringValue(){

        public String getString(Object value) {
            return value != null ? value.toString() : EMPTY.getString(value);
        }
    };
    public static final StringValue FILE_NAME = new StringValue(){

        public String getString(Object value) {
            if (value instanceof File) {
                FileSystemView fsv = FileSystemView.getFileSystemView();
                return fsv.getSystemDisplayName((File)value);
            }
            return TO_STRING.getString(value);
        }
    };
    public static final StringValue FILE_TYPE = new StringValue(){

        public String getString(Object value) {
            if (value instanceof File) {
                FileSystemView fsv = FileSystemView.getFileSystemView();
                return fsv.getSystemTypeDescription((File)value);
            }
            return TO_STRING.getString(value);
        }
    };
    public static final FormatStringValue DATE_TO_STRING = new FormatStringValue(){

        public String getString(Object value) {
            if (this.format == null) {
                this.format = DateFormat.getDateInstance();
            }
            return super.getString(value);
        }
    };
    public static final FormatStringValue NUMBER_TO_STRING = new FormatStringValue(){

        public String getString(Object value) {
            if (this.format == null) {
                this.format = NumberFormat.getNumberInstance();
            }
            return super.getString(value);
        }
    };

    private StringValues() {
    }
}

